/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 05-Jul-2004
 */
package org.wellquite.kenya.stackMachine.types.interfaces;

/**
 * The basic type which is pushed and popped on the stack. In general you
 * shouldn't try to create these types yourself, use the various Factories
 * provided.
 * 
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public interface IType extends Cloneable {

    /**
     * Indicates whether the value of the type instance has been set.
     * 
     * @return true or false.
     */
    boolean valueSet();

    /**
     * Returns a string representing the value of the type instance. This does
     * not include any information about the nature of the type itself (unlike
     * toString()).
     * 
     * @return A String.
     */
    String valueToString();
    
    /**
     * Returns the name of this type, e.g. "int"
     * @return
     */
    String getTypeName();
    
    /**
     * returns a shallow copy of this IType and should simply
     * call super.clone() and return the result. This enables callers
     * to take snapshots of types that will not
     * be modified by a running StackMachine.
     * <br>Since this interface extends Cloneable, any
     * CloneNotSupportedExceptions can safely be ignored.
     * @return a shallow clone of this IType
     * @throws CloneNotSupportedException never thrown if
     *          this interface is implemented
     */
    public Object clone() throws CloneNotSupportedException;
}