/*
 * Decompiled with CFR 0.152.
 */
package kenya;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileLoaderSaver {
    private String path = "";
    private String name = "";
    private String dir = "";
    private static Pattern tabElimination = Pattern.compile("\\t", 8);

    public synchronized String loadFile(String path) {
        File file = new File(path);
        this.name = file.getName();
        this.dir = file.getParent();
        if (file.isFile() && file.canRead()) {
            this.path = path;
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                StringBuffer contents = new StringBuffer();
                while (reader.ready()) {
                    contents.append((char)reader.read());
                }
                reader.close();
                String text = contents.toString();
                Matcher match = tabElimination.matcher(text);
                return match.replaceAll("  ");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return "";
            }
            catch (IOException e) {
                e.printStackTrace();
                return "";
            }
        }
        return "";
    }

    public synchronized void saveFile(String text) {
        if (this.path.equals("")) {
            throw new IllegalStateException("Attempt to save file to unknown path.");
        }
        File file = new File(this.path);
        this.name = file.getName();
        this.dir = file.getParent();
        if (file.isFile() && file.canWrite() || !file.exists()) {
            try {
                FileWriter writer = new FileWriter(file);
                writer.write(text);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("Unable to write to " + file.getAbsolutePath());
        }
    }

    public synchronized void saveFile(String text, String path) {
        File file = new File(path);
        this.name = file.getName();
        this.dir = file.getParent();
        if (!(!file.exists() || file.isFile() && file.canWrite())) {
            throw new RuntimeException("Unable to write to " + file.getAbsolutePath());
        }
        this.path = path;
        this.saveFile(text);
    }

    public synchronized String getPath() {
        return this.path;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized String getDir() {
        return this.dir;
    }

    public synchronized void setPath(String path) {
        this.path = path;
        File file = new File(path);
        this.name = file.getName();
        this.dir = file.getParent();
    }
}

