/*
 * Decompiled with CFR 0.152.
 */
package kenya.passes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kenya.errors.KenyaBadLocationError;
import kenya.errors.KenyaInternalError;
import kenya.errors.KenyaPreconditionError;
import kenya.errors.SourceCodeException;
import kenya.passes.Util;
import kenya.sourceCodeInformation.util.SourceCodeWarningFactory;
import kenya.types.KBasicType;
import kenya.types.KBoundClassType;
import kenya.types.KEnumType;
import kenya.types.KFunction;
import kenya.types.KType;
import kenya.types.KVariable;
import kenya.types.tables.ClassTable;
import kenya.types.tables.FunctionTable;
import kenya.types.tables.SymbolTable;
import kenya.types.tables.VariableTable;
import kenya.values.IKNumericValue;
import kenya.values.IKValue;
import kenya.values.KBooleanValue;
import kenya.values.KCharValue;
import kenya.values.KDoubleValue;
import kenya.values.KEnumValue;
import kenya.values.KIntValue;
import kenya.values.KNullValue;
import kenya.values.KStringValue;
import kenya.values.KUnassignedValue;
import kenya.values.KUnknownValue;
import kenya.values.KVoidValue;
import kenya.values.util.KValueCalculator;
import kenya.values.util.MarkerKVariable;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.AAndBoolTerm;
import minijava.node.AArrayAllocate;
import minijava.node.AArrayDecInnerDeclaration;
import minijava.node.AArrayFieldAccess;
import minijava.node.AArrayInit;
import minijava.node.AArrayInitList;
import minijava.node.AAssertStatement;
import minijava.node.AAssignment;
import minijava.node.AAssignmentForRightStat;
import minijava.node.AAssignmentStatement;
import minijava.node.ABasicTypeType;
import minijava.node.ABlock;
import minijava.node.ABreakStatement;
import minijava.node.ACasePossibleCase;
import minijava.node.ACharliteralFactor;
import minijava.node.AClassDecDeclaration;
import minijava.node.ACommaEnumList;
import minijava.node.ACommaTypeName;
import minijava.node.AConstDecDeclaration;
import minijava.node.ADNumber;
import minijava.node.ADefaultPossibleCase;
import minijava.node.ADivTerm;
import minijava.node.ADynamicArrayInitialiser;
import minijava.node.AEnumDecDeclaration;
import minijava.node.AEnumList;
import minijava.node.AEqEquality;
import minijava.node.AFalseBooleanliteral;
import minijava.node.AForStatement;
import minijava.node.AFormalParamList;
import minijava.node.AFuncDecDeclaration;
import minijava.node.AFunctionApplication;
import minijava.node.AFunctioncallForRightStat;
import minijava.node.AFunctioncallStatement;
import minijava.node.AGtRelational;
import minijava.node.AGteqRelational;
import minijava.node.AINumber;
import minijava.node.AIfStat;
import minijava.node.AJavaForControl;
import minijava.node.AListStatements;
import minijava.node.ALtRelational;
import minijava.node.ALteqRelational;
import minijava.node.AMinusMathExpression;
import minijava.node.AMinusUnaryExp;
import minijava.node.AModTerm;
import minijava.node.AMultTerm;
import minijava.node.ANegateUnaryExp;
import minijava.node.ANeqEquality;
import minijava.node.ANullFactor;
import minijava.node.AOrBoolExpression;
import minijava.node.APlusMathExpression;
import minijava.node.APlusUnaryExp;
import minijava.node.APostdecr;
import minijava.node.APostincr;
import minijava.node.APredecr;
import minijava.node.APreincr;
import minijava.node.AQualifiedName;
import minijava.node.AReferenceTypeType;
import minijava.node.AReturnStatement;
import minijava.node.AScalarInitList;
import minijava.node.ASimpleName;
import minijava.node.AStringliteralFactor;
import minijava.node.ASwitchBlock;
import minijava.node.ASwitchStatement;
import minijava.node.ATrueBooleanliteral;
import minijava.node.ATypeName;
import minijava.node.AVarDecInnerDeclaration;
import minijava.node.AWhileStatement;
import minijava.node.AXorBoolExpression;
import minijava.node.Node;
import minijava.node.PArrayAccess;
import minijava.node.PCommaArrayInit;
import minijava.node.PCommaExp;
import minijava.node.PPossibleCase;

public class StructureChecker
extends DepthFirstAdapter {
    private ClassTable _classTab;
    private SymbolTable _symTab;
    private VariableTable _varTab;
    private Set _errStats;
    private List _errors;
    private List _infos;
    private Stack _valStack;
    private KVariable _lastVar;
    private Map _typeMap;
    private Map _funcMap;
    private boolean _returned;
    private Set _returnPos;
    private String _cScope;
    private boolean _breakAllowed;
    private boolean _breaked;
    private Set _breakPos;
    private boolean _loopUnreachable;
    private Set _loopPos;
    private Set _arrayLengthSet;
    private Set _enumChildSet;
    private boolean _doingAssig;

    public StructureChecker(ClassTable ct, SymbolTable st, FunctionTable ft, VariableTable vt, Set errorStats, Map typeMap, Map funcMap, Set arrayLengths, Set enumChildSet) {
        this._classTab = ct;
        this._symTab = st;
        this._varTab = vt;
        this._cScope = "<global>";
        this._arrayLengthSet = arrayLengths;
        this._enumChildSet = enumChildSet;
        this._valStack = new Stack();
        this._errStats = errorStats;
        this._errors = new LinkedList();
        this._infos = new LinkedList();
        this._returned = false;
        this._returnPos = null;
        this._breakAllowed = false;
        this._breaked = false;
        this._breakPos = null;
        this._typeMap = typeMap;
        this._funcMap = funcMap;
        this._loopUnreachable = false;
        this._doingAssig = false;
        this._lastVar = null;
    }

    public List getErrors() {
        return this._errors;
    }

    public List getInfos() {
        return this._infos;
    }

    public IKValue getTopOfValueStack() {
        return (IKValue)this._valStack.pop();
    }

    public void caseAListStatements(AListStatements node) {
        this.inAListStatements(node);
        try {
            if (!this._errStats.contains(node.getStatement())) {
                if (this._returned || this._breaked || this._loopUnreachable) {
                    int j;
                    int[] pos = Util.getFirstIdent(node.getStatement());
                    int[][] lnkPos = new int[(this._returned ? this._returnPos.size() : 0) + (this._breaked ? this._breakPos.size() : 0) + (this._loopUnreachable ? this._loopPos.size() : 0)][];
                    int i = 0;
                    if (this._returned) {
                        int[][] lnkRet = (int[][])this._returnPos.toArray((T[])new int[0][0]);
                        for (j = 0; j < lnkRet.length; ++j) {
                            lnkPos[i] = lnkRet[j];
                            ++i;
                        }
                    }
                    if (this._breaked) {
                        int[][] lnkBrk = (int[][])this._breakPos.toArray((T[])new int[0][0]);
                        for (j = 0; j < lnkBrk.length; ++j) {
                            lnkPos[i] = lnkBrk[j];
                            ++i;
                        }
                    }
                    if (this._loopUnreachable) {
                        int[][] lnkLp = (int[][])this._loopPos.toArray((T[])new int[0][0]);
                        for (j = 0; j < lnkLp.length; ++j) {
                            lnkPos[i] = lnkLp[j];
                            ++i;
                        }
                    }
                    SourceCodeException.throwUnreachable(pos[0], pos[1], pos[2], lnkPos);
                }
                this._valStack.clear();
                this._lastVar = null;
                this._doingAssig = false;
                node.getStatement().apply(this);
            }
        }
        catch (SourceCodeException sce) {
            this._errors.add(sce);
            this._errStats.add(node.getStatement());
            this._valStack.clear();
        }
        node.getStatements().apply(this);
        this.outAListStatements(node);
    }

    public void caseAAssignmentStatement(AAssignmentStatement node) {
        this.inAAssignmentStatement(node);
        node.getAssignment().apply(this);
        this.outAAssignmentStatement(node);
    }

    public void caseAAssignment(AAssignment node) {
        int[] pos;
        this.inAAssignment(node);
        this._lastVar = null;
        this._doingAssig = true;
        node.getFieldAccess().apply(this);
        this._doingAssig = false;
        IKValue lhs = (IKValue)this._valStack.pop();
        if (this._lastVar == null) {
            pos = Util.getFirstIdent(node.getFieldAccess());
            String value = lhs.getString();
            SourceCodeException.throwAssignToValue(pos[0], pos[1], pos[2], value);
        } else if (this._lastVar != MarkerKVariable.getArbitary()) {
            if (this._lastVar == MarkerKVariable.getEnumConst()) {
                throw KenyaPreconditionError.get();
            }
            if (this._lastVar.isConstant()) {
                pos = Util.getFirstIdent(node.getFieldAccess());
                int[][] lnkPos = new int[][]{Util.getFirstIdent(this._lastVar.getNode())};
                SourceCodeException.throwAssignToConstant(pos[0], pos[1], pos[2], lnkPos, this._lastVar);
            }
        }
        KVariable kv = this._lastVar;
        this._lastVar = null;
        node.getExpression().apply(this);
        IKValue rhs = (IKValue)this._valStack.pop();
        if (kv != MarkerKVariable.getArbitary() && kv != MarkerKVariable.getEnumConst() && kv.getType() == KBasicType.getChar()) {
            if (rhs instanceof IKNumericValue) {
                IKNumericValue iknv = (IKNumericValue)rhs;
                if (!iknv.inCharRange()) {
                    int[] pos2 = Util.getFirstIdent(node.getExpression());
                    SourceCodeException.throwPossibleLossOfPrecisionCharInt(pos2[0], pos2[1], pos2[2]);
                }
            } else if (!Util.isSingleVariableExpression(node.getExpression())) {
                int[] pos3 = Util.getFirstIdent(node.getExpression());
                SourceCodeException.throwPossibleLossOfPrecisionCharInt(pos3[0], pos3[1], pos3[2]);
            }
        }
        this._varTab.assignTo(kv, rhs);
        this._lastVar = null;
        this.outAAssignment(node);
    }

    public void caseAIfStat(AIfStat node) {
        boolean lhsBoth;
        this.inAIfStat(node);
        node.getBoolExpression().apply(this);
        IKValue bexp = (IKValue)this._valStack.pop();
        if (bexp instanceof KBooleanValue) {
            int[] pos = Util.getFirstIdent(node.getBoolExpression());
            if (bexp == KBooleanValue.getTrue()) {
                this._infos.add(SourceCodeWarningFactory.alwaysTrueIf(pos[0], pos[1], pos[2]));
            } else if (bexp == KBooleanValue.getFalse()) {
                this._infos.add(SourceCodeWarningFactory.alwaysFalseIf(pos[0], pos[1], pos[2]));
            }
        }
        if (this._breaked || this._returned || this._loopUnreachable) {
            throw KenyaPreconditionError.get();
        }
        VariableTable tmp = this._varTab.createClone();
        node.getBlock1().apply(this);
        boolean lhsRet = this._returned;
        boolean lhsBrk = this._breaked;
        boolean lhsLp = this._loopUnreachable;
        this._returned = false;
        this._breaked = false;
        this._loopUnreachable = false;
        VariableTable lhs = this._varTab;
        this._varTab = tmp;
        if (node.getElsePart() != null) {
            node.getElsePart().apply(this);
        }
        boolean rhsRet = this._returned;
        boolean rhsBrk = this._breaked;
        boolean rhsLp = this._loopUnreachable;
        boolean rhsBoth = rhsRet || rhsBrk || rhsLp;
        boolean bl = lhsBoth = lhsRet || lhsBrk || lhsLp;
        if ((lhsRet || lhsBrk || lhsLp) && (rhsRet || rhsBrk || rhsLp)) {
            this._returned = lhsRet && rhsBoth || rhsRet && lhsBoth;
            this._breaked = lhsBrk && rhsBoth || rhsBrk && lhsBoth;
            this._loopUnreachable = lhsLp && rhsBoth || rhsLp && lhsBoth;
        } else {
            this._returned = false;
            this._breaked = false;
            this._loopUnreachable = false;
        }
        this._varTab = lhsBoth ? lhs : (rhsBoth ? lhs : VariableTable.merge(lhs, this._varTab));
        this.outAIfStat(node);
    }

    public void caseAWhileStatement(AWhileStatement node) {
        this.inAWhileStatement(node);
        node.getBoolExpression().apply(this);
        IKValue condVal = (IKValue)this._valStack.pop();
        if (condVal == KBooleanValue.getFalse()) {
            int ln = node.getWhile().getLine();
            int pos = node.getWhile().getPos();
            int len = node.getWhile().getText().trim().length();
            int[][] lnkPos = new int[][]{{ln, pos, len}};
            int[] blockPos = Util.getFirstIdent(node.getBlock());
            this._infos.add(SourceCodeWarningFactory.alwaysFalseWhile(ln, pos, len));
            try {
                SourceCodeException.throwUnreachable(blockPos[0], blockPos[1], blockPos[2], lnkPos);
            }
            catch (SourceCodeException sce) {
                this._errors.add(sce);
            }
            return;
        }
        if (condVal == KBooleanValue.getTrue()) {
            int ln = node.getWhile().getLine();
            int pos = node.getWhile().getPos();
            int len = node.getWhile().getText().trim().length();
            this._infos.add(SourceCodeWarningFactory.alwaysTrueWhile(ln, pos, len));
        }
        if (this._breaked || this._returned || this._loopUnreachable) {
            throw KenyaPreconditionError.get();
        }
        boolean tmpBrk = this._breakAllowed;
        this._breakAllowed = true;
        VariableTable tmp = this._varTab.createClone();
        node.getBlock().apply(this);
        this._breakAllowed = tmpBrk;
        if (!this._breaked && condVal == KBooleanValue.getTrue()) {
            this._loopUnreachable = true;
            int ln = node.getWhile().getLine();
            int pos = node.getWhile().getPos();
            int len = node.getWhile().getText().trim().length();
            int[] lnkPos = new int[]{ln, pos, len};
            this._loopPos.add(lnkPos);
        }
        if (condVal != KBooleanValue.getTrue()) {
            this._varTab = VariableTable.merge(tmp, this._varTab);
        }
        if (this._breaked) {
            this._returnPos = new HashSet();
            this._returned = false;
        }
        this._breaked = false;
        this.outAWhileStatement(node);
    }

    public void caseAReturnStatement(AReturnStatement node) {
        this.inAReturnStatement(node);
        if (node.getExpression() != null) {
            node.getExpression().apply(this);
            this._valStack.pop();
        }
        this._returned = true;
        this._returnPos.add(new int[]{node.getReturn().getLine(), node.getReturn().getPos(), node.getReturn().getText().trim().length()});
        this.outAReturnStatement(node);
    }

    public void caseASwitchStatement(ASwitchStatement node) {
        this.inASwitchStatement(node);
        node.getBoolExpression().apply(this);
        IKValue _switchValue = (IKValue)this._valStack.pop();
        if (_switchValue != KUnknownValue.get()) {
            int ln = node.getSwitch().getLine();
            int pos = node.getSwitch().getPos();
            int len = node.getSwitch().getText().trim().length();
            this._infos.add(SourceCodeWarningFactory.alwaysConstantInSwitch(ln, pos, len));
        }
        if (node.getSwitchBlock() != null) {
            boolean tmp = this._breakAllowed;
            node.getSwitchBlock().apply(this);
            this._breakAllowed = tmp;
        }
        this.outASwitchStatement(node);
    }

    public void caseASwitchBlock(ASwitchBlock node) {
        this.inASwitchBlock(node);
        Iterator it = node.getPossibleCase().iterator();
        if (this._returned || this._loopUnreachable) {
            throw KenyaPreconditionError.get();
        }
        boolean allLoopRet = true;
        boolean allLoop = false;
        boolean allRet = false;
        boolean hasDefault = false;
        VariableTable tmp = this._varTab.createClone();
        VariableTable allTrack = null;
        HashMap<IKValue, PPossibleCase> caseVals = new HashMap<IKValue, PPossibleCase>();
        while (it.hasNext()) {
            this._breakAllowed = true;
            PPossibleCase ppc = (PPossibleCase)it.next();
            hasDefault |= ppc instanceof ADefaultPossibleCase;
            ppc.apply(this);
            if (ppc instanceof ACasePossibleCase) {
                IKValue lastCaseVal = (IKValue)this._valStack.pop();
                if (caseVals.containsKey(lastCaseVal)) {
                    int[] thisPos = Util.getFirstIdent(ppc);
                    int[][] theirPos = new int[][]{Util.getFirstIdent((Node)caseVals.get(lastCaseVal))};
                    SourceCodeException.throwSwitchDuplicateLabel(thisPos[0], thisPos[1], thisPos[2], theirPos);
                } else {
                    caseVals.put(lastCaseVal, ppc);
                }
            }
            if (!this._returned && !this._loopUnreachable) {
                if (this._breaked || !it.hasNext()) {
                    if (allTrack == null) {
                        allTrack = this._varTab.createClone();
                    }
                    allTrack = VariableTable.merge(this._varTab, allTrack);
                    this._varTab = tmp.createClone();
                } else {
                    this._varTab = VariableTable.merge(tmp.createClone(), this._varTab);
                }
            } else {
                this._varTab = tmp.createClone();
            }
            if (this._breaked || this._loopUnreachable || this._returned || !it.hasNext()) {
                allLoopRet &= this._returned || this._loopUnreachable;
                allRet |= this._returned;
                allLoop |= this._loopUnreachable;
            }
            this._breaked = false;
            this._returned = false;
            this._loopUnreachable = false;
        }
        if (hasDefault) {
            if (allTrack == null) {
                allTrack = this._varTab.createClone();
            }
            this._varTab = allTrack;
        } else {
            this._varTab = allTrack == null ? tmp : VariableTable.merge(tmp, allTrack);
        }
        if (hasDefault && allLoopRet) {
            this._returned |= allRet;
            this._loopUnreachable |= allLoop;
        }
        this.outASwitchBlock(node);
    }

    public void caseACasePossibleCase(ACasePossibleCase node) {
        this.inACasePossibleCase(node);
        node.getBoolExpression().apply(this);
        IKValue caseValue = (IKValue)this._valStack.pop();
        if (caseValue == KUnknownValue.get()) {
            int[] pos = Util.getFirstIdent(node.getBoolExpression());
            SourceCodeException.throwSwitchNeedsConstant(pos[0], pos[1], pos[2]);
        }
        node.getBlock().apply(this);
        this._valStack.push(caseValue);
        this.outACasePossibleCase(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void caseAForStatement(AForStatement node) {
        this.inAForStatement(node);
        this._symTab.newLocalScope();
        this._varTab.pushScope();
        try {
            node.getForControl().apply(this);
            IKValue condVal = (IKValue)this._valStack.pop();
            boolean tmpBrk = this._breakAllowed;
            this._breakAllowed = true;
            VariableTable tmp = this._varTab.createClone();
            node.getBlock().apply(this);
            this._breakAllowed = tmpBrk;
            if (!this._breaked && condVal == KBooleanValue.getTrue()) {
                this._loopUnreachable = true;
                int ln = node.getFor().getLine();
                int pos = node.getFor().getPos();
                int len = node.getFor().getText().trim().length();
                int[] lnkPos = new int[]{ln, pos, len};
                this._loopPos.add(lnkPos);
            }
            if (condVal != KBooleanValue.getTrue()) {
                this._varTab = VariableTable.merge(tmp, this._varTab);
            }
            if (this._breaked) {
                this._returnPos = new HashSet();
                this._returned = false;
            }
            this._breaked = false;
        }
        finally {
            this._symTab.pop();
            this._varTab.popScope();
        }
        this.outAForStatement(node);
    }

    public void caseAJavaForControl(AJavaForControl node) {
        this.inAJavaForControl(node);
        node.getForLeftStat().apply(this);
        node.getBoolExpression().apply(this);
        IKValue condVal = (IKValue)this._valStack.pop();
        if (condVal == KBooleanValue.getFalse()) {
            int ln = ((AForStatement)node.parent()).getFor().getLine();
            int pos = ((AForStatement)node.parent()).getFor().getPos();
            int len = ((AForStatement)node.parent()).getFor().getText().trim().length();
            int[][] lnkPos = new int[][]{{ln, pos, len}};
            int[] blockPos = Util.getFirstIdent(((AForStatement)node.parent()).getBlock());
            this._infos.add(SourceCodeWarningFactory.alwaysFalseFor(ln, pos, len));
            try {
                SourceCodeException.throwUnreachable(blockPos[0], blockPos[1], blockPos[2], lnkPos);
            }
            catch (SourceCodeException sce) {
                this._errors.add(sce);
            }
            this._valStack.push(condVal);
            return;
        }
        if (condVal == KBooleanValue.getTrue()) {
            int ln = ((AForStatement)node.parent()).getFor().getLine();
            int pos = ((AForStatement)node.parent()).getFor().getPos();
            int len = ((AForStatement)node.parent()).getFor().getText().trim().length();
            this._infos.add(SourceCodeWarningFactory.alwaysTrueFor(ln, pos, len));
        }
        if (node.getForRightStat() != null) {
            node.getForRightStat().apply(this);
        }
        this._valStack.push(condVal);
        this.outAJavaForControl(node);
    }

    public void caseAAssignmentForRightStat(AAssignmentForRightStat node) {
        this.inAAssignmentForRightStat(node);
        node.getAssignment().apply(this);
        this.outAAssignmentForRightStat(node);
    }

    public void caseAFunctioncallForRightStat(AFunctioncallForRightStat node) {
        this.inAFunctioncallForRightStat(node);
        node.getFunctionApplication().apply(this);
        IKValue bexp = (IKValue)this._valStack.pop();
        if (bexp != KVoidValue.get()) {
            KFunction kf = (KFunction)this._funcMap.get(node.getFunctionApplication());
            Object lnkPos = kf.getNode() != null ? (Object)new int[][]{Util.getFirstIdent(kf.getNode().getIdentifier())} : new int[0][0];
            int[] pos = Util.getFirstIdent(node);
            this._infos.add(SourceCodeWarningFactory.ignoredReturnValue(pos[0], pos[1], pos[2], (int[][])lnkPos));
        }
        this.outAFunctioncallForRightStat(node);
    }

    public void caseABreakStatement(ABreakStatement node) {
        if (!this._breakAllowed) {
            int ln = node.getBreak().getLine();
            int pos = node.getBreak().getPos();
            int len = node.getBreak().getText().trim().length();
            SourceCodeException.throwIllegalBreakPlace(ln, pos, len);
        }
        this._breaked = true;
        this._breakPos.add(new int[]{node.getBreak().getLine(), node.getBreak().getPos(), node.getBreak().getText().trim().length()});
    }

    public void caseAAssertStatement(AAssertStatement node) {
        this.inAAssertStatement(node);
        node.getBoolExpression().apply(this);
        IKValue bexp = (IKValue)this._valStack.pop();
        if (bexp instanceof KBooleanValue) {
            int[] pos = Util.getFirstIdent(node.getBoolExpression());
            if (bexp == KBooleanValue.getTrue()) {
                this._infos.add(SourceCodeWarningFactory.alwaysTrueAssert(pos[0], pos[1], pos[2]));
            } else if (bexp == KBooleanValue.getFalse()) {
                this._infos.add(SourceCodeWarningFactory.alwaysFalseAssert(pos[0], pos[1], pos[2]));
            }
        }
        if (node.getColonString() != null) {
            node.getColonString().apply(this);
            this._valStack.pop();
        }
        this.outAAssertStatement(node);
    }

    public void caseAFunctioncallStatement(AFunctioncallStatement node) {
        this.inAFunctioncallStatement(node);
        node.getFunctionApplication().apply(this);
        IKValue bexp = (IKValue)this._valStack.pop();
        if (bexp != KVoidValue.get()) {
            KFunction kf = (KFunction)this._funcMap.get(node.getFunctionApplication());
            Object lnkPos = kf.getNode() != null ? (Object)new int[][]{Util.getFirstIdent(kf.getNode().getIdentifier())} : new int[0][0];
            int[] pos = Util.getFirstIdent(node);
            this._infos.add(SourceCodeWarningFactory.ignoredReturnValue(pos[0], pos[1], pos[2], (int[][])lnkPos));
        }
        this.outAFunctioncallStatement(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void caseABlock(ABlock node) {
        this.inABlock(node);
        this._symTab.newLocalScope();
        this._varTab.pushScope();
        try {
            node.getStatements().apply(this);
        }
        finally {
            this._varTab.popScope();
            this._symTab.pop();
        }
        this.outABlock(node);
    }

    public void caseAFunctionApplication(AFunctionApplication node) {
        this.inAFunctionApplication(node);
        Stack tmp = this._valStack;
        this._valStack = new Stack();
        if (node.getActualParamList() != null) {
            node.getActualParamList().apply(this);
        }
        this._valStack = tmp;
        KType kt = (KType)this._typeMap.get(node);
        if (kt == KBasicType.getVoid()) {
            this._valStack.push(KVoidValue.get());
        } else {
            this._valStack.push(KUnknownValue.get());
        }
        this.outAFunctionApplication(node);
    }

    public void caseAVarDecInnerDeclaration(AVarDecInnerDeclaration node) {
        this.inAVarDecInnerDeclaration(node);
        String ident = node.getIdentifier().getText().trim();
        KType type = (KType)this._typeMap.get(node);
        KVariable kv = new KVariable(ident, type, false, node);
        if (node.getInitialiser() != null) {
            node.getInitialiser().apply(this);
            IKValue ikv = (IKValue)this._valStack.pop();
            if (kv != MarkerKVariable.getArbitary() && kv != MarkerKVariable.getEnumConst() && kv.getType() == KBasicType.getChar()) {
                if (ikv instanceof IKNumericValue) {
                    IKNumericValue iknv = (IKNumericValue)ikv;
                    if (!iknv.inCharRange()) {
                        int[] pos = Util.getFirstIdent(node.getInitialiser());
                        SourceCodeException.throwPossibleLossOfPrecisionCharInt(pos[0], pos[1], pos[2]);
                    }
                } else if (!Util.isSingleVariableExpression(node.getInitialiser())) {
                    int[] pos = Util.getFirstIdent(node.getInitialiser());
                    SourceCodeException.throwPossibleLossOfPrecisionCharInt(pos[0], pos[1], pos[2]);
                }
            }
            this._symTab.pushLocal(ident, kv);
            if (!this._varTab.declareNew(kv)) {
                throw KenyaPreconditionError.get();
            }
            this._varTab.assignTo(kv, ikv);
        } else if (type instanceof KBoundClassType) {
            this._symTab.pushLocal(ident, kv);
            if (!this._varTab.declareNew(kv)) {
                throw KenyaPreconditionError.get();
            }
            this._varTab.assignTo(kv, KUnknownValue.get());
        } else {
            this._symTab.pushLocal(ident, kv);
            if (!this._varTab.declareNew(kv)) {
                throw KenyaPreconditionError.get();
            }
        }
        this.outAVarDecInnerDeclaration(node);
    }

    public void caseAArrayDecInnerDeclaration(AArrayDecInnerDeclaration node) {
        this.inAArrayDecInnerDeclaration(node);
        String ident = node.getIdentifier().getText().trim();
        KType type = (KType)this._typeMap.get(node);
        KVariable kv = new KVariable(ident, type, false, node);
        this._symTab.pushLocal(ident, kv);
        this._varTab.declareNew(kv);
        if (node.getArrayInitialiser() != null) {
            node.getArrayInitialiser().apply(this);
            IKValue ikv = (IKValue)this._valStack.pop();
            this._varTab.assignTo(kv, ikv);
        }
        this.outAArrayDecInnerDeclaration(node);
    }

    public void caseAClassDecDeclaration(AClassDecDeclaration node) {
        this.inAClassDecDeclaration(node);
        this.outAClassDecDeclaration(node);
    }

    public void caseAEnumDecDeclaration(AEnumDecDeclaration node) {
        this.inAEnumDecDeclaration(node);
        this.outAEnumDecDeclaration(node);
    }

    public void caseAEnumList(AEnumList node) {
        throw KenyaBadLocationError.get();
    }

    public void caseACommaEnumList(ACommaEnumList node) {
        throw KenyaBadLocationError.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void caseAFuncDecDeclaration(AFuncDecDeclaration node) {
        if (this._errStats.contains(node)) {
            return;
        }
        this.inAFuncDecDeclaration(node);
        KFunction kf = (KFunction)this._funcMap.get(node);
        SymbolTable st = kf.getSymbolTable();
        this._cScope = "method " + kf.getName() + FunctionTable.paramsToString(kf.getArgs());
        if (!this._symTab.push(st)) {
            throw KenyaPreconditionError.get();
        }
        this._varTab.pushSymbolTable(st);
        this._returned = false;
        this._breaked = false;
        this._breakAllowed = false;
        this._loopUnreachable = false;
        this._breakPos = new HashSet();
        this._loopPos = new HashSet();
        this._returnPos = new HashSet();
        try {
            node.getBlock().apply(this);
        }
        finally {
            this._varTab.popScope();
            this._symTab.pop();
        }
        if (kf.getReturnType() != KBasicType.getVoid() && !this._returned && !this._loopUnreachable) {
            try {
                int ln = ((ABlock)node.getBlock()).getRBrace().getLine();
                int pos = ((ABlock)node.getBlock()).getRBrace().getPos();
                int len = ((ABlock)node.getBlock()).getRBrace().getText().trim().length();
                int[][] lnkPos = new int[][]{Util.getFirstIdent(node.getIdentifier())};
                SourceCodeException.throwMissingReturnStatement(ln, pos, len, lnkPos, kf.getReturnType());
            }
            catch (SourceCodeException sce) {
                this._errors.add(sce);
            }
        }
        this.outAFuncDecDeclaration(node);
    }

    public void caseAConstDecDeclaration(AConstDecDeclaration node) {
        this.inAConstDecDeclaration(node);
        this.outAConstDecDeclaration(node);
    }

    public void inAFormalParamList(AFormalParamList node) {
        throw KenyaBadLocationError.get();
    }

    public void inATypeName(ATypeName node) {
        throw KenyaBadLocationError.get();
    }

    public void inACommaTypeName(ACommaTypeName node) {
        throw new KenyaInternalError("Shouldn't be in here");
    }

    public void caseAArrayAllocate(AArrayAllocate node) {
        this.inAArrayAllocate(node);
        Iterator it = node.getArrayAccess().iterator();
        while (it.hasNext()) {
            ((PArrayAccess)it.next()).apply(this);
            this._valStack.pop();
        }
        this.outAArrayAllocate(node);
    }

    public void caseADynamicArrayInitialiser(ADynamicArrayInitialiser node) {
        this.inADynamicArrayInitialiser(node);
        node.getArrayAllocate().apply(this);
        this._valStack.pop();
        this._valStack.push(KUnknownValue.get());
        this.outADynamicArrayInitialiser(node);
    }

    public void caseAArrayInit(AArrayInit node) {
        this.inAArrayInit(node);
        node.getInitList().apply(this);
        this._valStack.push(KUnknownValue.get());
        this.outAArrayInit(node);
    }

    public void caseAScalarInitList(AScalarInitList node) {
        this.inAScalarInitList(node);
        node.getExpression().apply(this);
        this._valStack.pop();
        Iterator i = node.getCommaExp().iterator();
        while (i.hasNext()) {
            ((PCommaExp)i.next()).apply(this);
            this._valStack.pop();
        }
        this.outAScalarInitList(node);
    }

    public void caseAArrayInitList(AArrayInitList node) {
        this.inAArrayInitList(node);
        node.getArrayInit().apply(this);
        this._valStack.pop();
        Iterator i = node.getCommaArrayInit().iterator();
        while (i.hasNext()) {
            ((PCommaArrayInit)i.next()).apply(this);
            this._valStack.pop();
        }
        this.outAArrayInitList(node);
    }

    public void caseABasicTypeType(ABasicTypeType node) {
        throw KenyaBadLocationError.get();
    }

    public void caseAReferenceTypeType(AReferenceTypeType node) {
        throw KenyaBadLocationError.get();
    }

    public void outAArrayAllocate(AArrayAllocate node) {
        this._valStack.push(KUnknownValue.get());
    }

    public void caseAPlusMathExpression(APlusMathExpression node) {
        this.inAPlusMathExpression(node);
        node.getMathExpression().apply(this);
        IKValue lhs = (IKValue)this._valStack.pop();
        node.getTerm().apply(this);
        IKValue rhs = (IKValue)this._valStack.pop();
        this._valStack.push(KValueCalculator.add(lhs, rhs));
        this.outAPlusMathExpression(node);
    }

    public void caseAMinusMathExpression(AMinusMathExpression node) {
        this.inAMinusMathExpression(node);
        node.getMathExpression().apply(this);
        IKValue lhs = (IKValue)this._valStack.pop();
        node.getTerm().apply(this);
        IKValue rhs = (IKValue)this._valStack.pop();
        this._valStack.push(KValueCalculator.sub(lhs, rhs));
        this.outAMinusMathExpression(node);
    }

    public void caseAMultTerm(AMultTerm node) {
        this.inAMultTerm(node);
        node.getTerm().apply(this);
        IKValue lhs = (IKValue)this._valStack.pop();
        node.getUnaryExp().apply(this);
        IKValue rhs = (IKValue)this._valStack.pop();
        this._valStack.push(KValueCalculator.mult(lhs, rhs));
        this.outAMultTerm(node);
    }

    public void caseADivTerm(ADivTerm node) {
        this.inADivTerm(node);
        node.getTerm().apply(this);
        IKValue lhs = (IKValue)this._valStack.pop();
        node.getUnaryExp().apply(this);
        IKValue rhs = (IKValue)this._valStack.pop();
        if (rhs instanceof IKNumericValue && ((IKNumericValue)rhs).equalsZero()) {
            int ln = node.getDivide().getLine();
            int pos = node.getDivide().getPos();
            int len = node.getDivide().getText().trim().length();
            this._infos.add(SourceCodeWarningFactory.divideByZero(ln, pos, len));
        }
        this._valStack.push(KValueCalculator.div(lhs, rhs));
        this.outADivTerm(node);
    }

    public void caseAModTerm(AModTerm node) {
        this.inAModTerm(node);
        node.getTerm().apply(this);
        IKValue lhs = (IKValue)this._valStack.pop();
        node.getUnaryExp().apply(this);
        IKValue rhs = (IKValue)this._valStack.pop();
        if (rhs instanceof IKNumericValue && ((IKNumericValue)rhs).equalsZero()) {
            int ln = node.getMod().getLine();
            int pos = node.getMod().getPos();
            int len = node.getMod().getText().trim().length();
            this._infos.add(SourceCodeWarningFactory.moduloByZero(ln, pos, len));
        }
        this._valStack.push(KValueCalculator.mod(lhs, rhs));
        this.outAModTerm(node);
    }

    public void caseAMinusUnaryExp(AMinusUnaryExp node) {
        this.inAMinusUnaryExp(node);
        node.getUnaryExp().apply(this);
        IKValue lhs = (IKValue)this._valStack.pop();
        this._valStack.push(KValueCalculator.unSub(lhs));
        this.outAMinusUnaryExp(node);
    }

    public void caseAPlusUnaryExp(APlusUnaryExp node) {
        this.inAPlusUnaryExp(node);
        node.getUnaryExp().apply(this);
        this.outAPlusUnaryExp(node);
    }

    public void caseANegateUnaryExp(ANegateUnaryExp node) {
        this.inANegateUnaryExp(node);
        node.getUnaryExp().apply(this);
        IKValue lhs = (IKValue)this._valStack.pop();
        this._valStack.push(KValueCalculator.unNeg(lhs));
        this.outANegateUnaryExp(node);
    }

    public void caseAPostdecr(APostdecr node) {
        int[] pos;
        this.inAPostdecr(node);
        this._lastVar = null;
        node.getFieldAccess().apply(this);
        if (this._lastVar == null) {
            pos = Util.getFirstIdent(node);
            SourceCodeException.throwUnopValueMM(pos[0], pos[1], pos[2]);
        }
        if (this._lastVar.isConstant()) {
            pos = Util.getFirstIdent(node.getFieldAccess());
            int[][] lnkPos = new int[][]{Util.getFirstIdent(this._lastVar.getNode())};
            SourceCodeException.throwAssignToConstant(pos[0], pos[1], pos[2], lnkPos, this._lastVar);
        }
        IKValue lhs = (IKValue)this._valStack.pop();
        IKValue res = KValueCalculator.minusminus(lhs);
        this._valStack.push(res);
        this._varTab.assignTo(this._lastVar, res);
        this._lastVar = null;
        this.outAPostdecr(node);
    }

    public void caseAPostincr(APostincr node) {
        int[] pos;
        this.inAPostincr(node);
        this._lastVar = null;
        node.getFieldAccess().apply(this);
        if (this._lastVar == null) {
            pos = Util.getFirstIdent(node.getFieldAccess());
            SourceCodeException.throwUnopValuePP(pos[0], pos[1], pos[2]);
        }
        if (this._lastVar.isConstant()) {
            pos = Util.getFirstIdent(node.getFieldAccess());
            int[][] lnkPos = new int[][]{Util.getFirstIdent(this._lastVar.getNode())};
            SourceCodeException.throwAssignToConstant(pos[0], pos[1], pos[2], lnkPos, this._lastVar);
        }
        IKValue lhs = (IKValue)this._valStack.pop();
        IKValue res = KValueCalculator.plusplus(lhs);
        this._valStack.push(res);
        this._varTab.assignTo(this._lastVar, res);
        this._lastVar = null;
        this.outAPostincr(node);
    }

    public void caseAPredecr(APredecr node) {
        int[] pos;
        this.inAPredecr(node);
        this._lastVar = null;
        node.getFieldAccess().apply(this);
        if (this._lastVar == null) {
            pos = Util.getFirstIdent(node.getFieldAccess());
            SourceCodeException.throwUnopValueMM(pos[0], pos[1], pos[2]);
        }
        if (this._lastVar.isConstant()) {
            pos = Util.getFirstIdent(node.getFieldAccess());
            int[][] lnkPos = new int[][]{Util.getFirstIdent(this._lastVar.getNode())};
            SourceCodeException.throwAssignToConstant(pos[0], pos[1], pos[2], lnkPos, this._lastVar);
        }
        IKValue lhs = (IKValue)this._valStack.pop();
        IKValue res = KValueCalculator.minusminus(lhs);
        this._valStack.push(res);
        this._varTab.assignTo(this._lastVar, res);
        this._lastVar = null;
        this.outAPredecr(node);
    }

    public void caseAPreincr(APreincr node) {
        int[] pos;
        this.inAPreincr(node);
        this._lastVar = null;
        node.getFieldAccess().apply(this);
        if (this._lastVar == null) {
            pos = Util.getFirstIdent(node.getFieldAccess());
            SourceCodeException.throwUnopValuePP(pos[0], pos[1], pos[2]);
        }
        if (this._lastVar.isConstant()) {
            pos = Util.getFirstIdent(node.getFieldAccess());
            int[][] lnkPos = new int[][]{Util.getFirstIdent(this._lastVar.getNode())};
            SourceCodeException.throwAssignToConstant(pos[0], pos[1], pos[2], lnkPos, this._lastVar);
        }
        IKValue lhs = (IKValue)this._valStack.pop();
        IKValue res = KValueCalculator.plusplus(lhs);
        this._valStack.push(res);
        this._varTab.assignTo(this._lastVar, res);
        this._lastVar = null;
        this.outAPreincr(node);
    }

    public void caseANullFactor(ANullFactor node) {
        this.inANullFactor(node);
        this._valStack.push(KNullValue.get());
        this.outANullFactor(node);
    }

    public void caseAStringliteralFactor(AStringliteralFactor node) {
        this.inAStringliteralFactor(node);
        String text = node.getStringliteral().getText();
        int start = text.indexOf("\"");
        int end = text.lastIndexOf("\"");
        text = text.substring(start + 1, end);
        this._valStack.push(new KStringValue(Util.escapeString(text)));
        this.outAStringliteralFactor(node);
    }

    public void caseACharliteralFactor(ACharliteralFactor node) {
        this.inACharliteralFactor(node);
        char c = Util.parseCharacter(node);
        this._valStack.push(new KCharValue(c));
        this.outACharliteralFactor(node);
    }

    public void caseATrueBooleanliteral(ATrueBooleanliteral node) {
        this.inATrueBooleanliteral(node);
        this._valStack.push(KBooleanValue.getTrue());
        this.outATrueBooleanliteral(node);
    }

    public void caseAFalseBooleanliteral(AFalseBooleanliteral node) {
        this.inAFalseBooleanliteral(node);
        this._valStack.push(KBooleanValue.getFalse());
        this.outAFalseBooleanliteral(node);
    }

    public void caseAINumber(AINumber node) {
        this.inAINumber(node);
        try {
            int i = Integer.parseInt(node.getIntnumber().getText().trim());
            KIntValue kiv = new KIntValue(i);
            if (kiv.inCharRange()) {
                KCharValue kcv = new KCharValue((char)i);
                this._valStack.push(kcv);
            } else {
                this._valStack.push(kiv);
            }
        }
        catch (NumberFormatException e) {
            int ln = node.getIntnumber().getLine();
            int pos = node.getIntnumber().getPos();
            int len = node.getIntnumber().getText().trim().length();
            SourceCodeException.throwBadInt(ln, pos, len, node.getIntnumber().getText().trim());
        }
        this.outAINumber(node);
    }

    public void caseADNumber(ADNumber node) {
        this.inADNumber(node);
        int ln = node.getDpnumber().getLine();
        int pos = node.getDpnumber().getPos();
        int len = node.getDpnumber().getText().trim().length();
        try {
            double d = Double.parseDouble(node.getDpnumber().getText().trim());
            if (Double.isInfinite(d) || Double.isNaN(d)) {
                SourceCodeException.throwBadDouble(ln, pos, len, node.getDpnumber().getText().trim());
                return;
            }
            KDoubleValue kdv = new KDoubleValue(d);
            this._valStack.push(kdv);
        }
        catch (NumberFormatException e) {
            SourceCodeException.throwBadDouble(ln, pos, len, node.getDpnumber().getText().trim());
        }
        this.outADNumber(node);
    }

    public void caseAOrBoolExpression(AOrBoolExpression node) {
        this.inAOrBoolExpression(node);
        node.getBoolExpression().apply(this);
        IKValue lhs = (IKValue)this._valStack.pop();
        node.getBoolTerm().apply(this);
        IKValue rhs = (IKValue)this._valStack.pop();
        IKValue res = KValueCalculator.or(lhs, rhs);
        this._valStack.push(res);
        this.outAOrBoolExpression(node);
    }

    public void caseAXorBoolExpression(AXorBoolExpression node) {
        this.inAXorBoolExpression(node);
        node.getBoolExpression().apply(this);
        IKValue lhs = (IKValue)this._valStack.pop();
        node.getBoolTerm().apply(this);
        IKValue rhs = (IKValue)this._valStack.pop();
        IKValue res = KValueCalculator.xor(lhs, rhs);
        this._valStack.push(res);
        this.outAXorBoolExpression(node);
    }

    public void caseAAndBoolTerm(AAndBoolTerm node) {
        this.inAAndBoolTerm(node);
        node.getBoolTerm().apply(this);
        IKValue lhs = (IKValue)this._valStack.pop();
        node.getEquality().apply(this);
        IKValue rhs = (IKValue)this._valStack.pop();
        IKValue res = KValueCalculator.and(lhs, rhs);
        this._valStack.push(res);
        this.outAAndBoolTerm(node);
    }

    public void caseAEqEquality(AEqEquality node) {
        this.inAEqEquality(node);
        node.getEquality().apply(this);
        IKValue lhs = (IKValue)this._valStack.pop();
        node.getRelational().apply(this);
        IKValue rhs = (IKValue)this._valStack.pop();
        IKValue res = KValueCalculator.equal(lhs, rhs);
        this._valStack.push(res);
        this.outAEqEquality(node);
    }

    public void caseANeqEquality(ANeqEquality node) {
        this.inANeqEquality(node);
        node.getEquality().apply(this);
        IKValue lhs = (IKValue)this._valStack.pop();
        node.getRelational().apply(this);
        IKValue rhs = (IKValue)this._valStack.pop();
        IKValue res = KValueCalculator.unequal(lhs, rhs);
        this._valStack.push(res);
        this.outANeqEquality(node);
    }

    public void caseALtRelational(ALtRelational node) {
        this.inALtRelational(node);
        node.getRelational().apply(this);
        IKValue lhs = (IKValue)this._valStack.pop();
        node.getMathExpression().apply(this);
        IKValue rhs = (IKValue)this._valStack.pop();
        IKValue res = KValueCalculator.less(lhs, rhs);
        this._valStack.push(res);
        this.outALtRelational(node);
    }

    public void caseAGtRelational(AGtRelational node) {
        this.inAGtRelational(node);
        node.getRelational().apply(this);
        IKValue lhs = (IKValue)this._valStack.pop();
        node.getMathExpression().apply(this);
        IKValue rhs = (IKValue)this._valStack.pop();
        IKValue res = KValueCalculator.greater(lhs, rhs);
        this._valStack.push(res);
        this.outAGtRelational(node);
    }

    public void caseALteqRelational(ALteqRelational node) {
        this.inALteqRelational(node);
        node.getRelational().apply(this);
        IKValue lhs = (IKValue)this._valStack.pop();
        node.getMathExpression().apply(this);
        IKValue rhs = (IKValue)this._valStack.pop();
        IKValue res = KValueCalculator.lessEq(lhs, rhs);
        this._valStack.push(res);
        this.outALteqRelational(node);
    }

    public void caseAGteqRelational(AGteqRelational node) {
        this.inAGteqRelational(node);
        node.getRelational().apply(this);
        IKValue lhs = (IKValue)this._valStack.pop();
        node.getMathExpression().apply(this);
        IKValue rhs = (IKValue)this._valStack.pop();
        IKValue res = KValueCalculator.greaterEq(lhs, rhs);
        this._valStack.push(res);
        this.outAGteqRelational(node);
    }

    public void caseAArrayFieldAccess(AArrayFieldAccess node) {
        this.inAArrayFieldAccess(node);
        node.getName().apply(this);
        IKValue ikv = (IKValue)this._valStack.pop();
        Iterator it = node.getArrayAccess().iterator();
        boolean tmpDoingAssig = this._doingAssig;
        KVariable tmp = this._lastVar;
        this._doingAssig = false;
        while (it.hasNext()) {
            ((PArrayAccess)it.next()).apply(this);
            this._valStack.pop();
        }
        this._lastVar = tmp;
        this._valStack.push(ikv);
        if (this._lastVar == MarkerKVariable.getEnumConst()) {
            this._lastVar = MarkerKVariable.getArbitary();
        }
        this._doingAssig = tmpDoingAssig;
        this.outAArrayFieldAccess(node);
    }

    public void caseASimpleName(ASimpleName node) {
        IKValue ikv;
        KVariable kv;
        this.inASimpleName(node);
        String ident = node.getIdentifier().getText().trim();
        if (this._enumChildSet.contains(node)) {
            KEnumType ket = (KEnumType)this._typeMap.get(node);
            this._lastVar = null;
            this._valStack.add(new KEnumValue(ket, ident));
            this.outASimpleName(node);
            return;
        }
        if (this._symTab.containsVariable(ident)) {
            kv = this._symTab.lookupVariable(ident);
            ikv = this._varTab.lookup(kv);
        } else if (this._classTab.isEnum(ident)) {
            kv = MarkerKVariable.getEnumConst();
            ikv = KUnknownValue.get();
        } else {
            int ln = node.getIdentifier().getLine();
            int pos = node.getIdentifier().getPos();
            int len = node.getIdentifier().getText().trim().length();
            SourceCodeException.throwLost_Variable(ln, pos, len, ident, this._cScope);
            return;
        }
        if (ikv == KUnassignedValue.get() && !this._doingAssig) {
            int ln = node.getIdentifier().getLine();
            int pos = node.getIdentifier().getPos();
            int len = node.getIdentifier().getText().trim().length();
            int[][] lnkPos = new int[][]{Util.getFirstIdent(kv.getNode())};
            SourceCodeException.throwUninitialisedVariable(ln, pos, len, lnkPos, node.getIdentifier().getText().trim());
        }
        this._lastVar = kv;
        this._valStack.push(ikv);
        this.outASimpleName(node);
    }

    public void caseAQualifiedName(AQualifiedName node) {
        this.inAQualifiedName(node);
        node.getFieldAccess().apply(this);
        KType kt = (KType)this._typeMap.get(node);
        if (this._arrayLengthSet.contains(node)) {
            if (this._doingAssig) {
                int ln = node.getIdentifier().getLine();
                int pos = node.getIdentifier().getPos();
                int len = node.getIdentifier().getText().trim().length();
                SourceCodeException.throwInvalidArrayLengthAssig(ln, pos, len);
            } else {
                this._lastVar = MarkerKVariable.getArbitary();
                this._valStack.push(KUnknownValue.get());
            }
        } else if (this._lastVar == MarkerKVariable.getEnumConst() || this._lastVar != MarkerKVariable.getArbitary() && this._lastVar.getType() instanceof KEnumType) {
            if (this._doingAssig) {
                int ln = node.getIdentifier().getLine();
                int pos = node.getIdentifier().getPos();
                int len = node.getIdentifier().getText().trim().length();
                String name = node.getIdentifier().getText().trim();
                SourceCodeException.throwInvalidEnumAssig(ln, pos, len, name);
            } else if (kt instanceof KEnumType) {
                KEnumType ket = (KEnumType)kt;
                String child = node.getIdentifier().getText().trim();
                this._valStack.push(new KEnumValue(ket, child));
            } else {
                this._valStack.push(KUnknownValue.get());
                this._lastVar = MarkerKVariable.getArbitary();
            }
        } else {
            this._valStack.push(KUnknownValue.get());
            this._lastVar = MarkerKVariable.getArbitary();
        }
        this.outAQualifiedName(node);
    }
}

