/*
 * Decompiled with CFR 0.152.
 */
package kenya.types.tables;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import kenya.errors.KenyaPreconditionError;
import kenya.sourceCodeInformation.interfaces.IVariable;

public class VariableLookupTable
implements Cloneable {
    private LinkedList _tableQueue = new LinkedList();

    private VariableLookupTable() {
    }

    public VariableLookupTable(IVariable[] theseVars) {
        HashMap<String, IVariable> hm = new HashMap<String, IVariable>();
        for (int i = 0; i < theseVars.length; ++i) {
            if (hm.put(theseVars[i].getName(), theseVars[i]) == null) continue;
            throw KenyaPreconditionError.get();
        }
        this._tableQueue.addFirst(hm);
    }

    public void push() {
        this._tableQueue.addFirst(new HashMap());
    }

    public void pop() {
        this._tableQueue.removeFirst();
    }

    public void add(IVariable variable) {
        Map hm = (Map)this._tableQueue.getFirst();
        if (hm.put(variable.getName(), variable) != null) {
            throw KenyaPreconditionError.get();
        }
    }

    public IVariable lookupByName(String name) {
        for (Map m : this._tableQueue) {
            if (!m.containsKey(name)) continue;
            return (IVariable)m.get(name);
        }
        throw new NoSuchElementException("Cannot find " + name);
    }

    public boolean hasVariable(String name) {
        for (Map m : this._tableQueue) {
            if (!m.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        VariableLookupTable copy = new VariableLookupTable();
        for (Map m : this._tableQueue) {
            Map cloneMap = (Map)((HashMap)m).clone();
            copy._tableQueue.addLast(cloneMap);
        }
        return copy;
    }
}

