/*
 * Decompiled with CFR 0.152.
 */
package mediator.util;

import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.interfaces.IVariable;
import kenya.types.KParamTypeMapper;

public class AClassInstance
implements IClass {
    public static final int A_CLASS = 0;
    public static final int AN_ENUM = 1;
    public static final int AN_ARRAY = 2;
    public static final int A_BASIC = 3;
    public static final int A_PARAM = 4;
    private static final int A_PARAM_NORMAL = 5;
    private String _name;
    private IVariable[] _decls;
    private String[] _consts;
    private ISourceCodeLocation _position;
    private IClass[] _templateParams;
    private final int _classType;

    public AClassInstance(String name, IClass[] templateParams, ISourceCodeLocation position, int type) {
        this._name = name;
        this._decls = new IVariable[0];
        this._consts = new String[0];
        this._position = position;
        this._templateParams = templateParams;
        this._classType = type;
    }

    public AClassInstance(String name, IClass[] templateParams, IClass derivedFrom, int type) {
        this(name, templateParams, derivedFrom.getPosition(), type);
        this.setDeclarations(derivedFrom.getDeclarations());
        this.setEnumConsts(derivedFrom.getEnumConstants());
    }

    private AClassInstance(String name, IClass[] templateParams, ISourceCodeLocation position, IVariable[] vars, String[] consts, int type) {
        this._name = name;
        this._templateParams = templateParams;
        this._position = position;
        this._decls = vars;
        this._consts = consts;
        this._classType = type;
    }

    public IClass normalise() {
        IVariable[] newVars = new IVariable[this._decls.length];
        for (int i = 0; i < newVars.length; ++i) {
            newVars[i] = this._decls[i].normalise();
        }
        IClass[] templateParams = new IClass[this._templateParams.length];
        for (int i = 0; i < templateParams.length; ++i) {
            templateParams[i] = this._templateParams[i].normalise();
        }
        if (this._classType == 4) {
            String name = KParamTypeMapper.get().lookupName(this._name);
            return new AClassInstance(name, templateParams, this._position, newVars, this._consts, 5);
        }
        if (this._classType == 2) {
            String arrayPart = this._name.substring(this._name.indexOf(91));
            String namePart = this._name.substring(0, this._name.indexOf(91));
            if (namePart.startsWith("@#")) {
                namePart = KParamTypeMapper.get().lookupName(namePart);
            }
            return new AClassInstance(namePart + arrayPart, templateParams, this._position, newVars, this._consts, 2);
        }
        return new AClassInstance(this._name, templateParams, this._position, newVars, this._consts, this._classType);
    }

    public void setDeclarations(IVariable[] decls) {
        this._decls = decls;
    }

    public void setEnumConsts(String[] consts) {
        this._consts = consts;
    }

    public boolean isArray() {
        return this._classType == 2;
    }

    public boolean isClass() {
        return this._classType == 0;
    }

    public boolean isEnum() {
        return this._classType == 1;
    }

    public boolean isBasic() {
        return this._classType == 3;
    }

    public boolean isParam() {
        return this._classType == 4 || this._classType == 5;
    }

    public IVariable[] getDeclarations() {
        return this._decls;
    }

    public String[] getEnumConstants() {
        return this._consts;
    }

    public String getName() {
        return this._name;
    }

    public ISourceCodeLocation getPosition() {
        return this._position;
    }

    public IClass[] getTemplateParams() {
        return this._templateParams;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isEnum()) {
            sb.append("enum ");
        }
        if (this._classType == 4) {
            sb.append(KParamTypeMapper.get().lookupName(this._name));
        } else {
            sb.append(this._name);
        }
        if (this._templateParams.length > 0) {
            sb.append("<");
            for (int i = 0; i < this._templateParams.length; ++i) {
                sb.append(this._templateParams[i].toString());
                if (i >= this._templateParams.length - 1) continue;
                sb.append(",");
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof IClass) {
            return ((IClass)other).getName().equals(this._name);
        }
        return false;
    }

    public int hashCode() {
        return this._name.hashCode();
    }
}

