/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine;

import java.util.Map;
import java.util.TreeMap;
import org.wellquite.kenya.stackMachine.InterpretedClassInstance;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClassInstance;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class InterpretedClass
implements IInterpretedClass {
    private final Map staticMutableVariables = new TreeMap();
    private final Map staticImmutableVariables = new TreeMap();
    private final Map instanceMutableVariables = new TreeMap();
    private final Map instanceImmutableVariables = new TreeMap();
    private final Map staticMethods = new TreeMap();
    private final Map instanceMethods = new TreeMap();
    private String name = null;

    public InterpretedClass(String name) {
        this.name = name;
    }

    public synchronized void addMutableStaticVariable(String name, IType variable) {
        this.staticMutableVariables.put(name, variable);
    }

    public synchronized void addImmutableStaticVariable(String name, IType variable) {
        this.staticImmutableVariables.put(name, variable);
    }

    public synchronized void addMutableInstanceVariable(String name, IType variable) {
        this.instanceMutableVariables.put(name, variable);
    }

    public synchronized void addImmutableInstanceVariable(String name, IType variable) {
        this.instanceImmutableVariables.put(name, variable);
    }

    public synchronized void addStaticMethod(IInterpretedMethod method) {
        if (!method.isStatic()) {
            throw new RuntimeException("Attempt to add non-static method to class as static method in class " + this.name + ": " + method);
        }
        this.staticMethods.put(method.getName(), method);
    }

    public synchronized void addInstanceMethod(IInterpretedMethod method) {
        this.instanceMethods.put(method.getName(), method);
    }

    public synchronized IInterpretedMethod getMethod(String methodName) {
        if (this.staticMethods.containsKey(methodName)) {
            return (IInterpretedMethod)this.staticMethods.get(methodName);
        }
        if (this.instanceMethods.containsKey(methodName)) {
            throw new RuntimeException("Attempt made to access non-static method from static context. " + methodName);
        }
        throw new RuntimeException("Method '" + methodName + "' not found in class " + this.name);
    }

    public synchronized IInterpretedClassInstance createInstance() {
        return new InterpretedClassInstance(this, this.instanceMethods, this.instanceImmutableVariables, this.instanceMutableVariables);
    }

    public synchronized void setName(String name) {
        if (this.name != null) {
            throw new RuntimeException("Attempt made to redefine InterpretedClass's name: " + this.name);
        }
        this.name = name;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized String toString() {
        return "InterpretedClass: " + this.name;
    }

    public synchronized Map getMutableStaticVariables() {
        return this.staticMutableVariables;
    }

    public synchronized Map getImmutableStaticVariables() {
        return this.staticImmutableVariables;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return 0;
    }
}

