/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.types;

import org.wellquite.kenya.stackMachine.types.interfaces.IBooleanType;

public class BooleanType
implements IBooleanType {
    private boolean value = false;
    private boolean assigned = false;

    public BooleanType() {
    }

    public BooleanType(boolean value) {
        this.value = value;
        this.assigned = true;
    }

    public synchronized Boolean getValue() {
        return new Boolean(this.value);
    }

    public synchronized void setValue(Boolean value) {
        if (this.assigned) {
            BooleanType.modificationError(this);
        } else {
            this.value = value;
            this.assigned = true;
        }
    }

    public synchronized String toString() {
        return "BooleanType: " + this.value;
    }

    public synchronized boolean valueSet() {
        return this.assigned;
    }

    private static void modificationError(BooleanType variable) {
        throw new RuntimeException("Attempt made to modify String variable: " + variable);
    }

    public String valueToString() {
        return "" + this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IBooleanType) {
            return ((IBooleanType)obj).getValue().equals(this.getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public String getTypeName() {
        return "boolean";
    }

    public Object clone() throws CloneNotSupportedException {
        BooleanType t = (BooleanType)super.clone();
        return t;
    }
}

