/*
 * Created on 19-Jan-2005
 */
package kenya.eclipse.ast;

import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import minijava.analysis.ReversedDepthFirstAdapter;
import minijava.node.*;
import minijava.node.EOF;
import minijava.node.Node;
import minijava.node.TAnd;
import minijava.node.TAssert;
import minijava.node.TAssign;
import minijava.node.TBlank;
import minijava.node.TBoolean;
import minijava.node.TBracketPair;
import minijava.node.TBreak;
import minijava.node.TCase;
import minijava.node.TChar;
import minijava.node.TCharliteral;
import minijava.node.TColon;
import minijava.node.TComma;
import minijava.node.TComment;
import minijava.node.TConst;
import minijava.node.TDefault;
import minijava.node.TDivide;
import minijava.node.TDot;
import minijava.node.TDouble;
import minijava.node.TDpnumber;
import minijava.node.TElse;
import minijava.node.TEnum;
import minijava.node.TEqual;
import minijava.node.TFalse;
import minijava.node.TFor;
import minijava.node.TGreater;
import minijava.node.TGreaterequal;
import minijava.node.TIdentifier;
import minijava.node.TIf;
import minijava.node.TInt;
import minijava.node.TIntnumber;
import minijava.node.TKlass;
import minijava.node.TLBrace;
import minijava.node.TLBracket;
import minijava.node.TLParenthese;
import minijava.node.TLess;
import minijava.node.TLessequal;
import minijava.node.TMinus;
import minijava.node.TMinusminus;
import minijava.node.TMod;
import minijava.node.TNew;
import minijava.node.TNewLine;
import minijava.node.TNot;
import minijava.node.TNotequal;
import minijava.node.TNull;
import minijava.node.TOr;
import minijava.node.TPlus;
import minijava.node.TPlusplus;
import minijava.node.TRBrace;
import minijava.node.TRBracket;
import minijava.node.TRParenthese;
import minijava.node.TReservedWord;
import minijava.node.TReturn;
import minijava.node.TSemicolon;
import minijava.node.TString;
import minijava.node.TStringliteral;
import minijava.node.TSwitch;
import minijava.node.TTimes;
import minijava.node.TTraditionalComment;
import minijava.node.TTrue;
import minijava.node.TVoid;
import minijava.node.TWhile;
import minijava.node.TXor;
import minijava.node.Token;

/**
 * @author Thomas Timbul
 */
public class LastPositionFinder extends ReversedDepthFirstAdapter {
	
	private ISourceCodeLocation _pos;
	
	/**
	 * finds the position of the LAST term in the given node.
	 * The assumption is that every node fed into here is syntactically
	 * correct, ie no null nodes where there isn't meant to be.
	 * @param node
	 * @return
	 */
	public static ISourceCodeLocation getLastLocation(Node node) {
		
		LastPositionFinder finder = new LastPositionFinder();
		
		node.apply(finder);
		
		return finder._pos!=null?finder._pos:new SourceCodeLocation(0,0,0);
		
	}
	
	private LastPositionFinder() {}
	
	public void considerToken(Token t) {
		if(_pos!=null) return;
		int a = t.getLine();
		int b = t.getPos();
		int c = t.getText().length();
		
		_pos = new SourceCodeLocation(a, b, c);
	}
	
	public void caseEOF(EOF arg0) {
		considerToken(arg0);
	}
	public void caseTAnd(TAnd arg0) {
		considerToken(arg0);
	}
	public void caseTAssert(TAssert arg0) {
		considerToken(arg0);
	}
	public void caseTAssign(TAssign arg0) {
		considerToken(arg0);
	}
	public void caseTBlank(TBlank arg0) {
		considerToken(arg0);
	}
	public void caseTBoolean(TBoolean arg0) {
		considerToken(arg0);
	}
	public void caseTBracketPair(TBracketPair arg0) {
		considerToken(arg0);
	}
	public void caseTBreak(TBreak arg0) {
		considerToken(arg0);
	}
	public void caseTCase(TCase arg0) {
		considerToken(arg0);
	}
	public void caseTChar(TChar arg0) {
		considerToken(arg0);
	}
	public void caseTCharliteral(TCharliteral arg0) {
		considerToken(arg0);
	}
	public void caseTColon(TColon arg0) {
		considerToken(arg0);
	}
	public void caseTComma(TComma arg0) {
		considerToken(arg0);
	}
	public void caseTComment(TComment arg0) {
		considerToken(arg0);
	}
	public void caseTConst(TConst arg0) {
		considerToken(arg0);
	}
	public void caseTDefault(TDefault arg0) {
		considerToken(arg0);
	}
	public void caseTDivide(TDivide arg0) {
		considerToken(arg0);
	}
	public void caseTDot(TDot arg0) {
		considerToken(arg0);
	}
	public void caseTDouble(TDouble arg0) {
		considerToken(arg0);
	}
	public void caseTDpnumber(TDpnumber arg0) {
		considerToken(arg0);
	}
	public void caseTElse(TElse arg0) {
		considerToken(arg0);
	}
	public void caseTEnum(TEnum arg0) {
		considerToken(arg0);
	}
	public void caseTEqual(TEqual arg0) {
		considerToken(arg0);
	}
	public void caseTFalse(TFalse arg0) {
		considerToken(arg0);
	}
	public void caseTFor(TFor arg0) {
		considerToken(arg0);
	}
	public void caseTGreater(TGreater arg0) {
		considerToken(arg0);
	}
	public void caseTGreaterequal(TGreaterequal arg0) {
		considerToken(arg0);
	}
	public void caseTIdentifier(TIdentifier arg0) {
		considerToken(arg0);
	}
	public void caseTIf(TIf arg0) {
		considerToken(arg0);
	}
	public void caseTInt(TInt arg0) {
		considerToken(arg0);
	}
	public void caseTIntnumber(TIntnumber arg0) {
		considerToken(arg0);
	}
	public void caseTKlass(TKlass arg0) {
		considerToken(arg0);
	}
	public void caseTLBrace(TLBrace arg0) {
		considerToken(arg0);
	}
	public void caseTLBracket(TLBracket arg0) {
		considerToken(arg0);
	}
	public void caseTLess(TLess arg0) {
		considerToken(arg0);
	}
	public void caseTLessequal(TLessequal arg0) {
		considerToken(arg0);
	}
	public void caseTLParenthese(TLParenthese arg0) {
		considerToken(arg0);
	}
	public void caseTMinus(TMinus arg0) {
		considerToken(arg0);
	}
	public void caseTMinusminus(TMinusminus arg0) {
		considerToken(arg0);
	}
	public void caseTMod(TMod arg0) {
		considerToken(arg0);
	}
	public void caseTNew(TNew arg0) {
		considerToken(arg0);
	}
	public void caseTNewLine(TNewLine arg0) {
		considerToken(arg0);
	}
	public void caseTNot(TNot arg0) {
		considerToken(arg0);
	}
	public void caseTNotequal(TNotequal arg0) {
		considerToken(arg0);
	}
	public void caseTNull(TNull arg0) {
		considerToken(arg0);
	}
	public void caseTOr(TOr arg0) {
		considerToken(arg0);
	}
	public void caseTPlus(TPlus arg0) {
		considerToken(arg0);
	}
	public void caseTPlusplus(TPlusplus arg0) {
		considerToken(arg0);
	}
	public void caseTRBrace(TRBrace arg0) {
		considerToken(arg0);
	}
	public void caseTRBracket(TRBracket arg0) {
		considerToken(arg0);
	}
	public void caseTReservedWord(TReservedWord arg0) {
		considerToken(arg0);
	}
	public void caseTReturn(TReturn arg0) {
		considerToken(arg0);
	}
	public void caseTRParenthese(TRParenthese arg0) {
		considerToken(arg0);
	}
	public void caseTSemicolon(TSemicolon arg0) {
		considerToken(arg0);
	}
	public void caseTString(TString arg0) {
		considerToken(arg0);
	}
	public void caseTStringliteral(TStringliteral arg0) {
		considerToken(arg0);
	}
	public void caseTSwitch(TSwitch arg0) {
		considerToken(arg0);
	}
	public void caseTTimes(TTimes arg0) {
		considerToken(arg0);
	}
	public void caseTTraditionalComment(TTraditionalComment arg0) {
		considerToken(arg0);
	}
	public void caseTTrue(TTrue arg0) {
		considerToken(arg0);
	}
	public void caseTVoid(TVoid arg0) {
		considerToken(arg0);
	}
	public void caseTWhile(TWhile arg0) {
		considerToken(arg0);
	}
	public void caseTXor(TXor arg0) {
		considerToken(arg0);
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
  public void caseStart(Start node) {
      node.getEOF().apply(this);
  }

  public void caseAListDeclarations(AListDeclarations node) {
      if(node.getDeclarations() != null) {
          node.getDeclarations().apply(this);
      }
      if(_pos!=null) return;
      if(node.getDeclaration() != null) {
          node.getDeclaration().apply(this);
      }
  }

  public void caseAEmptyDeclarations(AEmptyDeclarations node) {
  }

  

  public void caseAListStatements(AListStatements node) {
      if(node.getStatements() != null) {
          node.getStatements().apply(this);
      }
      if(_pos!=null) return;
      if(node.getStatement() != null) {
          node.getStatement().apply(this);
      }
  }

  public void caseAEmptyStatements(AEmptyStatements node) {
  }

  public void caseAInnerDecStatement(AInnerDecStatement node) {
      if(node.getSemicolon() != null) {
          node.getSemicolon().apply(this);
      }
      if(_pos!=null) return;
      if(node.getInnerDeclaration() != null) {
          node.getInnerDeclaration().apply(this);
      }
  }

  public void caseAFunctioncallStatement(AFunctioncallStatement node) {
      if(node.getSemicolon() != null) {
          node.getSemicolon().apply(this);
      }
      if(_pos!=null) return;
      if(node.getFunctionApplication() != null) {
          node.getFunctionApplication().apply(this);
      }
  }

  public void caseAAssignmentStatement(AAssignmentStatement node) {
      if(node.getSemicolon() != null) {
          node.getSemicolon().apply(this);
      }
      if(_pos!=null) return;
      if(node.getAssignment() != null) {
          node.getAssignment().apply(this);
      }
  }

  public void caseAIfStatement(AIfStatement node) {
      if(node.getIfStat() != null) {
          node.getIfStat().apply(this);
      }
  }

  public void caseAWhileStatement(AWhileStatement node) {
      if(node.getBlock() != null) {
          node.getBlock().apply(this);
      }
      if(_pos!=null) return;
      if(node.getRParenthese() != null) {
          node.getRParenthese().apply(this);
      }
      if(_pos!=null) return;
      if(node.getBoolExpression() != null) {
          node.getBoolExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getLParenthese() != null) {
          node.getLParenthese().apply(this);
      }
      if(_pos!=null) return;
      if(node.getWhile() != null) {
          node.getWhile().apply(this);
      }
  }

  public void caseAReturnStatement(AReturnStatement node) {
      if(node.getSemicolon() != null) {
          node.getSemicolon().apply(this);
      }
      if(_pos!=null) return;
      if(node.getExpression() != null) {
          node.getExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getReturn() != null) {
          node.getReturn().apply(this);
      }
  }

  public void caseASwitchStatement(ASwitchStatement node) {
      if(node.getSwitchBlock() != null) {
          node.getSwitchBlock().apply(this);
      }
      if(_pos!=null) return;
      if(node.getRParenthese() != null) {
          node.getRParenthese().apply(this);
      }
      if(_pos!=null) return;
      if(node.getBoolExpression() != null) {
          node.getBoolExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getLParenthese() != null) {
          node.getLParenthese().apply(this);
      }
      if(_pos!=null) return;
      if(node.getSwitch() != null) {
          node.getSwitch().apply(this);
      }
  }

  public void caseAForStatement(AForStatement node) {
      if(node.getBlock() != null) {
          node.getBlock().apply(this);
      }
      if(_pos!=null) return;
      if(node.getForControl() != null) {
          node.getForControl().apply(this);
      }
      if(_pos!=null) return;
      if(node.getFor() != null) {
          node.getFor().apply(this);
      }
  }

  public void caseABreakStatement(ABreakStatement node) {
      if(node.getSemicolon() != null) {
          node.getSemicolon().apply(this);
      }
      if(_pos!=null) return;
      if(node.getBreak() != null) {
          node.getBreak().apply(this);
      }
  }

  public void caseABlockStatement(ABlockStatement node) {
      if(node.getBlock() != null) {
          node.getBlock().apply(this);
      }
  }

  public void caseAForUnaryStatement(AForUnaryStatement node) {
      if(node.getSemicolon() != null) {
          node.getSemicolon().apply(this);
      }
      if(_pos!=null) return;
      if(node.getForUnaryExp() != null) {
          node.getForUnaryExp().apply(this);
      }
  }

  public void caseAAssertStatement(AAssertStatement node) {
      if(node.getSemicolon() != null) {
          node.getSemicolon().apply(this);
      }
      if(_pos!=null) return;
      if(node.getColonString() != null) {
          node.getColonString().apply(this);
      }
      if(_pos!=null) return;
      if(node.getBoolExpression() != null) {
          node.getBoolExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getAssert() != null) {
          node.getAssert().apply(this);
      }
  }

  public void caseAElsePart(AElsePart node) {
      if(node.getElseFollow() != null) {
          node.getElseFollow().apply(this);
      }
      if(_pos!=null) return;
      if(node.getElse() != null) {
          node.getElse().apply(this);
      }
  }

  public void caseABlockElseFollow(ABlockElseFollow node) {
      if(node.getBlock() != null) {
          node.getBlock().apply(this);
      }
  }

  public void caseAIfElseFollow(AIfElseFollow node) {
      if(node.getIfStat() != null) {
          node.getIfStat().apply(this);
      }
  }

  public void caseAIfStat(AIfStat node) {
      if(node.getElsePart() != null) {
          node.getElsePart().apply(this);
      }
      if(_pos!=null) return;
      if(node.getBlock1() != null) {
          node.getBlock1().apply(this);
      }
      if(_pos!=null) return;
      if(node.getRParenthese() != null) {
          node.getRParenthese().apply(this);
      }
      if(_pos!=null) return;
      if(node.getBoolExpression() != null) {
          node.getBoolExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getLParenthese() != null) {
          node.getLParenthese().apply(this);
      }
      if(_pos!=null) return;
      if(node.getIf() != null) {
          node.getIf().apply(this);
      }
  }

  public void caseAJavaForControl(AJavaForControl node) {
      if(node.getRParenthese() != null) {
          node.getRParenthese().apply(this);
      }
      if(_pos!=null) return;
      if(node.getForRightStat() != null) {
          node.getForRightStat().apply(this);
      }
      if(_pos!=null) return;
      if(node.getS2() != null) {
          node.getS2().apply(this);
      }
      if(_pos!=null) return;
      if(node.getBoolExpression() != null) {
          node.getBoolExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getS1() != null) {
          node.getS1().apply(this);
      }
      if(_pos!=null) return;
      if(node.getForLeftStat() != null) {
          node.getForLeftStat().apply(this);
      }
      if(_pos!=null) return;
      if(node.getLParenthese() != null) {
          node.getLParenthese().apply(this);
      }
  }

  public void caseAAssignment(AAssignment node) {
      if(node.getExpression() != null) {
          node.getExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getAssign() != null) {
          node.getAssign().apply(this);
      }
      if(_pos!=null) return;
      if(node.getFieldAccess() != null) {
          node.getFieldAccess().apply(this);
      }
  }

  public void caseAInnerDecForLeftStat(AInnerDecForLeftStat node) {
      if(node.getInnerDeclaration() != null) {
          node.getInnerDeclaration().apply(this);
      }
  }

  public void caseAAssignmentForLeftStat(AAssignmentForLeftStat node) {
      if(node.getAssignment() != null) {
          node.getAssignment().apply(this);
      }
  }

  public void caseAUnaryForRightStat(AUnaryForRightStat node) {
      if(node.getForUnaryExp() != null) {
          node.getForUnaryExp().apply(this);
      }
  }

  public void caseAAssignmentForRightStat(AAssignmentForRightStat node) {
      if(node.getAssignment() != null) {
          node.getAssignment().apply(this);
      }
  }

  public void caseAFunctioncallForRightStat(AFunctioncallForRightStat node) {
      if(node.getFunctionApplication() != null) {
          node.getFunctionApplication().apply(this);
      }
  }

  public void caseABlock(ABlock node) {
      if(node.getRBrace() != null) {
          node.getRBrace().apply(this);
      }
      if(_pos!=null) return;
      if(node.getStatements() != null) {
          node.getStatements().apply(this);
      }
      if(_pos!=null) return;
      if(node.getLBrace() != null) {
          node.getLBrace().apply(this);
      }
  }

  public void caseAFunctionApplication(AFunctionApplication node) {
      if(node.getRParenthese() != null) {
          node.getRParenthese().apply(this);
      }
      if(_pos!=null) return;
      if(node.getActualParamList() != null) {
          node.getActualParamList().apply(this);
      }
      if(_pos!=null) return;
      if(node.getLParenthese() != null) {
          node.getLParenthese().apply(this);
      }
      if(_pos!=null) return;
      if(node.getName() != null) {
          node.getName().apply(this);
      }
  }

  public void caseAListActualParamList(AListActualParamList node) {
      if(node.getExpression() != null) {
          node.getExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getComma() != null) {
          node.getComma().apply(this);
      }
      if(_pos!=null) return;
      if(node.getActualParamList() != null) {
          node.getActualParamList().apply(this);
      }
  }

  public void caseAExpActualParamList(AExpActualParamList node) {
      if(node.getExpression() != null) {
          node.getExpression().apply(this);
      }
  }

  public void caseASwitchBlock(ASwitchBlock node) {
      if(node.getRBrace() != null) {
          node.getRBrace().apply(this);
      } {
          Object temp[] = node.getPossibleCase().toArray();
          for(int i = temp.length - 1; i >= 0; i--) {
              ((PPossibleCase) temp[i]).apply(this);
          }
      }
      if(node.getLBrace() != null) {
          node.getLBrace().apply(this);
      }
  }

  public void caseACasePossibleCase(ACasePossibleCase node) {
      if(node.getBlock() != null) {
          node.getBlock().apply(this);
      }
      if(_pos!=null) return;
      if(node.getColon() != null) {
          node.getColon().apply(this);
      }
      if(_pos!=null) return;
      if(node.getBoolExpression() != null) {
          node.getBoolExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getCase() != null) {
          node.getCase().apply(this);
      }
  }

  public void caseADefaultPossibleCase(ADefaultPossibleCase node) {
      if(node.getBlock() != null) {
          node.getBlock().apply(this);
      }
      if(_pos!=null) return;
      if(node.getColon() != null) {
          node.getColon().apply(this);
      }
      if(_pos!=null) return;
      if(node.getDefault() != null) {
          node.getDefault().apply(this);
      }
  }

  public void caseAVarDecInnerDeclaration(AVarDecInnerDeclaration node) {
      if(node.getInitialiser() != null) {
          node.getInitialiser().apply(this);
      }
      if(_pos!=null) return;
      if(node.getIdentifier() != null) {
          node.getIdentifier().apply(this);
      }
      if(_pos!=null) return;
      if(node.getType() != null) {
          node.getType().apply(this);
      }
  }

  public void caseAArrayDecInnerDeclaration(AArrayDecInnerDeclaration node) {
      if(node.getArrayInitialiser() != null) {
          node.getArrayInitialiser().apply(this);
      }
      if(_pos!=null) return;
      if(node.getIdentifier() != null) {
          node.getIdentifier().apply(this);
      } {
          Object temp[] = node.getBracketPair().toArray();
          for(int i = temp.length - 1; i >= 0; i--) {
              ((TBracketPair) temp[i]).apply(this);
          }
      }
      if(node.getType() != null) {
          node.getType().apply(this);
      }
  }

  public void caseAClassDecDeclaration(AClassDecDeclaration node) {
      if(node.getRBrace() != null) {
          node.getRBrace().apply(this);
      } {
          Object temp[] = node.getClassInnerDeclaration().toArray();
          for(int i = temp.length - 1; i >= 0; i--) {
              ((PClassInnerDeclaration) temp[i]).apply(this);
          }
      }
      if(node.getLBrace() != null) {
          node.getLBrace().apply(this);
      }
      if(_pos!=null) return;
      if(node.getTypeParam() != null) {
          node.getTypeParam().apply(this);
      }
      if(_pos!=null) return;
      if(node.getIdentifier() != null) {
          node.getIdentifier().apply(this);
      }
      if(_pos!=null) return;
      if(node.getKlass() != null) {
          node.getKlass().apply(this);
      }
  }

  public void caseAEnumDecDeclaration(AEnumDecDeclaration node) {
      if(node.getRBrace() != null) {
          node.getRBrace().apply(this);
      }
      if(_pos!=null) return;
      if(node.getSemicolon() != null) {
          node.getSemicolon().apply(this);
      }
      if(_pos!=null) return;
      if(node.getEnumList() != null) {
          node.getEnumList().apply(this);
      }
      if(_pos!=null) return;
      if(node.getLBrace() != null) {
          node.getLBrace().apply(this);
      }
      if(_pos!=null) return;
      if(node.getIdentifier() != null) {
          node.getIdentifier().apply(this);
      }
      if(_pos!=null) return;
      if(node.getEnum() != null) {
          node.getEnum().apply(this);
      }
  }

  public void caseAFuncDecDeclaration(AFuncDecDeclaration node) {
      if(node.getBlock() != null) {
          node.getBlock().apply(this);
      }
      if(_pos!=null) return;
      if(node.getRParenthese() != null) {
          node.getRParenthese().apply(this);
      }
      if(_pos!=null) return;
      if(node.getFormalParamList() != null) {
          node.getFormalParamList().apply(this);
      }
      if(_pos!=null) return;
      if(node.getLParenthese() != null) {
          node.getLParenthese().apply(this);
      }
      if(_pos!=null) return;
      if(node.getIdentifier() != null) {
          node.getIdentifier().apply(this);
      } {
          Object temp[] = node.getBracketPair().toArray();
          for(int i = temp.length - 1; i >= 0; i--) {
              ((TBracketPair) temp[i]).apply(this);
          }
      }
      if(node.getType() != null) {
          node.getType().apply(this);
      }
      if(_pos!=null) return;
      if(node.getTypeParam() != null) {
          node.getTypeParam().apply(this);
      }
  }

  public void caseAConstDecDeclaration(AConstDecDeclaration node) {
      if(node.getSemicolon() != null) {
          node.getSemicolon().apply(this);
      }
      if(_pos!=null) return;
      if(node.getInitialiser() != null) {
          node.getInitialiser().apply(this);
      }
      if(_pos!=null) return;
      if(node.getIdentifier() != null) {
          node.getIdentifier().apply(this);
      }
      if(_pos!=null) return;
      if(node.getType() != null) {
          node.getType().apply(this);
      }
      if(_pos!=null) return;
      if(node.getConst() != null) {
          node.getConst().apply(this);
      }
  }

  public void caseAClassInnerDeclaration(AClassInnerDeclaration node) {
      if(node.getSemicolon() != null) {
          node.getSemicolon().apply(this);
      }
      if(_pos!=null) return;
      if(node.getInnerDeclaration() != null) {
          node.getInnerDeclaration().apply(this);
      }
  }

  public void caseAFormalParamList(AFormalParamList node) {
      {
          Object temp[] = node.getCommaTypeName().toArray();
          for(int i = temp.length - 1; i >= 0; i--) {
              ((PCommaTypeName) temp[i]).apply(this);
          }
      }
      if(node.getTypeName() != null) {
          node.getTypeName().apply(this);
      }
  }

  public void caseAEnumList(AEnumList node) {
      {
          Object temp[] = node.getCommaEnumList().toArray();
          for(int i = temp.length - 1; i >= 0; i--) {
              ((PCommaEnumList) temp[i]).apply(this);
          }
      }
      if(node.getIdentifier() != null) {
          node.getIdentifier().apply(this);
      }
  }

  public void caseACommaEnumList(ACommaEnumList node) {
      if(node.getIdentifier() != null) {
          node.getIdentifier().apply(this);
      }
      if(_pos!=null) return;
      if(node.getComma() != null) {
          node.getComma().apply(this);
      }
  }

  public void caseATypeName(ATypeName node) {
      if(node.getIdentifier() != null) {
          node.getIdentifier().apply(this);
      } {
          Object temp[] = node.getBracketPair().toArray();
          for(int i = temp.length - 1; i >= 0; i--) {
              ((TBracketPair) temp[i]).apply(this);
          }
      }
      if(node.getType() != null) {
          node.getType().apply(this);
      }
  }

  public void caseACommaTypeName(ACommaTypeName node) {
      if(node.getTypeName() != null) {
          node.getTypeName().apply(this);
      }
      if(_pos!=null) return;
      if(node.getComma() != null) {
          node.getComma().apply(this);
      }
  }

  public void caseAInitialiser(AInitialiser node) {
      if(node.getBoolExpression() != null) {
          node.getBoolExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getAssign() != null) {
          node.getAssign().apply(this);
      }
  }

  public void caseAStaticArrayInitialiser(AStaticArrayInitialiser node) {
      if(node.getArrayInit() != null) {
          node.getArrayInit().apply(this);
      }
      if(_pos!=null) return;
      if(node.getAssign() != null) {
          node.getAssign().apply(this);
      }
  }

  public void caseADynamicArrayInitialiser(ADynamicArrayInitialiser node) {
      if(node.getArrayAllocate() != null) {
          node.getArrayAllocate().apply(this);
      }
      if(_pos!=null) return;
      if(node.getAssign() != null) {
          node.getAssign().apply(this);
      }
  }

  public void caseANormalArrayInitialiser(ANormalArrayInitialiser node) {
      if(node.getInitialiser() != null) {
          node.getInitialiser().apply(this);
      }
  }

  public void caseAArrayInit(AArrayInit node) {
      if(node.getRBrace() != null) {
          node.getRBrace().apply(this);
      }
      if(_pos!=null) return;
      if(node.getInitList() != null) {
          node.getInitList().apply(this);
      }
      if(_pos!=null) return;
      if(node.getLBrace() != null) {
          node.getLBrace().apply(this);
      }
  }

  public void caseAScalarInitList(AScalarInitList node) {
      {
          Object temp[] = node.getCommaExp().toArray();
          for(int i = temp.length - 1; i >= 0; i--) {
              ((PCommaExp) temp[i]).apply(this);
          }
      }
      if(node.getExpression() != null) {
          node.getExpression().apply(this);
      }
  }

  public void caseAArrayInitList(AArrayInitList node) {
      {
          Object temp[] = node.getCommaArrayInit().toArray();
          for(int i = temp.length - 1; i >= 0; i--) {
              ((PCommaArrayInit) temp[i]).apply(this);
          }
      }
      if(node.getArrayInit() != null) {
          node.getArrayInit().apply(this);
      }
  }

  public void caseAScalarCommaInitList(AScalarCommaInitList node) {
      if(node.getExpression() != null) {
          node.getExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getComma() != null) {
          node.getComma().apply(this);
      }
  }

  public void caseAArrayCommaInitList(AArrayCommaInitList node) {
      if(node.getArrayInit() != null) {
          node.getArrayInit().apply(this);
      }
      if(_pos!=null) return;
      if(node.getComma() != null) {
          node.getComma().apply(this);
      }
  }

  public void caseACommaExp(ACommaExp node) {
      if(node.getExpression() != null) {
          node.getExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getComma() != null) {
          node.getComma().apply(this);
      }
  }

  public void caseACommaArrayInit(ACommaArrayInit node) {
      if(node.getArrayInit() != null) {
          node.getArrayInit().apply(this);
      }
      if(_pos!=null) return;
      if(node.getComma() != null) {
          node.getComma().apply(this);
      }
  }

  public void caseAColonString(AColonString node) {
      if(node.getExpression() != null) {
          node.getExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getColon() != null) {
          node.getColon().apply(this);
      }
  }

  public void caseATrueBooleanliteral(ATrueBooleanliteral node) {
      if(node.getTrue() != null) {
          node.getTrue().apply(this);
      }
  }

  public void caseAFalseBooleanliteral(AFalseBooleanliteral node) {
      if(node.getFalse() != null) {
          node.getFalse().apply(this);
      }
  }

  public void caseABasicTypeType(ABasicTypeType node) {
      if(node.getBasicType() != null) {
          node.getBasicType().apply(this);
      }
  }

  public void caseAReferenceTypeType(AReferenceTypeType node) {
      if(node.getReferenceType() != null) {
          node.getReferenceType().apply(this);
      }
  }

  public void caseACharBasicType(ACharBasicType node) {
      if(node.getChar() != null) {
          node.getChar().apply(this);
      }
  }

  public void caseAIntBasicType(AIntBasicType node) {
      if(node.getInt() != null) {
          node.getInt().apply(this);
      }
  }

  public void caseADoubleBasicType(ADoubleBasicType node) {
      if(node.getDouble() != null) {
          node.getDouble().apply(this);
      }
  }

  public void caseAStringBasicType(AStringBasicType node) {
      if(node.getString() != null) {
          node.getString().apply(this);
      }
  }

  public void caseABooleanBasicType(ABooleanBasicType node) {
      if(node.getBoolean() != null) {
          node.getBoolean().apply(this);
      }
  }

  public void caseAVoidBasicType(AVoidBasicType node) {
      if(node.getVoid() != null) {
          node.getVoid().apply(this);
      }
  }

  public void caseAClassTypeReferenceType(AClassTypeReferenceType node) {
      if(node.getTypeParam() != null) {
          node.getTypeParam().apply(this);
      }
      if(_pos!=null) return;
      if(node.getIdentifier() != null) {
          node.getIdentifier().apply(this);
      }
  }

  public void caseATypeParam(ATypeParam node) {
      if(node.getGreater() != null) {
          node.getGreater().apply(this);
      }
      if(_pos!=null) return;
      if(node.getTypeParamList() != null) {
          node.getTypeParamList().apply(this);
      }
      if(_pos!=null) return;
      if(node.getLess() != null) {
          node.getLess().apply(this);
      }
  }

  public void caseATypeParamList(ATypeParamList node) {
      {
          Object temp[] = node.getCommaType().toArray();
          for(int i = temp.length - 1; i >= 0; i--) {
              ((PCommaType) temp[i]).apply(this);
          }
      } {
          Object temp[] = node.getBracketPair().toArray();
          for(int i = temp.length - 1; i >= 0; i--) {
              ((TBracketPair) temp[i]).apply(this);
          }
      }
      if(node.getType() != null) {
          node.getType().apply(this);
      }
  }

  public void caseACommaType(ACommaType node) {
      {
          Object temp[] = node.getBracketPair().toArray();
          for(int i = temp.length - 1; i >= 0; i--) {
              ((TBracketPair) temp[i]).apply(this);
          }
      }
      if(node.getType() != null) {
          node.getType().apply(this);
      }
      if(_pos!=null) return;
      if(node.getComma() != null) {
          node.getComma().apply(this);
      }
  }

  public void caseABoolexpExpression(ABoolexpExpression node) {
      if(node.getBoolExpression() != null) {
          node.getBoolExpression().apply(this);
      }
  }

  public void caseAArrayIntExpression(AArrayIntExpression node) {
      if(node.getArrayAllocate() != null) {
          node.getArrayAllocate().apply(this);
      }
  }

  public void caseAArrayAllocate(AArrayAllocate node) {
      {
          Object temp[] = node.getBracketPair().toArray();
          for(int i = temp.length - 1; i >= 0; i--) {
              ((TBracketPair) temp[i]).apply(this);
          }
      } {
          Object temp[] = node.getArrayAccess().toArray();
          for(int i = temp.length - 1; i >= 0; i--) {
              ((PArrayAccess) temp[i]).apply(this);
          }
      }
      if(node.getType() != null) {
          node.getType().apply(this);
      }
      if(_pos!=null) return;
      if(node.getNew() != null) {
          node.getNew().apply(this);
      }
  }

  public void caseATermMathExpression(ATermMathExpression node) {
      if(node.getTerm() != null) {
          node.getTerm().apply(this);
      }
  }

  public void caseAPlusMathExpression(APlusMathExpression node) {
      if(node.getTerm() != null) {
          node.getTerm().apply(this);
      }
      if(_pos!=null) return;
      if(node.getPlus() != null) {
          node.getPlus().apply(this);
      }
      if(_pos!=null) return;
      if(node.getMathExpression() != null) {
          node.getMathExpression().apply(this);
      }
  }

  public void caseAMinusMathExpression(AMinusMathExpression node) {
      if(node.getTerm() != null) {
          node.getTerm().apply(this);
      }
      if(_pos!=null) return;
      if(node.getMinus() != null) {
          node.getMinus().apply(this);
      }
      if(_pos!=null) return;
      if(node.getMathExpression() != null) {
          node.getMathExpression().apply(this);
      }
  }

  public void caseAUnaryTerm(AUnaryTerm node) {
      if(node.getUnaryExp() != null) {
          node.getUnaryExp().apply(this);
      }
  }

  public void caseAMultTerm(AMultTerm node) {
      if(node.getUnaryExp() != null) {
          node.getUnaryExp().apply(this);
      }
      if(_pos!=null) return;
      if(node.getTimes() != null) {
          node.getTimes().apply(this);
      }
      if(_pos!=null) return;
      if(node.getTerm() != null) {
          node.getTerm().apply(this);
      }
  }

  public void caseADivTerm(ADivTerm node) {
      if(node.getUnaryExp() != null) {
          node.getUnaryExp().apply(this);
      }
      if(_pos!=null) return;
      if(node.getDivide() != null) {
          node.getDivide().apply(this);
      }
      if(_pos!=null) return;
      if(node.getTerm() != null) {
          node.getTerm().apply(this);
      }
  }

  public void caseAModTerm(AModTerm node) {
      if(node.getUnaryExp() != null) {
          node.getUnaryExp().apply(this);
      }
      if(_pos!=null) return;
      if(node.getMod() != null) {
          node.getMod().apply(this);
      }
      if(_pos!=null) return;
      if(node.getTerm() != null) {
          node.getTerm().apply(this);
      }
  }

  public void caseAMinusUnaryExp(AMinusUnaryExp node) {
      if(node.getUnaryExp() != null) {
          node.getUnaryExp().apply(this);
      }
      if(_pos!=null) return;
      if(node.getMinus() != null) {
          node.getMinus().apply(this);
      }
  }

  public void caseAPlusUnaryExp(APlusUnaryExp node) {
      if(node.getUnaryExp() != null) {
          node.getUnaryExp().apply(this);
      }
      if(_pos!=null) return;
      if(node.getPlus() != null) {
          node.getPlus().apply(this);
      }
  }

  public void caseANegateUnaryExp(ANegateUnaryExp node) {
      if(node.getUnaryExp() != null) {
          node.getUnaryExp().apply(this);
      }
      if(_pos!=null) return;
      if(node.getNot() != null) {
          node.getNot().apply(this);
      }
  }

  public void caseAPostfixExpUnaryExp(APostfixExpUnaryExp node) {
      if(node.getPostfixExp() != null) {
          node.getPostfixExp().apply(this);
      }
  }

  public void caseAPreincrForUnaryExp(APreincrForUnaryExp node) {
      if(node.getPreincr() != null) {
          node.getPreincr().apply(this);
      }
  }

  public void caseAPredecrForUnaryExp(APredecrForUnaryExp node) {
      if(node.getPredecr() != null) {
          node.getPredecr().apply(this);
      }
  }

  public void caseAPostincrForUnaryExp(APostincrForUnaryExp node) {
      if(node.getPostincr() != null) {
          node.getPostincr().apply(this);
      }
  }

  public void caseAPostdecrForUnaryExp(APostdecrForUnaryExp node) {
      if(node.getPostdecr() != null) {
          node.getPostdecr().apply(this);
      }
  }

  public void caseAFactorPostfixExp(AFactorPostfixExp node) {
      if(node.getFactor() != null) {
          node.getFactor().apply(this);
      }
  }

  public void caseAPostdecr(APostdecr node) {
      if(node.getMinusminus() != null) {
          node.getMinusminus().apply(this);
      }
      if(_pos!=null) return;
      if(node.getFieldAccess() != null) {
          node.getFieldAccess().apply(this);
      }
  }

  public void caseAPostincr(APostincr node) {
      if(node.getPlusplus() != null) {
          node.getPlusplus().apply(this);
      }
      if(_pos!=null) return;
      if(node.getFieldAccess() != null) {
          node.getFieldAccess().apply(this);
      }
  }

  public void caseAPredecr(APredecr node) {
      if(node.getFieldAccess() != null) {
          node.getFieldAccess().apply(this);
      }
      if(_pos!=null) return;
      if(node.getMinusminus() != null) {
          node.getMinusminus().apply(this);
      }
  }

  public void caseAPreincr(APreincr node) {
      if(node.getFieldAccess() != null) {
          node.getFieldAccess().apply(this);
      }
      if(_pos!=null) return;
      if(node.getPlusplus() != null) {
          node.getPlusplus().apply(this);
      }
  }

  public void caseANullFactor(ANullFactor node) {
      if(node.getNull() != null) {
          node.getNull().apply(this);
      }
  }

  public void caseAFieldaccessFactor(AFieldaccessFactor node) {
      if(node.getFieldAccess() != null) {
          node.getFieldAccess().apply(this);
      }
  }

  public void caseAFunctionFactor(AFunctionFactor node) {
      if(node.getFunctionApplication() != null) {
          node.getFunctionApplication().apply(this);
      }
  }

  public void caseANumberFactor(ANumberFactor node) {
      if(node.getNumber() != null) {
          node.getNumber().apply(this);
      }
  }

  public void caseAStringliteralFactor(AStringliteralFactor node) {
      if(node.getStringliteral() != null) {
          node.getStringliteral().apply(this);
      }
  }

  public void caseACharliteralFactor(ACharliteralFactor node) {
      if(node.getCharliteral() != null) {
          node.getCharliteral().apply(this);
      }
  }

  public void caseABoolliteralFactor(ABoolliteralFactor node) {
      if(node.getBooleanliteral() != null) {
          node.getBooleanliteral().apply(this);
      }
  }

  public void caseAExpressionFactor(AExpressionFactor node) {
      if(node.getRParenthese() != null) {
          node.getRParenthese().apply(this);
      }
      if(_pos!=null) return;
      if(node.getBoolExpression() != null) {
          node.getBoolExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getLParenthese() != null) {
          node.getLParenthese().apply(this);
      }
  }

  public void caseAINumber(AINumber node) {
      if(node.getIntnumber() != null) {
          node.getIntnumber().apply(this);
      }
  }

  public void caseADNumber(ADNumber node) {
      if(node.getDpnumber() != null) {
          node.getDpnumber().apply(this);
      }
  }

  public void caseATermBoolExpression(ATermBoolExpression node) {
      if(node.getBoolTerm() != null) {
          node.getBoolTerm().apply(this);
      }
  }

  public void caseAOrBoolExpression(AOrBoolExpression node) {
      if(node.getBoolTerm() != null) {
          node.getBoolTerm().apply(this);
      }
      if(_pos!=null) return;
      if(node.getOr() != null) {
          node.getOr().apply(this);
      }
      if(_pos!=null) return;
      if(node.getBoolExpression() != null) {
          node.getBoolExpression().apply(this);
      }
  }

  public void caseAXorBoolExpression(AXorBoolExpression node) {
      if(node.getBoolTerm() != null) {
          node.getBoolTerm().apply(this);
      }
      if(_pos!=null) return;
      if(node.getXor() != null) {
          node.getXor().apply(this);
      }
      if(_pos!=null) return;
      if(node.getBoolExpression() != null) {
          node.getBoolExpression().apply(this);
      }
  }

  public void caseAEqualityBoolTerm(AEqualityBoolTerm node) {
      if(node.getEquality() != null) {
          node.getEquality().apply(this);
      }
  }

  public void caseAAndBoolTerm(AAndBoolTerm node) {
      if(node.getEquality() != null) {
          node.getEquality().apply(this);
      }
      if(_pos!=null) return;
      if(node.getAnd() != null) {
          node.getAnd().apply(this);
      }
      if(_pos!=null) return;
      if(node.getBoolTerm() != null) {
          node.getBoolTerm().apply(this);
      }
  }

  public void caseARelationalEquality(ARelationalEquality node) {
      if(node.getRelational() != null) {
          node.getRelational().apply(this);
      }
  }

  public void caseAEqEquality(AEqEquality node) {
      if(node.getRelational() != null) {
          node.getRelational().apply(this);
      }
      if(_pos!=null) return;
      if(node.getEqual() != null) {
          node.getEqual().apply(this);
      }
      if(_pos!=null) return;
      if(node.getEquality() != null) {
          node.getEquality().apply(this);
      }
  }

  public void caseANeqEquality(ANeqEquality node) {
      if(node.getRelational() != null) {
          node.getRelational().apply(this);
      }
      if(_pos!=null) return;
      if(node.getNotequal() != null) {
          node.getNotequal().apply(this);
      }
      if(_pos!=null) return;
      if(node.getEquality() != null) {
          node.getEquality().apply(this);
      }
  }

  public void caseAMathRelational(AMathRelational node) {
      if(node.getMathExpression() != null) {
          node.getMathExpression().apply(this);
      }
  }

  public void caseALtRelational(ALtRelational node) {
      if(node.getMathExpression() != null) {
          node.getMathExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getLess() != null) {
          node.getLess().apply(this);
      }
      if(_pos!=null) return;
      if(node.getRelational() != null) {
          node.getRelational().apply(this);
      }
  }

  public void caseAGtRelational(AGtRelational node) {
      if(node.getMathExpression() != null) {
          node.getMathExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getGreater() != null) {
          node.getGreater().apply(this);
      }
      if(_pos!=null) return;
      if(node.getRelational() != null) {
          node.getRelational().apply(this);
      }
  }

  public void caseALteqRelational(ALteqRelational node) {
      if(node.getMathExpression() != null) {
          node.getMathExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getLessequal() != null) {
          node.getLessequal().apply(this);
      }
      if(_pos!=null) return;
      if(node.getRelational() != null) {
          node.getRelational().apply(this);
      }
  }

  public void caseAGteqRelational(AGteqRelational node) {
      if(node.getMathExpression() != null) {
          node.getMathExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getGreaterequal() != null) {
          node.getGreaterequal().apply(this);
      }
      if(_pos!=null) return;
      if(node.getRelational() != null) {
          node.getRelational().apply(this);
      }
  }

  public void caseAArrayFieldAccess(AArrayFieldAccess node) {
      {
          Object temp[] = node.getArrayAccess().toArray();
          for(int i = temp.length - 1; i >= 0; i--) {
              ((PArrayAccess) temp[i]).apply(this);
          }
      }
      if(node.getName() != null) {
          node.getName().apply(this);
      }
  }

  public void caseAScalarFieldAccess(AScalarFieldAccess node) {
      if(node.getName() != null) {
          node.getName().apply(this);
      }
  }

  public void caseASimpleNameName(ASimpleNameName node) {
      if(node.getSimpleName() != null) {
          node.getSimpleName().apply(this);
      }
  }

  public void caseAQualifiedNameName(AQualifiedNameName node) {
      if(node.getQualifiedName() != null) {
          node.getQualifiedName().apply(this);
      }
  }

  public void caseASimpleName(ASimpleName node) {
      if(node.getIdentifier() != null) {
          node.getIdentifier().apply(this);
      }
  }

  public void caseAQualifiedName(AQualifiedName node) {
      if(node.getIdentifier() != null) {
          node.getIdentifier().apply(this);
      }
      if(_pos!=null) return;
      if(node.getDot() != null) {
          node.getDot().apply(this);
      }
      if(_pos!=null) return;
      if(node.getFieldAccess() != null) {
          node.getFieldAccess().apply(this);
      }
  }

  public void caseAArrayAccess(AArrayAccess node) {
      if(node.getRBracket() != null) {
          node.getRBracket().apply(this);
      }
      if(_pos!=null) return;
      if(node.getMathExpression() != null) {
          node.getMathExpression().apply(this);
      }
      if(_pos!=null) return;
      if(node.getLBracket() != null) {
          node.getLBracket().apply(this);
      }
  }

	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
}