/*
 * Created on 26-Feb-2005
 */
package kenya.eclipse.ast;

import java.util.Iterator;
import java.util.List;

import minijava.analysis.DepthFirstAdapter;
import minijava.node.*;

/**
 * Does a toString without the extra spaces that node.toString() contains.
 * Only syntactically necessary spaces are included when identifiers or
 * lists are involved. In other expressions there may be spaces that 'look nice'.
 * @author Thomas Timbul
 */
public class NodeToString extends DepthFirstAdapter {
	
	public static String toString(Node n) {
		NodeToString s = new NodeToString();
		if(n==null) return "";
		n.apply(s);
		return s.getString();
	}
	
	protected NodeToString() {
		//subclasses privilege
	}
	
	protected StringBuffer buf = new StringBuffer();
	
	public String getString() {
		return buf.toString();
	}
	
	protected void applyTo(List list) {
		if(list==null) return;
	  for(Iterator i = list.iterator(); i.hasNext();) {
	  	Node n = (Node)i.next();
	  	n.apply(this);
	  }
  }
	
	public void caseAAndBoolTerm(AAndBoolTerm node) {
		if(node.getBoolTerm()!=null) {
			node.getBoolTerm().apply(this);
		}
		if(node.getAnd()!=null) {
			buf.append(' ');
			node.getAnd().apply(this);
		}
		if(node.getEquality()!=null) {
			buf.append(' ');
			node.getEquality().apply(this);
		}
	}
	public void caseAArrayAccess(AArrayAccess node) {
		if(node.getLBracket()!=null) {node.getLBracket().apply(this);}
		if(node.getMathExpression()!=null) {node.getMathExpression().apply(this);}
		if(node.getRBracket()!=null) {node.getRBracket().apply(this);}
	}
	public void caseAArrayAllocate(AArrayAllocate node) {
		if(node.getNew()!=null) {
			node.getNew().apply(this);
		}
    if(node.getType()!=null) {
    	buf.append(' ');
    	node.getType().apply(this);
    }
    applyTo(node.getArrayAccess());
    applyTo(node.getBracketPair());
	}
	public void caseAArrayCommaInitList(AArrayCommaInitList node) {
		if(node.getComma()!=null) {node.getComma().apply(this);}
		if(node.getArrayInit()!=null) {node.getArrayInit().apply(this);}
	}
	public void caseAArrayDecInnerDeclaration(AArrayDecInnerDeclaration node) {
		if(node.getType()!=null) {
			node.getType().apply(this);
		}
		applyTo(node.getBracketPair());
		if(node.getIdentifier()!=null) {
			buf.append(' ');
			node.getIdentifier().apply(this);
		}
		if(node.getArrayInitialiser()!=null) {
			buf.append(' ');
			node.getArrayInitialiser().apply(this);
		}
	}
	public void caseAArrayFieldAccess(AArrayFieldAccess node) {
		if(node.getName()!=null) {node.getName().apply(this);}
		applyTo(node.getArrayAccess());
	}
	public void caseAArrayInit(AArrayInit node) {
		if(node.getLBrace()!=null) {node.getLBrace().apply(this);}
		if(node.getInitList()!=null) {node.getInitList().apply(this);}
		if(node.getRBrace()!=null) {node.getRBrace().apply(this);}
	}
	public void caseAArrayInitList(AArrayInitList node) {
		if(node.getArrayInit()!=null) {node.getArrayInit().apply(this);}
		applyTo(node.getCommaArrayInit());
	}
	public void caseAArrayIntExpression(AArrayIntExpression node) {
		if(node.getArrayAllocate()!=null) {node.getArrayAllocate().apply(this);}
	}
	public void caseAAssertStatement(AAssertStatement node) {
		if(node.getAssert()!=null) {node.getAssert().apply(this);}
		if(node.getBoolExpression()!=null) {
			buf.append(' ');
	    node.getBoolExpression().apply(this);
    }
    if(node.getColonString()!=null) {
    	buf.append(' ');
      node.getColonString().apply(this);
    }
    if(node.getSemicolon()!=null) {node.getSemicolon().apply(this);}
	}
	public void caseAAssignment(AAssignment node) {
		if(node.getFieldAccess()!=null) {node.getFieldAccess().apply(this);}
		if(node.getAssign()!=null) {
			buf.append(' ');
			node.getAssign().apply(this);
		}
		if(node.getExpression()!=null) {
			buf.append(' ');
			node.getExpression().apply(this);
		}
	}
	public void caseAAssignmentForLeftStat(AAssignmentForLeftStat node) {
		if(node.getAssignment()!=null) {node.getAssignment().apply(this);}
	}
	public void caseAAssignmentForRightStat(AAssignmentForRightStat node) {
		if(node.getAssignment()!=null) {node.getAssignment().apply(this);}
	}
	public void caseAAssignmentStatement(AAssignmentStatement node) {
		if(node.getAssignment()!=null) {node.getAssignment().apply(this);}
		if(node.getSemicolon()!=null) {node.getSemicolon().apply(this);}
	}
	public void caseABasicTypeType(ABasicTypeType node) {
		if(node.getBasicType()!=null) {node.getBasicType().apply(this);}
	}
	public void caseABlock(ABlock node) {
		if(node.getLBrace()!=null) {node.getLBrace().apply(this);}
		if(node.getStatements()!=null) {
			buf.append(' ');
			node.getStatements().apply(this);
		}
		if(node.getRBrace()!=null) {
			buf.append(' ');
			node.getRBrace().apply(this);
		}
	}
	public void caseABlockElseFollow(ABlockElseFollow node) {
		if(node.getBlock()!=null) {node.getBlock().apply(this);}
	}
	public void caseABlockStatement(ABlockStatement node) {
		if(node.getBlock()!=null) {node.getBlock().apply(this);}
	}
	public void caseABooleanBasicType(ABooleanBasicType node) {
		if(node.getBoolean()!=null) {node.getBoolean().apply(this);}
	}
	public void caseABoolexpExpression(ABoolexpExpression node) {
		if(node.getBoolExpression()!=null) {node.getBoolExpression().apply(this);}
	}
	public void caseABoolliteralFactor(ABoolliteralFactor node) {
		if(node.getBooleanliteral()!=null) {node.getBooleanliteral().apply(this);}
	}
	public void caseABreakStatement(ABreakStatement node) {
		if(node.getBreak()!=null) {node.getBreak().apply(this);}
		if(node.getSemicolon()!=null) {node.getSemicolon().apply(this);}
	}
	public void caseACasePossibleCase(ACasePossibleCase node) {
		if(node.getCase()!=null) {node.getCase().apply(this);}
		if(node.getBoolExpression()!=null) {
			buf.append(' ');
			node.getBoolExpression().apply(this);
		}
		if(node.getColon()!=null) {node.getColon().apply(this);}
		if(node.getBlock()!=null) {
			buf.append(' ');
			node.getBlock().apply(this);
		}
	}
	public void caseACharBasicType(ACharBasicType node) {
		if(node.getChar()!=null) {node.getChar().apply(this);}
	}
	public void caseACharliteralFactor(ACharliteralFactor node) {
		if(node.getCharliteral()!=null) {node.getCharliteral().apply(this);}
	}
	public void caseAClassDecDeclaration(AClassDecDeclaration node) {
		if(node.getKlass()!=null) {node.getKlass().apply(this);}
		if(node.getIdentifier()!=null) {
			buf.append(' ');
			node.getIdentifier().apply(this);
		}
		if(node.getTypeParam()!=null) {node.getTypeParam().apply(this);}
		if(node.getLBrace()!=null) {
			buf.append(' ');
			node.getLBrace().apply(this);
		}
		if(node.getClassInnerDeclaration()!=null) {
			buf.append(' ');
			applyTo(node.getClassInnerDeclaration());
		}
		if(node.getRBrace()!=null) {
			buf.append(' ');
			node.getRBrace().apply(this);
		}
	}
	public void caseAClassInnerDeclaration(AClassInnerDeclaration node) {
		if(node.getInnerDeclaration()!=null) {node.getInnerDeclaration().apply(this);}
		if(node.getSemicolon()!=null) {node.getSemicolon().apply(this);}
	}
	public void caseAClassTypeReferenceType(AClassTypeReferenceType node) {
		if(node.getIdentifier()!=null) {node.getIdentifier().apply(this);}
		if(node.getTypeParam()!=null) {node.getTypeParam().apply(this);}
	}
	public void caseAColonString(AColonString node) {
		if(node.getColon()!=null) {node.getColon().apply(this);}
		if(node.getExpression()!=null) {
			buf.append(' ');
			node.getExpression().apply(this);
		}
	}
	public void caseACommaArrayInit(ACommaArrayInit node) {
		if(node.getComma()!=null) {node.getComma().apply(this);}
		if(node.getArrayInit()!=null) {node.getArrayInit().apply(this);}
	}
	public void caseACommaEnumList(ACommaEnumList node) {
		if(node.getComma()!=null) {node.getComma().apply(this);}
		if(node.getIdentifier()!=null) {node.getIdentifier().apply(this);}
	}
	public void caseACommaExp(ACommaExp node) {
		if(node.getComma()!=null) {node.getComma().apply(this);}
		if(node.getExpression()!=null) {node.getExpression().apply(this);}
	}
	public void caseACommaType(ACommaType node) {
		if(node.getComma()!=null) {node.getComma().apply(this);}
		if(node.getType()!=null) {node.getType().apply(this);}
		applyTo(node.getBracketPair());
	}
	public void caseACommaTypeName(ACommaTypeName node) {
		if(node.getComma()!=null) {node.getComma().apply(this);}
		if(node.getTypeName()!=null) {node.getTypeName().apply(this);}
	}
	public void caseAConstDecDeclaration(AConstDecDeclaration node) {
		if(node.getConst()!=null) {node.getConst().apply(this);}
		if(node.getType()!=null) {
			buf.append(' ');
			node.getType().apply(this);
		}
		if(node.getIdentifier()!=null) {
			buf.append(' ');
			node.getIdentifier().apply(this);
		}
		if(node.getInitialiser()!=null) {
			buf.append(' ');
			node.getInitialiser().apply(this);
		}
		if(node.getSemicolon()!=null) {node.getSemicolon().apply(this);}
	}
	public void caseADefaultPossibleCase(ADefaultPossibleCase node) {
		if(node.getDefault()!=null) {node.getDefault().apply(this);}
		if(node.getColon()!=null) {node.getColon().apply(this);}
		if(node.getBlock()!=null) {
			buf.append(' ');
			node.getBlock().apply(this);
		}
	}
	public void caseADivTerm(ADivTerm node) {
		if(node.getTerm()!=null) {node.getTerm().apply(this);}
		if(node.getDivide()!=null) {node.getDivide().apply(this);}
		if(node.getUnaryExp()!=null) {node.getUnaryExp().apply(this);}
	}
	public void caseADNumber(ADNumber node) {
		if(node.getDpnumber()!=null) {node.getDpnumber().apply(this);}
	}
	public void caseADoubleBasicType(ADoubleBasicType node) {
		if(node.getDouble()!=null) {node.getDouble().apply(this);}
	}
	public void caseADynamicArrayInitialiser(ADynamicArrayInitialiser node) {
		if(node.getAssign()!=null) {node.getAssign().apply(this);}
		if(node.getArrayAllocate()!=null) {
			buf.append(' ');
			node.getArrayAllocate().apply(this);
		}
	}
	public void caseAElsePart(AElsePart node) {
		if(node.getElse()!=null) {node.getElse().apply(this);}
		if(node.getElseFollow()!=null) {
			buf.append(' ');
			node.getElseFollow().apply(this);
		}
	}
	public void caseAEmptyDeclarations(AEmptyDeclarations node) {
		super.caseAEmptyDeclarations(node);
	}
	public void caseAEmptyStatements(AEmptyStatements node) {
		super.caseAEmptyStatements(node);
	}
	public void caseAEnumDecDeclaration(AEnumDecDeclaration node) {
		if(node.getEnum()!=null) {node.getEnum().apply(this);}
		if(node.getIdentifier()!=null) {
			buf.append(' ');
			node.getIdentifier().apply(this);
		}
		if(node.getLBrace()!=null) {
			buf.append(' ');
			node.getLBrace().apply(this);
		}
		if(node.getEnumList()!=null) {node.getEnumList().apply(this);}
		if(node.getRBrace()!=null) {node.getRBrace().apply(this);}
		if(node.getSemicolon()!=null) {node.getSemicolon().apply(this);}
	}
	public void caseAEnumList(AEnumList node) {
		if(node.getIdentifier()!=null) {node.getIdentifier().apply(this);}
		applyTo(node.getCommaEnumList());
	}
	public void caseAEqEquality(AEqEquality node) {
		if(node.getEquality()!=null) {node.getEquality().apply(this);}
		if(node.getEqual()!=null) {
			buf.append(' ');
			node.getEqual().apply(this);
		}
		if(node.getRelational()!=null) {
			buf.append(' ');
			node.getRelational().apply(this);
		}
	}
	public void caseAEqualityBoolTerm(AEqualityBoolTerm node) {
		if(node.getEquality()!=null) {node.getEquality().apply(this);}
	}
	public void caseAExpActualParamList(AExpActualParamList node) {
		if(node.getExpression()!=null) {node.getExpression().apply(this);}
	}
	public void caseAExpressionFactor(AExpressionFactor node) {
		if(node.getLParenthese()!=null) {node.getLParenthese().apply(this);}
		if(node.getBoolExpression()!=null) {node.getBoolExpression().apply(this);}
		if(node.getRParenthese()!=null) {node.getRParenthese().apply(this);}
	}
	public void caseAFactorPostfixExp(AFactorPostfixExp node) {
		if(node.getFactor()!=null) {node.getFactor().apply(this);}
	}
	public void caseAFalseBooleanliteral(AFalseBooleanliteral node) {
		if(node.getFalse()!=null) {node.getFalse().apply(this);}
	}
	public void caseAFieldaccessFactor(AFieldaccessFactor node) {
		if(node.getFieldAccess()!=null) {node.getFieldAccess().apply(this);}
	}
	public void caseAFormalParamList(AFormalParamList node) {
		if(node.getTypeName()!=null) {node.getTypeName().apply(this);}
		applyTo(node.getCommaTypeName());
	}
	public void caseAForStatement(AForStatement node) {
		if(node.getFor()!=null) {node.getFor().apply(this);}
		if(node.getForControl()!=null) {node.getForControl().apply(this);}
		if(node.getBlock()!=null) {node.getBlock().apply(this);}
	}
	public void caseAForUnaryStatement(AForUnaryStatement node) {
		if(node.getForUnaryExp()!=null) {node.getForUnaryExp().apply(this);}
		if(node.getSemicolon()!=null) {node.getSemicolon().apply(this);}
	}
	public void caseAFuncDecDeclaration(AFuncDecDeclaration node) {
		if(node.getTypeParam()!=null) {node.getTypeParam().apply(this);}
		if(node.getType()!=null) {node.getType().apply(this);}
		applyTo(node.getBracketPair());
		if(node.getIdentifier()!=null) {
			buf.append(' ');
			node.getIdentifier().apply(this);
		}
		if(node.getLParenthese()!=null) {node.getLParenthese().apply(this);}
		if(node.getFormalParamList()!=null) {node.getFormalParamList().apply(this);}
		if(node.getRParenthese()!=null) {node.getRParenthese().apply(this);}
		if(node.getBlock()!=null) {
			buf.append(' ');
			node.getBlock().apply(this);
		}
	}
	public void caseAFunctionApplication(AFunctionApplication node) {
		if(node.getName()!=null) {node.getName().apply(this);}
		if(node.getLParenthese()!=null) {node.getLParenthese().apply(this);}
		if(node.getActualParamList()!=null) {node.getActualParamList().apply(this);}
		if(node.getRParenthese()!=null) {node.getRParenthese().apply(this);}
	}
	public void caseAFunctioncallForRightStat(AFunctioncallForRightStat node) {
		if(node.getFunctionApplication()!=null) {node.getFunctionApplication().apply(this);}
	}
	public void caseAFunctioncallStatement(AFunctioncallStatement node) {
		if(node.getFunctionApplication()!=null) {node.getFunctionApplication().apply(this);}
		if(node.getSemicolon()!=null) {node.getSemicolon().apply(this);}
	}
	public void caseAFunctionFactor(AFunctionFactor node) {
		if(node.getFunctionApplication()!=null) {node.getFunctionApplication().apply(this);}
	}
	public void caseAGteqRelational(AGteqRelational node) {
		if(node.getRelational()!=null) {node.getRelational().apply(this);}
		if(node.getGreaterequal()!=null) {
			buf.append(' ');
			node.getGreaterequal().apply(this);
		}
		if(node.getMathExpression()!=null) {
			buf.append(' ');
			node.getMathExpression().apply(this);
		}
	}
	public void caseAGtRelational(AGtRelational node) {
		if(node.getRelational()!=null) {node.getRelational().apply(this);}
		if(node.getGreater()!=null) {
			buf.append(' ');
			node.getGreater().apply(this);
		}
		if(node.getMathExpression()!=null) {
			buf.append(' ');
			node.getMathExpression().apply(this);
		}
	}
	public void caseAIfElseFollow(AIfElseFollow node) {
		if(node.getIfStat()!=null) {node.getIfStat().apply(this);}
	}
	public void caseAIfStat(AIfStat node) {
		if(node.getIf()!=null) {node.getIf().apply(this);}
		if(node.getLParenthese()!=null) {node.getLParenthese().apply(this);}
		if(node.getBoolExpression()!=null) {node.getBoolExpression().apply(this);}
		if(node.getRParenthese()!=null) {node.getRParenthese().apply(this);}
		if(node.getBlock1()!=null) {
			buf.append(' ');
			node.getBlock1().apply(this);
		}
	}
	public void caseAIfStatement(AIfStatement node) {
		if(node.getIfStat()!=null) {node.getIfStat().apply(this);}
	}
	public void caseAInitialiser(AInitialiser node) {
		if(node.getAssign()!=null) {node.getAssign().apply(this);}
		if(node.getBoolExpression()!=null) {
			buf.append(' ');
			node.getBoolExpression().apply(this);
		}
	}
	public void caseAInnerDecForLeftStat(AInnerDecForLeftStat node) {
		if(node.getInnerDeclaration()!=null) {node.getInnerDeclaration().apply(this);}
	}
	public void caseAInnerDecStatement(AInnerDecStatement node) {
		if(node.getInnerDeclaration()!=null) {node.getInnerDeclaration().apply(this);}
		if(node.getSemicolon()!=null) {node.getSemicolon().apply(this);}
	}
	public void caseAIntBasicType(AIntBasicType node) {
		if(node.getInt()!=null) {node.getInt().apply(this);}
	}
	public void caseAINumber(AINumber node) {
		if(node.getIntnumber()!=null) {node.getIntnumber().apply(this);}
	}
	public void caseAJavaForControl(AJavaForControl node) {
		if(node.getLParenthese()!=null) {node.getLParenthese().apply(this);}
		if(node.getForLeftStat()!=null) {node.getForLeftStat().apply(this);}
		if(node.getS1()!=null) {node.getS1().apply(this);}
		if(node.getBoolExpression()!=null) {node.getBoolExpression().apply(this);}
		if(node.getS2()!=null) {node.getS2().apply(this);}
		if(node.getForRightStat()!=null) {node.getForRightStat().apply(this);}
		if(node.getRParenthese()!=null) {node.getRParenthese().apply(this);}
	}
	public void caseAListActualParamList(AListActualParamList node) {
		if(node.getExpression()!=null) {node.getExpression().apply(this);}
		if(node.getComma()!=null) {node.getComma().apply(this);}
		if(node.getActualParamList()!=null) {node.getActualParamList().apply(this);}
	}
	public void caseAListDeclarations(AListDeclarations node) {
		if(node.getDeclaration()!=null) {node.getDeclaration().apply(this);}
		if(node.getDeclarations()!=null) {node.getDeclarations().apply(this);}
	}
	public void caseAListStatements(AListStatements node) {
		if(node.getStatement()!=null) {node.getStatement().apply(this);}
		if(node.getStatements()!=null) {node.getStatements().apply(this);}
	}
	public void caseALteqRelational(ALteqRelational node) {
		if(node.getRelational()!=null) {node.getRelational().apply(this);}
		if(node.getLessequal()!=null) {
			buf.append(' ');
			node.getLessequal().apply(this);
		}
		if(node.getMathExpression()!=null) {
			buf.append(' ');
			node.getMathExpression().apply(this);
		}
	}
	public void caseALtRelational(ALtRelational node) {
		if(node.getRelational()!=null) {node.getRelational().apply(this);}
		if(node.getLess()!=null) {
			buf.append(' ');
			node.getLess().apply(this);
		}
		if(node.getMathExpression()!=null) {
			buf.append(' ');
			node.getMathExpression().apply(this);
		}
	}
	public void caseAMathRelational(AMathRelational node) {
		if(node.getMathExpression()!=null) {node.getMathExpression().apply(this);}
	}
	public void caseAMinusMathExpression(AMinusMathExpression node) {
		if(node.getMathExpression()!=null) {node.getMathExpression().apply(this);}
		if(node.getMinus()!=null) {node.getMinus().apply(this);}
		if(node.getTerm()!=null) {node.getTerm().apply(this);}
	}
	public void caseAMinusUnaryExp(AMinusUnaryExp node) {
		if(node.getMinus()!=null) {node.getMinus().apply(this);}
		if(node.getUnaryExp()!=null) {node.getUnaryExp().apply(this);}
	}
	public void caseAModTerm(AModTerm node) {
		if(node.getTerm()!=null) {node.getTerm().apply(this);}
		if(node.getMod()!=null) {node.getMod().apply(this);}
		if(node.getUnaryExp()!=null) {node.getUnaryExp().apply(this);}
	}
	public void caseAMultTerm(AMultTerm node) {
		if(node.getTerm()!=null) {node.getTerm().apply(this);}
		if(node.getTimes()!=null) {node.getTimes().apply(this);}
		if(node.getUnaryExp()!=null) {node.getUnaryExp().apply(this);}
	}
	public void caseANegateUnaryExp(ANegateUnaryExp node) {
		if(node.getNot()!=null) {node.getNot().apply(this);}
		if(node.getUnaryExp()!=null) {node.getUnaryExp().apply(this);}
	}
	public void caseANeqEquality(ANeqEquality node) {
		if(node.getEquality()!=null) {node.getEquality().apply(this);}
		if(node.getNotequal()!=null) {node.getNotequal().apply(this);}
		if(node.getRelational()!=null) {node.getRelational().apply(this);}
	}
	public void caseANormalArrayInitialiser(ANormalArrayInitialiser node) {
		if(node.getInitialiser()!=null) {node.getInitialiser().apply(this);}
	}
	public void caseANullFactor(ANullFactor node) {
		if(node.getNull()!=null) {node.getNull().apply(this);}
	}
	public void caseANumberFactor(ANumberFactor node) {
		if(node.getNumber()!=null) {node.getNumber().apply(this);}
	}
	public void caseAOrBoolExpression(AOrBoolExpression node) {
		if(node.getBoolExpression()!=null) {node.getBoolExpression().apply(this);}
		if(node.getOr()!=null) {
			buf.append(' ');
			node.getOr().apply(this);
		}
		if(node.getBoolTerm()!=null) {
			buf.append(' ');
			node.getBoolTerm().apply(this);
		}
	}
	public void caseAPlusMathExpression(APlusMathExpression node) {
		if(node.getMathExpression()!=null) {node.getMathExpression().apply(this);}
		if(node.getPlus()!=null) {node.getPlus().apply(this);}
		if(node.getTerm()!=null) {node.getTerm().apply(this);}
	}
	public void caseAPlusUnaryExp(APlusUnaryExp node) {
		if(node.getPlus()!=null) {node.getPlus().apply(this);}
		if(node.getUnaryExp()!=null) {node.getUnaryExp().apply(this);}
	}
	public void caseAPostdecr(APostdecr node) {
		if(node.getFieldAccess()!=null) {node.getFieldAccess().apply(this);}
		if(node.getMinusminus()!=null) {node.getMinusminus().apply(this);}
	}
	public void caseAPostdecrForUnaryExp(APostdecrForUnaryExp node) {
		if(node.getPostdecr()!=null) {node.getPostdecr().apply(this);}
	}
	public void caseAPostfixExpUnaryExp(APostfixExpUnaryExp node) {
		if(node.getPostfixExp()!=null) {node.getPostfixExp().apply(this);}
	}
	public void caseAPostincr(APostincr node) {
		if(node.getFieldAccess()!=null) {node.getFieldAccess().apply(this);}
		if(node.getPlusplus()!=null) {node.getPlusplus().apply(this);}
	}
	public void caseAPostincrForUnaryExp(APostincrForUnaryExp node) {
		if(node.getPostincr()!=null) {node.getPostincr().apply(this);}
	}
	public void caseAPredecr(APredecr node) {
		if(node.getMinusminus()!=null) {node.getMinusminus().apply(this);}
		if(node.getFieldAccess()!=null) {node.getFieldAccess().apply(this);}
	}
	public void caseAPredecrForUnaryExp(APredecrForUnaryExp node) {
		if(node.getPredecr()!=null) {node.getPredecr().apply(this);}
	}
	public void caseAPreincr(APreincr node) {
		if(node.getPlusplus()!=null) {node.getPlusplus().apply(this);}
		if(node.getFieldAccess()!=null) {node.getFieldAccess().apply(this);}
	}
	public void caseAPreincrForUnaryExp(APreincrForUnaryExp node) {
		if(node.getPreincr()!=null) {node.getPreincr().apply(this);}
	}
	public void caseAQualifiedName(AQualifiedName node) {
		if(node.getFieldAccess()!=null) {node.getFieldAccess().apply(this);}
		if(node.getDot()!=null) {node.getDot().apply(this);}
		if(node.getIdentifier()!=null) {node.getIdentifier().apply(this);}
	}
	public void caseAQualifiedNameName(AQualifiedNameName node) {
		if(node.getQualifiedName()!=null) {node.getQualifiedName().apply(this);}
	}
	public void caseAReferenceTypeType(AReferenceTypeType node) {
		if(node.getReferenceType()!=null) {node.getReferenceType().apply(this);}
	}
	public void caseARelationalEquality(ARelationalEquality node) {
		if(node.getRelational()!=null) {node.getRelational().apply(this);}
	}
	public void caseAReturnStatement(AReturnStatement node) {
		if(node.getReturn()!=null) {node.getReturn().apply(this);}
		if(node.getExpression()!=null) {node.getExpression().apply(this);}
		if(node.getSemicolon()!=null) {node.getSemicolon().apply(this);}
	}
	public void caseAScalarCommaInitList(AScalarCommaInitList node) {
		if(node.getComma()!=null) {node.getComma().apply(this);}
		if(node.getExpression()!=null) {node.getExpression().apply(this);}
	}
	public void caseAScalarFieldAccess(AScalarFieldAccess node) {
		if(node.getName()!=null) {node.getName().apply(this);}
	}
	public void caseAScalarInitList(AScalarInitList node) {
		if(node.getExpression()!=null) {node.getExpression().apply(this);}
		applyTo(node.getCommaExp());
	}
	public void caseASimpleName(ASimpleName node) {
		if(node.getIdentifier()!=null) {node.getIdentifier().apply(this);}
	}
	public void caseASimpleNameName(ASimpleNameName node) {
		if(node.getSimpleName()!=null) {node.getSimpleName().apply(this);}
	}
	public void caseAStaticArrayInitialiser(AStaticArrayInitialiser node) {
		if(node.getAssign()!=null) {node.getAssign().apply(this);}
		if(node.getArrayInit()!=null) {
			buf.append(' ');
			node.getArrayInit().apply(this);
		}
	}
	public void caseAStringBasicType(AStringBasicType node) {
		if(node.getString()!=null) {node.getString().apply(this);}
	}
	public void caseAStringliteralFactor(AStringliteralFactor node) {
		if(node.getStringliteral()!=null) {node.getStringliteral().apply(this);}
	}
	public void caseASwitchBlock(ASwitchBlock node) {
		if(node.getLBrace()!=null) {node.getLBrace().apply(this);}
		applyTo(node.getPossibleCase());
		if(node.getRBrace()!=null) {node.getRBrace().apply(this);}
	}
	public void caseASwitchStatement(ASwitchStatement node) {
		if(node.getSwitch()!=null) {node.getSwitch().apply(this);}
		if(node.getLParenthese()!=null) {node.getLParenthese().apply(this);}
		if(node.getBoolExpression()!=null) {node.getBoolExpression().apply(this);}
		if(node.getRParenthese()!=null) {node.getRParenthese().apply(this);}
		if(node.getSwitchBlock()!=null) {
			buf.append(' ');
			node.getSwitchBlock().apply(this);
		}
	}
	public void caseATermBoolExpression(ATermBoolExpression node) {
		if(node.getBoolTerm()!=null) {node.getBoolTerm().apply(this);}
	}
	public void caseATermMathExpression(ATermMathExpression node) {
		if(node.getTerm()!=null) {node.getTerm().apply(this);}
	}
	public void caseATrueBooleanliteral(ATrueBooleanliteral node) {
		if(node.getTrue()!=null) {node.getTrue().apply(this);}
	}
	public void caseATypeName(ATypeName node) {
		if(node.getType()!=null) {node.getType().apply(this);}
		applyTo(node.getBracketPair());
		if(node.getIdentifier()!=null) {
			buf.append(' ');
			node.getIdentifier().apply(this);
		}
	}
	public void caseATypeParam(ATypeParam node) {
		if(node.getLess()!=null) {node.getLess().apply(this);}
		if(node.getTypeParamList()!=null) {node.getTypeParamList().apply(this);}
		if(node.getGreater()!=null) {node.getGreater().apply(this);}
	}
	public void caseATypeParamList(ATypeParamList node) {
		if(node.getType()!=null) {node.getType().apply(this);}
		applyTo(node.getBracketPair());
		applyTo(node.getCommaType());
	}
	public void caseAUnaryForRightStat(AUnaryForRightStat node) {
		if(node.getForUnaryExp()!=null) {node.getForUnaryExp().apply(this);}
	}
	public void caseAUnaryTerm(AUnaryTerm node) {
		if(node.getUnaryExp()!=null) {node.getUnaryExp().apply(this);}
	}
	public void caseAVarDecInnerDeclaration(AVarDecInnerDeclaration node) {
		if(node.getType()!=null) {node.getType().apply(this);}
		if(node.getIdentifier()!=null) {
			buf.append(' ');
			node.getIdentifier().apply(this);
		}
		if(node.getInitialiser()!=null) {
			buf.append(' ');
			node.getInitialiser().apply(this);
		}
	}
	public void caseAVoidBasicType(AVoidBasicType node) {
		if(node.getVoid()!=null) {node.getVoid().apply(this);}
	}
	public void caseAWhileStatement(AWhileStatement node) {
		if(node.getWhile()!=null) {node.getWhile().apply(this);}
		if(node.getLParenthese()!=null) {node.getLParenthese().apply(this);}
		if(node.getBoolExpression()!=null) {node.getBoolExpression().apply(this);}
		if(node.getRParenthese()!=null) {node.getRParenthese().apply(this);}
		if(node.getBlock()!=null) {
			buf.append(' ');
			node.getBlock().apply(this);
		}
	}
	public void caseAXorBoolExpression(AXorBoolExpression node) {
		if(node.getBoolExpression()!=null) {node.getBoolExpression().apply(this);}
		if(node.getXor()!=null) {node.getXor().apply(this);}
		if(node.getBoolTerm()!=null) {node.getBoolTerm().apply(this);}
	}
	public void caseStart(Start node) {
		if(node.getPDeclarations()!=null) {node.getPDeclarations().apply(this);}
		if(node.getEOF()!=null) {node.getEOF().apply(this);}
	}
	
	
	public void caseTAnd(TAnd node) {
		buf.append(node.toString().trim());
	}
	public void caseTAssert(TAssert node) {
		buf.append(node.toString().trim());
	}
	public void caseTAssign(TAssign node) {
		buf.append(node.toString().trim());
	}
	public void caseTBlank(TBlank node) {
		buf.append(node.toString().trim());
	}
	public void caseTBoolean(TBoolean node) {
		buf.append(node.toString().trim());
	}
	public void caseTBracketPair(TBracketPair node) {
		buf.append(node.toString().trim());
	}
	public void caseTBreak(TBreak node) {
		buf.append(node.toString().trim());
	}
	public void caseTCase(TCase node) {
		buf.append(node.toString().trim());
	}
	public void caseTChar(TChar node) {
		buf.append(node.toString().trim());
	}
	public void caseTCharliteral(TCharliteral node) {
		buf.append(node.toString().trim());
	}
	public void caseTColon(TColon node) {
		buf.append(node.toString().trim());
	}
	public void caseTComma(TComma node) {
		buf.append(node.toString().trim());
	}
	public void caseTComment(TComment node) {
		buf.append(node.toString().trim());
	}
	public void caseTConst(TConst node) {
		buf.append(node.toString().trim());
	}
	public void caseTDefault(TDefault node) {
		buf.append(node.toString().trim());
	}
	public void caseTDivide(TDivide node) {
		buf.append(node.toString().trim());
	}
	public void caseTDot(TDot node) {
		buf.append(node.toString().trim());
	}
	public void caseTDouble(TDouble node) {
		buf.append(node.toString().trim());
	}
	public void caseTDpnumber(TDpnumber node) {
		buf.append(node.toString().trim());
	}
	public void caseTElse(TElse node) {
		buf.append(node.toString().trim());
	}
	public void caseTEnum(TEnum node) {
		buf.append(node.toString().trim());
	}
	public void caseTEqual(TEqual node) {
		buf.append(node.toString().trim());
	}
	public void caseTFalse(TFalse node) {
		buf.append(node.toString().trim());
	}
	public void caseTFor(TFor node) {
		buf.append(node.toString().trim());
	}
	public void caseTGreater(TGreater node) {
		buf.append(node.toString().trim());
	}
	public void caseTGreaterequal(TGreaterequal node) {
		buf.append(node.toString().trim());
	}
	public void caseTIdentifier(TIdentifier node) {
		buf.append(node.toString().trim());
	}
	public void caseTIf(TIf node) {
		buf.append(node.toString().trim());
	}
	public void caseTInt(TInt node) {
		buf.append(node.toString().trim());
	}
	public void caseTIntnumber(TIntnumber node) {
		buf.append(node.toString().trim());
	}
	public void caseTKlass(TKlass node) {
		buf.append(node.toString().trim());
	}
	public void caseTLBrace(TLBrace node) {
		buf.append(node.toString().trim());
	}
	public void caseTLBracket(TLBracket node) {
		buf.append(node.toString().trim());
	}
	public void caseTLess(TLess node) {
		buf.append(node.toString().trim());
	}
	public void caseTLessequal(TLessequal node) {
		buf.append(node.toString().trim());
	}
	public void caseTLParenthese(TLParenthese node) {
		buf.append(node.toString().trim());
	}
	public void caseTMinus(TMinus node) {
		buf.append(node.toString().trim());
	}
	public void caseTMinusminus(TMinusminus node) {
		buf.append(node.toString().trim());
	}
	public void caseTMod(TMod node) {
		buf.append(node.toString().trim());
	}
	public void caseTNew(TNew node) {
		buf.append(node.toString().trim());
	}
	public void caseTNewLine(TNewLine node) {
		buf.append(node.toString().trim());
	}
	public void caseTNot(TNot node) {
		buf.append(node.toString().trim());
	}
	public void caseTNotequal(TNotequal node) {
		buf.append(node.toString().trim());
	}
	public void caseTNull(TNull node) {
		buf.append(node.toString().trim());
	}
	public void caseTOr(TOr node) {
		buf.append(node.toString().trim());
	}
	public void caseTPlus(TPlus node) {
		buf.append(node.toString().trim());
	}
	public void caseTPlusplus(TPlusplus node) {
		buf.append(node.toString().trim());
	}
	public void caseTRBrace(TRBrace node) {
		buf.append(node.toString().trim());
	}
	public void caseTRBracket(TRBracket node) {
		buf.append(node.toString().trim());
	}
	public void caseTReservedWord(TReservedWord node) {
		buf.append(node.toString().trim());
	}
	public void caseTReturn(TReturn node) {
		buf.append(node.toString().trim());
	}
	public void caseTRParenthese(TRParenthese node) {
		buf.append(node.toString().trim());
	}
	public void caseTSemicolon(TSemicolon node) {
		buf.append(node.toString().trim());
	}
	public void caseTString(TString node) {
		buf.append(node.toString().trim());
	}
	public void caseTStringliteral(TStringliteral node) {
		buf.append(node.toString().trim());
	}
	public void caseTSwitch(TSwitch node) {
		buf.append(node.toString().trim());
	}
	public void caseTTimes(TTimes node) {
		buf.append(node.toString().trim());
	}
	public void caseTTraditionalComment(TTraditionalComment node) {
		buf.append(node.toString().trim());
	}
	public void caseTTrue(TTrue node) {
		buf.append(node.toString().trim());
	}
	public void caseTVoid(TVoid node) {
		buf.append(node.toString().trim());
	}
	public void caseTWhile(TWhile node) {
		buf.append(node.toString().trim());
	}
	public void caseTXor(TXor node) {
		buf.append(node.toString().trim());
	}
}