/*
 * Created on 12-Jan-2005
 */
package kenya.eclipse.ast;


import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import minijava.node.AEmptyStatements;
import minijava.node.AListStatements;
import minijava.node.Node;
import minijava.node.PName;
import minijava.node.PStatement;
import minijava.node.PStatements;
import minijava.node.PType;

/**
 * provides utility methods for checking and manipulating Nodes in
 * the Kenya abstract syntax tree
 * @author Thomas Timbul
 */
public class NodeTools {
	protected NodeTools() {}
	
	public static ISourceCodeLocation getLocation(Node node) {
		return AdvancedPositionFinder.getFullLocation(node, null);
	}
	
	/**
	 * returns the parent of n that is an instanceof stopat
	 * or null if no such parent can be found.
	 * n is returned if stopat is null
	 * @param n
	 * @param stopat
	 * @return
	 */
	public static Node getParent(Node n, Class stopat) {
		Node parent = n;
		while(stopat!=null && parent!=null && !stopat.isInstance(parent)) {
			parent = parent.parent();
		}
		return parent;
	}
	
	/**
	 * returns the parent of n that is 'levels' levels above.
	 * For example to obtain the immediate parent of n, call
	 * <br><code>getParent(n, 1);</code>.<br>
	 * If levels exceeds the number of parent levels, then the
	 * highest parent is returned. Usually this will be the root
	 * of the tree. This method does not return null.
	 * If the tree is complete, call<br>
	 * <code>getParent(n, Integer.MAX_VALUE);</code><br>
	 * to obtain the root of the AST.
	 * If levels is 0 or negative, n is simply returned.
	 * 
	 * @param n the node whose ancestor to find
	 * @param levels the level at which to find the ancestor
	 * @return a non-null Node which is n's parent at level 'levels'
	 */
	public static Node getParent(Node n, int levels) {
		Node parent = n;
		for(;levels>0; levels--) {
			if(parent.parent()==null) {
				return parent;
			}
			parent = parent.parent();
		}
		return parent;
	}
	
	public static PName getTopMostName(PName name) {
		PName result= name;
		while(result.parent() instanceof PName) {
			result= (PName)result.parent();
		}
		return result;
	}
	
	public static PType getTopMostType(PType type) {
		PType result= type;
		while(result.parent() instanceof PType) {
			result= (PType)result.parent();
		}
		return result;
	}
	
	
	/**
	 * compares logical content of nodes and returns true if they are equal
	 * this method does not handle all types of nodes. (hence limited)
	 * 
	 * <br>At the moment, this compares the toString value of the two nodes. (By no means content comparison!)
	 * <br>So therefore... <b>USE THIS AS A .LAST. RESORT ! ! !</b>
	 * 
	 * @param n1
	 * @param n2
	 * @return
	 */
	public static boolean limitedAreEqual(Node n1, Node n2) {
		
//		if(n1.getClass()!=n2.getClass() || n1==null || n2==null) {
//			//they are not same class or null, so comparison not possible (in this method)
//			return false;
//		}
		return n1.toString().equals(n2.toString());
	}
	
	public static PStatement getLastStatement(PStatements statements) {
		if (statements==null || statements instanceof AEmptyStatements) {
			return null;
		} else if (statements instanceof AListStatements) {
			AListStatements st = (AListStatements)statements;
			PStatement p = getLastStatement(st.getStatements());
			return p!=null?p:st.getStatement();
		}
		return null;
	}
	
}
