/*
 * Created on 27-Feb-2005
 */
package kenya.eclipse.ast.bindings;

import kenya.eclipse.ast.IBinding;
import minijava.node.Node;
import minijava.node.PType;

/**
 * @author Thomas Timbul
 */
public abstract class Binding implements IBinding {

	protected Node fNode;
	protected Node fDeclaringNode;
	protected String fDeclaration;
	protected PType fType;
	
	public Binding(Node node, Node declaringNode, PType type, String declaration) {
		fNode = node;
		fType = type;
		fDeclaringNode = declaringNode;
		fDeclaration = declaration;
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.ast.IBinding#getNode()
	 */
	public Node getNode() {
		return fNode;
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.ast.IBinding#getDeclaration()
	 */
	public String getDeclaration() {
		return fDeclaration;
	}

	/* (non-Javadoc)
	 * @see kenya.eclipse.ast.IBinding#getDeclaringNode()
	 */
	public Node getDeclaringNode() {
		return fDeclaringNode;
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.ast.IBinding#getType()
	 */
	public PType getType() {
		return fType;
	}
	
}
