/*
 * Created on 28-Feb-2005
 */
package kenya.eclipse.ast.bindings;

import kenya.sourceCodeInformation.interfaces.IClass;
import minijava.node.Node;
import minijava.node.PType;

/**
 * @author Thomas Timbul
 */
public class ClassVariableBinding extends VariableBinding implements IInnerVariableBinding {
	
	private IClass fClass;
	
	/**
	 * @param node
	 * @param declaringNode
	 * @param type
	 * @param declaration
	 */
	public ClassVariableBinding(Node node, IClass declaringClass, Node declaringNode, PType type, String declaration) {
		super(node, declaringNode, type, declaration);
		fClass = declaringClass;
	}
	
	public String toString() {
		return "[ClassVariableBinding: "+fClass.getName()+"."+fDeclaration+"]";
	}
	
	public IClass getDeclarer() {
		return fClass;
	}
	
}
