/*
 * Created on 30-Dec-2004
 */
package kenya.eclipse.debug.model.values;

import java.util.HashMap;

import kenya.eclipse.debug.model.KVariable;
import kenya.eclipse.debug.model.KenyaDebugTarget;
import kenya.sourceCodeInformation.interfaces.IVariable;

import org.eclipse.debug.core.DebugException;
import org.wellquite.kenya.stackMachine.types.interfaces.IArrayType;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

/**
 * represents an IArrayType as an IValue in the debugging model
 * 
 * @author Thomas Timbul
 */
public class KArrayValue extends KValue {
	
	private HashMap fVarMap = new HashMap();
	
	/*package*/ KArrayValue(KenyaDebugTarget target, IVariable var, IArrayType type) {
		super(target, var);
		fType = type;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#getValueString()
	 */
	public String getValueString() throws DebugException {
		StringBuffer b = new StringBuffer(fType.getTypeName());
		return b.insert(b.length()-1, ( (IArrayType)fType ).getLength()).toString();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#getVariables()
	 */
	public org.eclipse.debug.core.model.IVariable[] getVariables()
			throws DebugException {
		IType[] t = ( (IArrayType)fType ).getValue();
		
		KVariable[] v = new KVariable[t.length];
		
		for(int i=0; i<t.length; i++) {
			String key = "["+i+"]";
			v[i] = (KVariable)fVarMap.get(key);
			if(v[i]==null) {
				v[i] = new KVariable(fTarget, key, t[i], fVar );
				fVarMap.put(key, v[i]);
			}
		}
		
		return v;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#hasVariables()
	 */
	public boolean hasVariables() throws DebugException {
		return ( (IArrayType)fType ).getLength()>0;
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.debug.model.values.KValue#equals(kenya.eclipse.debug.model.values.KValue)
	 */
	public boolean equals(KValue obj) {
		try {
			boolean b= obj.getReferenceTypeName().equals(getReferenceTypeName());
			    b&= obj.fVar==fVar;
			    b&= obj.getValueString().equals(getValueString());
			    b&= ( (IArrayType)((KArrayValue)obj).fType ).getLength()==( (IArrayType)fType ).getLength();
			return b;
		} catch(DebugException e) {
			return false;
		}
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return super.hashCode() + ( (IArrayType)fType ).getLength();
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.debug.model.values.KValue#isValueEqual(kenya.eclipse.debug.model.values.KValue)
	 */
	public boolean isValueEqual(KValue val) {
		try {
			if(val instanceof KArrayValue) {
				KArrayValue v = (KArrayValue)val;
				boolean eq = (( (IArrayType)v.fType ).getLength()==( (IArrayType)fType ).getLength());
				KVariable[] vvars = (KVariable[])v.getVariables();
				KVariable[] vars = (KVariable[])getVariables();
				for(int i=0; i<vvars.length; i++) {
					eq &= vvars[i].isValueEqual(vars[i]);
				}
				
				return eq;
			}
		} catch(DebugException e) {
		}
		return false;
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.debug.model.values.KValue#clone()
	 */
	public Object clone() {
		KArrayValue v = (KArrayValue)super.clone();
		v.fVarMap = fVarMap;
		return v;
	}
}
