/*
 * Created on 30-Dec-2004
 */
package kenya.eclipse.debug.model.values;

import kenya.eclipse.debug.model.KenyaDebugTarget;
import kenya.sourceCodeInformation.interfaces.IVariable;

import org.eclipse.debug.core.DebugException;
import org.wellquite.kenya.stackMachine.types.interfaces.IStringType;

/**
 * represents an IArrayType as an IValue in the debugging model
 * @author Thomas Timbul
 */
public class KStringValue extends KValue {
	
	/*package*/ KStringValue(KenyaDebugTarget target, IVariable var, IStringType type) {
		super(target, var);
		fType = type;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#getValueString()
	 */
	public String getValueString() throws DebugException {
		return "\""+( (IStringType)fType ).getValue()+"\"";
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#getVariables()
	 */
	public org.eclipse.debug.core.model.IVariable[] getVariables()
			throws DebugException {
		return new org.eclipse.debug.core.model.IVariable[0];
	}
	
	/*
	 *  (non-Javadoc)
	 * @see kenya.eclipse.debug.model.values.KValue#isValueEqual(kenya.eclipse.debug.model.values.KValue)
	 */
	public boolean isValueEqual(KValue obj) {
		try {
			if(obj instanceof KStringValue) {
				return getValueString().equals(obj.getValueString());
			}
		} catch(DebugException e) {
		}
		return false;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#hasVariables()
	 */
	public boolean hasVariables() throws DebugException {
		return false;
	}
	
	/*
	 *  (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	public Object clone() {
		KStringValue v = (KStringValue)super.clone();
		return v;
	}
	
}
