/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package kenya.eclipse.debug.ui.launcher;


import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

/**
 * A dialog to select a type from a list of types. The dialog allows
 * multiple selections.
 * 
 * @since 2.1
 */
public class TypeSelectionDialog extends TwoPaneElementSelector {

	/** The main types. */
	private final IPath[] fTypes;
	
	private static class A extends LabelProvider {
		public String getText(Object element) {
			if(element instanceof IPath) {
				return ( (IPath)element ).removeFileExtension().lastSegment();
			}
			return super.getText(element);
		}
	}
	private static class B extends LabelProvider {
		public String getText(Object element) {
			return ( (IPath)element ).makeRelative().toString();
		}
	}
	
	public TypeSelectionDialog(Shell shell, IPath[] types) {
		
		super(shell, new A(), new B());
		
		Assert.isNotNull(types);
		fTypes= types;
		setMessage("Choose a program to launch");
		setUpperListLabel("Matching programs:");
		setLowerListLabel("Location:");
	}
	
	/**
	 * Returns the main types.
	 */
	public IPath[] getTypes() {
		return fTypes;
	}
	
	/*
	 * @see Windows#configureShell
	 */
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		//TODO WorkbenchHelp.setHelp(newShell, IJavaDebugHelpContextIds.MAIN_TYPE_SELECTION_DIALOG);
	}
	
	/*
	 * @see Window#open()
	 */
	public int open() {

		if (fTypes == null)
			return CANCEL;
		
		setElements(fTypes);
		return super.open();
	}
	
	/**
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	public Control createDialogArea(Composite parent) {
		Control control= super.createDialogArea(parent);
		applyDialogFont(control);
		return control;
	}
}
