/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Thomas Timbul - adaptation to Kenya Plugin
 *******************************************************************************/
package kenya.eclipse.multieditor.kenya;

import kenya.eclipse.KenyaConstants;
import kenya.eclipse.KenyaPlugin;

import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;

/**
 * 
 */
public class KenyaDocumentSetupParticipant implements IDocumentSetupParticipant {
	
	/**
	 */
	public KenyaDocumentSetupParticipant() {
	}
	
	/*
	 * @see org.eclipse.core.filebuffers.IDocumentSetupParticipant#setup(org.eclipse.jface.text.IDocument)
	 */
	public void setup(IDocument document) {
		if (document instanceof IDocumentExtension3) {
			IDocumentExtension3 extension3= (IDocumentExtension3) document;
			IDocumentPartitioner partitioner= new DefaultPartitioner(KenyaPlugin.getDefault().getKenyaPartitionScanner(), KenyaPartitionScanner.JAVA_PARTITION_TYPES);
			extension3.setDocumentPartitioner(KenyaConstants.KENYA_PARTITIONING, partitioner);
			partitioner.connect(document);
		}
	}
}
