/*
 * Created on 29-Jan-2005
 */
package kenya.eclipse.multieditor.kenya.correction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import kenya.eclipse.style.KenyaStyleManager;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

/**
 * @author Thomas Timbul
 */
public class KenyaCorrectionProcessor implements IContentAssistProcessor {
	
	private KenyaCorrectionAssistant fAssistant;
	
	private static String fErrorMessage;
	
	/**
	 * @param assistant
	 * 
	 */
	public KenyaCorrectionProcessor(KenyaCorrectionAssistant assistant) {
		super();
		fAssistant = assistant;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#computeCompletionProposals(org.eclipse.jface.text.ITextViewer, int)
	 */
	public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
		IEditorPart part= fAssistant.getEditor();
		
		IEditorInput input = part.getEditorInput();
		IDocumentProvider docProvider
		  = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
		IAnnotationModel model = docProvider.getAnnotationModel(input);
		
		int length= viewer != null ? viewer.getSelectedRange().y : 0;
		//AssistContext context= new AssistContext(cu, offset, length);
		
		fErrorMessage= null;
		ArrayList proposals= new ArrayList();
		if (model != null) {
			processAnnotations(/*context*/ offset,model, proposals);
		}
		if (proposals.isEmpty()) {
			proposals.add(new EmptyProposal("No Corrections available"));
		}
		
		ICompletionProposal[] res= (ICompletionProposal[]) proposals.toArray(new ICompletionProposal[proposals.size()]);
//		Arrays.sort(res, JavaCompletionProposalComparator.getInstance());
		return res;
	}
	
	private void processAnnotations(/*IInvocationContext context, */int offset,IAnnotationModel model, ArrayList proposals) {
//		int offset= context.getSelectionOffset();
		
		ArrayList problems= new ArrayList();
		Iterator iter= model.getAnnotationIterator();
		while (iter.hasNext()) {
			Annotation annotation= (Annotation) iter.next();
			if (isQuickFixableType(annotation)) {
				Position pos= model.getPosition(annotation);
				if (isAtPosition(offset, pos)) {
					processAnnotation(annotation, pos, problems, proposals);
				}
			}
		}
//		IProblemLocation[] problemLocations= (IProblemLocation[]) problems.toArray(new IProblemLocation[problems.size()]);
//		collectCorrections(context, problemLocations, proposals);
//		if (!fAssistant.isUpdatedOffset()) {
//			collectAssists(offset, problemLocations, proposals);
//		}
	}
	
	private boolean isAtPosition(int offset, Position pos) {
		return (pos != null) && (offset >= pos.getOffset() && offset <= (pos.getOffset() +  pos.getLength()));
	}
	
	
	private void processAnnotation(Annotation curr, Position pos, List problems, List proposals) {
		if (curr instanceof SimpleMarkerAnnotation) {
			IMarker marker= ((SimpleMarkerAnnotation) curr).getMarker();
			IMarkerResolution[] res= IDE.getMarkerHelpRegistry().getResolutions(marker);
			if (res.length > 0) {
				for (int i= 0; i < res.length; i++) {
					proposals.add(new MarkerResolutionProposal(res[i], marker));
				}
			}
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#computeContextInformation(org.eclipse.jface.text.ITextViewer, int)
	 */
	public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#getCompletionProposalAutoActivationCharacters()
	 */
	public char[] getCompletionProposalAutoActivationCharacters() {
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#getContextInformationAutoActivationCharacters()
	 */
	public char[] getContextInformationAutoActivationCharacters() {
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#getErrorMessage()
	 */
	public String getErrorMessage() {
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#getContextInformationValidator()
	 */
	public IContextInformationValidator getContextInformationValidator() {
		return null;
	}
	
	/**
	 * @param annot
	 * @return
	 */
	public static boolean isQuickFixableType(Annotation annot) {
		return annot instanceof SimpleMarkerAnnotation && !annot.isMarkedDeleted();
	}
	
	/**
	 * @param annot
	 * @return
	 */
	public static boolean hasCorrections(Annotation annot) {
		return KenyaStyleManager.hasCorrections(annot);
	}
	
}
