/*
 * Created on 17-Feb-2005
 */
package kenya.eclipse.multieditor.kenya.util;

import java.util.Comparator;

import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;

/**
 * @author Thomas Timbul
 */
public final class SourceCodeLocationComparator implements Comparator {
	
	private static SourceCodeLocationComparator fInstance;
	
	private SourceCodeLocationComparator() {}
	
	public static SourceCodeLocationComparator getInstance() {
		if (fInstance == null) {
			fInstance = new SourceCodeLocationComparator();
		}
		return fInstance;
	}
	
	/**
	 * from the point of view of this comparator, any object is equal
	 * this implementation returns 0
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(Object o1, Object o2) {
		return 0;
	}
	
	/**
	 * Compares ISourceCodeLocations by line number, column number and length.
	 * The result is the difference in line numbers, unless they are equal, in which
	 * case the result is the difference in column numbers, unless they
	 * are also equal, in which case the difference in length is returned.
	 * @param a
	 * @param b
	 * @return
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(ISourceCodeLocation a, ISourceCodeLocation b) {
		if(a.getLineNumber()==b.getLineNumber()) {
			if(a.getColumnNumber()==b.getColumnNumber()) {
				return a.getTokenLength()-b.getTokenLength();
			} else {
				return a.getColumnNumber()-b.getColumnNumber();
			}
		} else {
			return a.getLineNumber()-b.getLineNumber();
		}
	}
	
}
