/*
 * Created on 18-May-2005
 */
package kenya.eclipse.multieditor.text;

import java.io.ByteArrayInputStream;

import kenya.eclipse.ast.SimpleASTProvider;
import minijava.node.Start;

import org.eclipse.text.edits.TextEdit;

/**
 * @author Thomas Timbul
 */
public class SimpleFormatter {
	
	public static TextEdit format(String text, int offset, int length, String lineseparator) {
		
		Start s = SimpleASTProvider.getAST(new ByteArrayInputStream(text.getBytes()));
		
		if (s==null) {
			return null;
		}
		
		FormattingVisitor fv = new FormattingVisitor();
		s.apply(fv);
		
		return fv.getRootEdit();
	}
	
}
