/*
 * Created on 13-Nov-2004
 */
package kenya.eclipse.multieditor.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.ByteArrayInputStream;

import kenya.eclipse.KenyaPlugin;
import mediator.IJavaCode;
import mediator.subscription.IJavaCodeReceiver;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/**
 * @author Thomas Timbul
 */
public class GeneratedJava implements IStorage, IJavaCodeReceiver {
	
	private IJavaCode code = null;
	private boolean change = false;
	
	private String name;
	
	public GeneratedJava(final String classname) {
		this.name = classname;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.resources.IStorage#getContents()
	 */
	public InputStream getContents() throws CoreException {
		change = false;
		return new ByteArrayInputStream(getStringContents(code).getBytes());
	}
	
	/**
	 * @return
	 * @throws CoreException
	 */
	public String getContentsAsString() throws CoreException {
		String s = getStringContents(code); //throws the exc.
		change = false;
		return s;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.resources.IStorage#getFullPath()
	 */
	public IPath getFullPath() {
		//virtual storage - no path
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.resources.IStorage#getName()
	 */
	public String getName() {
		return name;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.resources.IStorage#isReadOnly()
	 */
	public boolean isReadOnly() {
		//java code is not editable
		return true;
	}

	/* (non-Javadoc)
	 * @see mediator.subscription.IJavaCodeReceiver#setJavaCode(mediator.IJavaCode)
	 */
	public void setJavaCode(final IJavaCode code) {
		if(
					this.code!=null && !codeIsEquivalent(this.code,code)
					|| this.code==null
				) {
			this.code = code;
			change = true;
		}
	}
	
	protected String getStringContents(final IJavaCode code) throws CoreException {
//	returns the actual String contents of the code unless code==null
		
		if(code!=null) {
			//if the code exists...
			String s = "";
			
			Reader content = code.getCode(name);
			//read the contents back first
			try {
				char c;
				while(true) {
					c = (char)content.read();
					if(!Character.isDefined(c)) {
						break;
					}
					s += c;
				}
				return s;
				
			} catch(IOException e) {
				//catch any read exceptions
				//e.printStackTrace();
				throw new CoreException(new Status(
			  		IStatus.ERROR,
						KenyaPlugin.getPluginId(),
						IStatus.ERROR,
						e.getMessage(),
						e
					));
			}
		} else {
			return "Kenya code contains errors, can not translate to Java.";
		}
	}
	
	/**
	 * returns whether or not the two pieces of code are equivalent.
	 * This assumes that two IJavaCode objects are generated in the same
	 * way, which means that their source code representation is exactly equal
	 * iff they have exactly the same meaning.
	 * @param code2
	 * @param code3
	 * @return
	 */
	private boolean codeIsEquivalent(final IJavaCode code2, final IJavaCode code3) {
		try {
			return (getStringContents(code2).equals(getStringContents(code3)));
		} catch(CoreException e) {
			return false;
		}
	}

	/**
	 * returns whether or not this input has changed since last time
	 * its contents were successfully retrieved using
	 * getContents() or getContentsAsString()
	 * @return
	 */
	public boolean hasChanged() {
		return change;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter) {
		if(getClass().isAssignableFrom(adapter)) {
			return this;
		}
		return null;
	}
	
}
