/*
 * Created on 06-Jan-2005
 */
package kenya.eclipse.style;

import java.util.ArrayList;
import java.util.List;

import kenya.eclipse.buildext.AbstractKenyaPostBuildAnalyser;
import kenya.eclipse.buildext.IKenyaPostBuildAnalyserFactory;
import kenya.eclipse.buildext.NullAnalyser;
import kenya.eclipse.style.checkerimpl.IStyleChecker;
import kenya.eclipse.style.properties.PropertyUtils;

import org.eclipse.core.resources.IFile;

/**
 * @author Thomas Timbul
 */
public class StyleCheckingFactory implements IKenyaPostBuildAnalyserFactory {
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.buildext.IKenyaPostBuildAnalyserFactory#createParticipant(java.lang.Object)
	 */
	public AbstractKenyaPostBuildAnalyser createAnalyser(Object configElem) {
		
		if(configElem instanceof IFile) {
			IFile file = (IFile)configElem;
			
			final List checks = (PropertyUtils.isStyleCheckingEnabled(file, true))
			  ?PropertyUtils.getFilteredEnabledStyleChecks(file, PropertyUtils.ENABLED, true)
			  :new ArrayList(0);
				
				return new AbstractStylePostBuildAnalyser(file) {
					protected IStyleChecker[] getCheckersToExecute() {
						return (IStyleChecker[])checks.toArray(new IStyleChecker[checks.size()]);
					}
				};
		}
		
		return NullAnalyser.getInstance();
	}
	
}
