/*
 * Created on 21-Jan-2005
 */
package kenya.eclipse.style.checks.swit;

import java.util.ArrayList;
import java.util.List;

import minijava.analysis.DepthFirstAdapter;
import minijava.node.ASwitchStatement;
import minijava.node.Node;

/**
 * @author Thomas Timbul
 */
public class SwitchSearch extends DepthFirstAdapter {
	
	/**
	 * returns list of all ASwitchStatements in the given node.
	 * This INCLUDES nested switches.
	 * @param n
	 * @return
	 */
	public static List getSwitchStatements(Node n) {
		SwitchSearch ss = new SwitchSearch();
		n.apply(ss);
		return ss._switches;
	}
	
	private ArrayList _switches = new ArrayList();
	
	private SwitchSearch() {}
	
	public void caseASwitchStatement(ASwitchStatement node) {
		_switches.add(node);
		super.caseASwitchStatement(node);
	}
	
}
