/*
 * Created on 29-Jan-2005
 */
package kenya.eclipse.ui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * @author Thomas Timbul
 */
public class ActionMessages {
	private static final String BUNDLE_NAME = "kenya.eclipse.ui.actionMessages";//$NON-NLS-1$

	private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle
			.getBundle(BUNDLE_NAME);

	private ActionMessages() {
	}

	public static String getString(String key) {
		try {
			return RESOURCE_BUNDLE.getString(key);
		} catch(MissingResourceException e) {
			return '!' + key + '!';
		}
	}

	public static ResourceBundle getResourceBundle() {
		return RESOURCE_BUNDLE;
	}
}