/*
 * Created on 24-Oct-2004
 */
package kenya.eclipse.ui.perspectives;

import kenya.eclipse.KenyaConstants;

import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.console.IConsoleConstants;

/**
 * @author Thomas Timbul
 */
public class KenyaPerspectiveFactory implements IPerspectiveFactory {
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
	 */
	public void createInitialLayout(IPageLayout layout) {
		
		String editorArea =  layout.getEditorArea();
		
		IFolderLayout topLeft = layout.createFolder("topLeft", IPageLayout.LEFT, 0.23F, editorArea);
		
		topLeft.addView(KenyaConstants.VIEW_K_RES_NAV_ID);
		topLeft.addView(IPageLayout.ID_RES_NAV);
		
		// Bottom left: Outline view
		IFolderLayout bottomLeft = layout.createFolder("bottomLeft", IPageLayout.BOTTOM, 0.55F, "topLeft");
		bottomLeft.addView(IPageLayout.ID_OUTLINE);
		
		//bottom right: tasks, problems, etc
		IFolderLayout outputFolder = layout.createFolder("bottomRight", IPageLayout.BOTTOM, 0.75F, editorArea);
		outputFolder.addView(IPageLayout.ID_PROBLEM_VIEW);
		outputFolder.addView(IPageLayout.ID_TASK_LIST);
		outputFolder.addPlaceholder(NewSearchUI.SEARCH_VIEW_ID);
		outputFolder.addPlaceholder(IConsoleConstants.ID_CONSOLE_VIEW);
		outputFolder.addPlaceholder(IPageLayout.ID_BOOKMARKS);
		outputFolder.addPlaceholder("org.eclipse.ui.views.ProgressView");
		
		//action sets for the toolbar
		
		layout.addActionSet(IDebugUIConstants.LAUNCH_ACTION_SET);
		layout.addActionSet(IPageLayout.ID_NAVIGATE_ACTION_SET);
		
	}
	
}
