/*
 * Created on 11-Nov-2004
 */
package kenya.eclipse.ui.wizards;

import java.text.MessageFormat;

/**
 * @author Thomas Timbul
 */
final class NewKenyaProjectConstants {
	
	public static final String Title = "Kenya Project";
	public static final String Description = "Create a new Kenya project";
	
	public static final String Pagetitle = "Kenya";
	public static final String Pagedescription = "Create a Kenya project";
	public static final String Label = "&Project Name";
	public static final String CategoryName = "Kenya";
	
	
	public static final String op_errorTitle="Project Creation Failed";
	public static final String op_errorMessage="Project could not be created.";
	
	public static final String overwritequeryTitle="Overwrite";
	public static final String overwritequeryMessage="Do you want to overwrite {0}?";
	
	
	public static final String op_desc="Creating example projects...";
	public static final String op_desc_proj="Configuring project...";
	
	public static final String errorAlreadyexists="Project already exists.";
	
	/**
	 * Gets a string from the resource bundle and formats it with the argument
	 * 
	 * @param key	the string used to get the bundle value, must not be null
	 */
	public static String getFormattedString(String key, Object arg) {
		return MessageFormat.format(key, new Object[] { arg });
	}


	/**
	 * Gets a string from the resource bundle and formats it with arguments
	 */	
	public static String getFormattedString(String key, Object[] args) {
		return MessageFormat.format(key, args);
	}
	
	private NewKenyaProjectConstants() {
		//inhibit instantiation
	}

}
