/*
 * Decompiled with CFR 0.152.
 */
package kenya;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import kenya.KenyaCore;
import kenya.errors.SourceCodeException;
import kenya.interpreter.util.InterpreterLastPointReachedCatcher;
import mediator.ICheckedCode;
import mediator.IJavaCode;
import mediator.Mediator;
import mediator.stackMachine.IStackMachineInformationProvider;
import mediator.util.StreamHandler;
import org.wellquite.kenya.stackMachine.ClosureMiscHelper;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.IJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;
import org.wellquite.kenya.stackMachine.scope.ClosureScope;
import org.wellquite.kenya.stackMachine.types.ArrayTypeFactory;
import org.wellquite.kenya.stackMachine.types.StringTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class CommandLineKenya {
    public static final String VERSION = "4.2";
    private static boolean exiting = false;
    static final List exitListeners = new ArrayList();
    private static final AbstractJob exitJob = new AbstractJob(){

        public void execute() {
            ArrayList exiters = new ArrayList(exitListeners);
            for (int idx = 0; idx < exiters.size(); ++idx) {
                AbstractJob exitingJob = (AbstractJob)exiters.get(idx);
                if (exitingJob == null) continue;
                exitingJob.execute();
            }
            JobDispatch.shutDownAllJobs();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    };
    public static final String cmdhelp = KenyaCore.commonhelp1 + "        kenya (options) kenyaFile [arguments]" + KenyaCore.NEWLINE + "At least one option needs to be specified, valid options are:" + KenyaCore.optionshelp;

    public static Getopt getOpts(String[] args) {
        return new Getopt("Kenya", args, "hdpfeltyscin", new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("debug", 0, null, 100), new LongOpt("parse", 0, null, 112), new LongOpt("typefind", 0, null, 102), new LongOpt("definitionfind", 0, null, 101), new LongOpt("builtinload", 0, null, 108), new LongOpt("typecheck", 0, null, 116), new LongOpt("structcheck", 0, null, 121), new LongOpt("translate", 0, null, 115), new LongOpt("execute", 1, null, 99), new LongOpt("interpret", 0, null, 105), new LongOpt("license", 0, null, 110)});
    }

    public static void main(String[] args) {
        int opt;
        Getopt op = CommandLineKenya.getOpts(args);
        int debugOptions = 0;
        boolean translate = false;
        boolean execute = false;
        String path = null;
        boolean interpret = false;
        block14: while ((opt = op.getopt()) != -1) {
            switch (opt) {
                case 104: {
                    CommandLineKenya.printHelp();
                    System.exit(0);
                    continue block14;
                }
                case 110: {
                    KenyaCore.printLicense();
                    System.exit(0);
                    continue block14;
                }
                case 100: {
                    debugOptions |= 1;
                    continue block14;
                }
                case 112: {
                    debugOptions |= 2;
                    continue block14;
                }
                case 102: {
                    debugOptions |= 4;
                    continue block14;
                }
                case 101: {
                    debugOptions |= 8;
                    continue block14;
                }
                case 108: {
                    debugOptions |= 0x10;
                    continue block14;
                }
                case 116: {
                    debugOptions |= 0x20;
                    continue block14;
                }
                case 121: {
                    debugOptions |= 0x40;
                    continue block14;
                }
                case 115: {
                    translate = true;
                    continue block14;
                }
                case 99: {
                    execute = true;
                    path = op.getOptarg();
                    continue block14;
                }
                case 105: {
                    interpret = true;
                    continue block14;
                }
            }
            CommandLineKenya.printHelp();
            System.exit(1);
        }
        int argIndex = op.getOptind();
        if (argIndex < args.length) {
            String[] argsLeft = new String[args.length - argIndex];
            System.arraycopy(args, argIndex, argsLeft, 0, argsLeft.length);
            CommandLineKenya.doCommandLine(argsLeft, debugOptions, translate, execute, interpret, path);
        } else {
            KenyaCore.printError("Command Line Kenya needs files to operate upon.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doCommandLine(String[] files, int dbg, boolean translate, boolean execute, boolean interpret, String filePath) {
        block19: {
            StackMachine sm = new StackMachine();
            try {
                FileReader fis = new FileReader(files[0]);
                ICheckedCode icc = Mediator.check(fis, dbg, System.out);
                if (icc.isErroredCode()) {
                    for (SourceCodeException sce : icc.getErrors()) {
                        System.err.println(sce.getMessage());
                    }
                    System.out.println(files[0] + ": INVALID CODE.");
                    break block19;
                }
                System.out.println(files[0] + ": VALID CODE.");
                if (interpret) {
                    IStackMachineInformationProvider ismp = icc.getBaseStackMachine();
                    InterpreterLastPointReachedCatcher ilprc = new InterpreterLastPointReachedCatcher(sm);
                    sm.addPositionReachedListener(ilprc);
                    sm.setStepMode(false);
                    try {
                        ClosureScope scope = new ClosureScope();
                        ClosureMiscHelper.executeClosureInScope(scope, ismp.getPreInitClosure(), sm);
                        IType[] array = new IType[files.length - 1];
                        for (int idx = 1; idx < files.length; ++idx) {
                            array[idx - 1] = StringTypeFactory.createStringType(files[idx]);
                        }
                        sm.push(ArrayTypeFactory.createArrayType(array, "String"));
                        sm.invokeMethod(ismp.getEntryPointClass(), ismp.getEntryPoint());
                        break block19;
                    }
                    catch (Throwable t) {
                        sm.getErr().println(t + " at " + ilprc.getLastPointData());
                        break block19;
                    }
                    finally {
                        CommandLineKenya.exit();
                    }
                }
                if (translate) {
                    String s;
                    BufferedReader r = new BufferedReader(icc.translate().getPlaceHeldCode());
                    while ((s = r.readLine()) != null) {
                        System.out.println(s);
                    }
                } else if (execute) {
                    boolean res;
                    long v = 0L;
                    String s = "_Command";
                    IJavaCode ijc = icc.translate();
                    while (!ijc.isValidClassName(s + v)) {
                        ++v;
                    }
                    String[] args = new String[files.length - 1];
                    System.arraycopy(files, 1, args, 0, args.length);
                    final PipedOutputStream stdInPOS = new PipedOutputStream();
                    PipedInputStream stdIn = new PipedInputStream(stdInPOS);
                    BufferedWriter stdInWriter = new BufferedWriter(new OutputStreamWriter(stdInPOS));
                    BufferedWriter stdOutWriter = new BufferedWriter(new OutputStreamWriter(System.out));
                    BufferedWriter stdErrWriter = new BufferedWriter(new OutputStreamWriter(System.err));
                    BufferedReader stdInReader = new BufferedReader(new InputStreamReader(stdIn));
                    final StreamHandler sh = new StreamHandler(new BufferedReader(new InputStreamReader(System.in)), stdInWriter);
                    JobDispatch.enqueueJob(sh);
                    JobDispatch.enqueueJob(new AbstractJob(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void execute() {
                            try {
                                StreamHandler streamHandler = sh;
                                synchronized (streamHandler) {
                                    while (!sh.isFinished()) {
                                        sh.wait();
                                    }
                                }
                                if (KenyaCore.DEBUG_OUTPUT) {
                                    System.out.println("stream handler B finished");
                                }
                                stdInPOS.close();
                                if (KenyaCore.DEBUG_OUTPUT) {
                                    System.out.println("stream handler BB finished");
                                }
                            }
                            catch (InterruptedException ie) {
                                ie.printStackTrace();
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                        }
                    });
                    if (KenyaCore.DEBUG_OUTPUT) {
                        System.out.println("about to execute");
                    }
                    if (!(res = icc.translate().execute(filePath, s + v, stdInReader, stdInWriter, stdOutWriter, stdErrWriter, args)) && KenyaCore.DEBUG_OUTPUT) {
                        System.err.println("Translate & Execute failed");
                    }
                    System.in.close();
                    System.out.flush();
                    System.err.flush();
                    CommandLineKenya.exit();
                }
            }
            catch (FileNotFoundException e) {
                System.err.println("File Not Found: " + files[0]);
            }
            catch (IOException ioe) {
                System.err.println("IOException on: " + files[0]);
            }
        }
        CommandLineKenya.exit();
    }

    public static synchronized void exit() {
        if (!exiting) {
            exiting = true;
            JobDispatch.enqueueJob(exitJob);
        }
    }

    public static synchronized boolean isExiting() {
        return exiting;
    }

    public static synchronized void addExitListener(IJob listener) {
        if (listener == null) {
            System.err.println("Attempt made to add a null exit listener.");
            throw new NullPointerException();
        }
        exitListeners.add(listener);
    }

    public static synchronized void removeExitListener(AbstractJob listener) {
        exitListeners.remove(listener);
    }

    public static void printHelp() {
        System.out.println(cmdhelp);
    }
}

