/*
 * Decompiled with CFR 0.152.
 */
package kenya.passes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kenya.errors.ExceptionMapperWrapper;
import kenya.errors.KenyaInternalError;
import kenya.errors.SourceCodeException;
import kenya.passes.RestrictedTypeChecker;
import kenya.passes.Util;
import kenya.types.KBasicType;
import kenya.types.KClassType;
import kenya.types.KType;
import kenya.types.KVariable;
import kenya.types.tables.ClassTable;
import kenya.types.tables.FunctionTable;
import kenya.types.tables.SymbolTable;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.AArrayDecInnerDeclaration;
import minijava.node.ABasicTypeType;
import minijava.node.AClassDecDeclaration;
import minijava.node.AClassInnerDeclaration;
import minijava.node.AClassTypeReferenceType;
import minijava.node.AConstDecDeclaration;
import minijava.node.AEnumDecDeclaration;
import minijava.node.AFuncDecDeclaration;
import minijava.node.AInitialiser;
import minijava.node.AReferenceTypeType;
import minijava.node.AVarDecInnerDeclaration;
import minijava.node.AVoidBasicType;
import minijava.node.PInnerDeclaration;
import minijava.node.PType;

public class DefinitionFinder
extends DepthFirstAdapter {
    private final ClassTable _ct;
    private final SymbolTable _st;
    private final FunctionTable _ft;
    private final List _errors;
    private final Set _errNodes;
    private final Map _typeMap;

    public DefinitionFinder(ClassTable ct, Set errNodes, Map typeMap) {
        this._ct = ct;
        this._st = new SymbolTable();
        this._ft = new FunctionTable();
        this._errors = new LinkedList();
        this._errNodes = errNodes;
        this._typeMap = typeMap;
    }

    public FunctionTable getFunctions() {
        return this._ft;
    }

    public SymbolTable getGlobalSymbolTable() {
        return new SymbolTable(this._st.collapse());
    }

    public ClassTable getClassTable() {
        return this._ct;
    }

    public Set getErrorNodes() {
        return this._errNodes;
    }

    public List getErrors() {
        return this._errors;
    }

    public void caseAFuncDecDeclaration(AFuncDecDeclaration node) {
        if (this._errNodes.contains(node)) {
            return;
        }
        try {
            this._ft.add(Util.makeFunction(node, this._ct), false);
        }
        catch (SourceCodeException e) {
            this._errors.add(e);
            this._errNodes.add(node);
        }
    }

    public void caseAConstDecDeclaration(AConstDecDeclaration node) {
        if (this._errNodes.contains(node)) {
            return;
        }
        try {
            PType type = node.getType();
            if (type instanceof ABasicTypeType) {
                List errors;
                KBasicType kt = Util.getBasicType((ABasicTypeType)type);
                if (kt.equals(KBasicType.getVoid())) {
                    int ln = ((AVoidBasicType)((ABasicTypeType)type).getBasicType()).getVoid().getLine();
                    int pos = ((AVoidBasicType)((ABasicTypeType)type).getBasicType()).getVoid().getPos();
                    int len = ((AVoidBasicType)((ABasicTypeType)type).getBasicType()).getVoid().getText().trim().length();
                    SourceCodeException.throwVoidConstant(ln, pos, len);
                }
                String ident = node.getIdentifier().getText().trim();
                KVariable kv = new KVariable(ident, kt, true, node);
                if (this._st.containsVariable(ident)) {
                    int ln = node.getIdentifier().getLine();
                    int pos = node.getIdentifier().getPos();
                    int len = node.getIdentifier().getText().trim().length();
                    KVariable kvClash = this._st.lookupVariable(ident);
                    int[][] lnkPos = new int[][]{Util.getFirstIdent(kvClash.getNode())};
                    SourceCodeException.throwDuplicateVariable(ln, pos, len, lnkPos, ident, "<global>");
                }
                if ((errors = RestrictedTypeChecker.apply(this._ct, this._st, new HashMap(), (KType)kt, this._errNodes, (AInitialiser)node.getInitialiser(), this._typeMap)).size() != 0) {
                    for (SourceCodeException sce : errors) {
                        this._errors.add(ExceptionMapperWrapper.wrapConstantException(sce));
                    }
                    this._errNodes.add(node);
                    return;
                }
                this._st.push(ident, kv);
                this._typeMap.put(node, kt);
            } else {
                AReferenceTypeType artt = (AReferenceTypeType)type;
                AClassTypeReferenceType actrt = (AClassTypeReferenceType)artt.getReferenceType();
                int ln = actrt.getIdentifier().getLine();
                int pos = actrt.getIdentifier().getPos();
                int len = actrt.getIdentifier().getText().trim().length();
                SourceCodeException.throwClassConstantError(ln, pos, len);
            }
        }
        catch (SourceCodeException sce) {
            this._errNodes.add(node);
            this._errors.add(ExceptionMapperWrapper.wrapConstantException(sce));
        }
    }

    public void caseAEnumDecDeclaration(AEnumDecDeclaration node) {
    }

    public void caseAClassDecDeclaration(AClassDecDeclaration node) {
        if (this._errNodes.contains(node)) {
            return;
        }
        try {
            KClassType kct = (KClassType)this._ct.getType(node.getIdentifier().getText().trim());
            LinkedList innerDecs = node.getClassInnerDeclaration();
            Iterator it = innerDecs.iterator();
            SymbolTable classST = new SymbolTable();
            while (it.hasNext()) {
                String ident;
                KType type;
                PInnerDeclaration pid;
                block14: {
                    pid = ((AClassInnerDeclaration)it.next()).getInnerDeclaration();
                    try {
                        int len;
                        int pos;
                        int ln;
                        if (pid instanceof AVarDecInnerDeclaration) {
                            List errors;
                            AVarDecInnerDeclaration avdid = (AVarDecInnerDeclaration)pid;
                            type = Util.getType(avdid.getType(), this._ct, kct.getTypeParams(), 0, "class " + node.getIdentifier().getText().trim());
                            ident = avdid.getIdentifier().getText().trim();
                            ln = avdid.getIdentifier().getLine();
                            pos = avdid.getIdentifier().getPos();
                            len = ident.length();
                            if (avdid.getInitialiser() != null && (errors = RestrictedTypeChecker.apply(this._ct, classST, kct.getTypeParams(), type, this._errNodes, (AInitialiser)avdid.getInitialiser(), this._typeMap)).size() != 0) {
                                this._errors.addAll(errors);
                                this._errNodes.add(node);
                                continue;
                            }
                        } else if (pid instanceof AArrayDecInnerDeclaration) {
                            AArrayDecInnerDeclaration aadid = (AArrayDecInnerDeclaration)pid;
                            int numBrackets = aadid.getBracketPair().size();
                            type = Util.getType(aadid.getType(), this._ct, kct.getTypeParams(), numBrackets, "class " + node.getIdentifier().getText().trim());
                            ident = aadid.getIdentifier().getText().trim();
                            ln = aadid.getIdentifier().getLine();
                            pos = aadid.getIdentifier().getPos();
                            len = ident.length();
                            List errors = null;
                            if (aadid.getArrayInitialiser() != null) {
                                errors = RestrictedTypeChecker.apply(this._ct, classST, kct.getTypeParams(), type, this._errNodes, aadid.getArrayInitialiser(), this._typeMap);
                            }
                            if (errors != null && errors.size() != 0) {
                                this._errors.addAll(errors);
                                this._errNodes.add(node);
                                continue;
                            }
                        } else {
                            throw new KenyaInternalError("Got an unknown node type!" + pid);
                        }
                        if (type == KBasicType.getVoid()) {
                            int[] vpos = Util.getFirstIdent(pid);
                            this._errNodes.add(node);
                            SourceCodeException.throwVariableDeclaration_Void(vpos[0], vpos[1], vpos[2]);
                        }
                        if (!classST.containsVariable(ident)) break block14;
                        KVariable conf = classST.lookupVariable(ident);
                        int[][] lnkPos = new int[][]{Util.getFirstIdent(conf.getNode())};
                        this._errNodes.add(node);
                        SourceCodeException.throwDuplicateVariable(ln, pos, len, lnkPos, ident, kct.toString());
                    }
                    catch (SourceCodeException sce) {
                        this._errNodes.add(node);
                        this._errors.add(sce);
                        continue;
                    }
                }
                KVariable kv = new KVariable(ident, type, false, pid);
                classST.push(ident, kv);
            }
            kct.setChildren(new SymbolTable(classST.collapse()));
        }
        catch (SourceCodeException sce) {
            throw new KenyaInternalError("Should not be possible to get here");
        }
    }
}

