/*
 * Decompiled with CFR 0.152.
 */
package kenya.passes;

import kenya.errors.KenyaPreconditionError;
import kenya.passes.StackMachineBuilder;
import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IVariable;
import kenya.types.tables.VariableLookupTable;
import mediator.stackMachine.IStackMachineInformationManager;
import mediator.util.InformationHolder;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.AArrayDecInnerDeclaration;
import minijava.node.AConstDecDeclaration;
import minijava.node.AVarDecInnerDeclaration;
import minijava.node.Node;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.ops.StackOpsFactory;
import org.wellquite.kenya.stackMachine.types.AbstractAtomicClosure;
import org.wellquite.kenya.stackMachine.types.ClassTypeFactory;
import org.wellquite.kenya.stackMachine.types.NullTypeFactory;
import org.wellquite.kenya.stackMachine.types.PrimitiveTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IBuildableClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;

class RestrictedStackMachineBuilder
extends DepthFirstAdapter {
    final IInterpretedClass _clazz;
    private final IBuildableClosure _initClosure;
    private final StackMachineBuilder _smb;
    private final InformationHolder _ih;
    private final IStackMachineInformationManager _isim;
    private final IClass _cIClass;

    private RestrictedStackMachineBuilder(IInterpretedClass clazz, IBuildableClosure initClosure, IStackMachineInformationManager isim, InformationHolder ih, IClass cIClass) {
        this._clazz = clazz;
        this._initClosure = initClosure;
        this._isim = isim;
        this._ih = ih;
        this._cIClass = cIClass;
        this._smb = new StackMachineBuilder(isim, ih, false, this._initClosure, cIClass);
    }

    static void doClassVariable(IInterpretedClass theClass, IBuildableClosure initClosure, Node node, IStackMachineInformationManager isim, InformationHolder ih, IClass cClass) {
        if (!(node instanceof AVarDecInnerDeclaration || node instanceof AConstDecDeclaration || node instanceof AArrayDecInnerDeclaration)) {
            throw new IllegalArgumentException("Node but be a variable, constant or array declaration: " + node);
        }
        RestrictedStackMachineBuilder rsmb = new RestrictedStackMachineBuilder(theClass, initClosure, isim, ih, cClass);
        node.apply(rsmb);
    }

    public void caseAVarDecInnerDeclaration(AVarDecInnerDeclaration node) {
        int i;
        block14: {
            String name = node.getIdentifier().getText().trim();
            for (i = 0; i < this._cIClass.getDeclarations().length; ++i) {
                if (!this._cIClass.getDeclarations()[i].getName().equals(name)) {
                    continue;
                }
                break block14;
            }
            throw KenyaPreconditionError.get();
        }
        IVariable decl = this._cIClass.getDeclarations()[i];
        final String smName = this._isim.lookupVariable(decl);
        VariableLookupTable vlt = new VariableLookupTable(this._cIClass.getDeclarations());
        vlt.push();
        this._smb.setVariableLookupTable(vlt);
        IClass type = decl.getType();
        if (node.getInitialiser() != null) {
            node.getInitialiser().apply(this._smb);
        } else if (type.getName().equals("boolean")) {
            this._initClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(false)));
        } else if (type.getName().equals("char")) {
            this._initClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType('\u0000')));
        } else if (type.getName().equals("int")) {
            this._initClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(0)));
        } else if (type.getName().equals("double")) {
            this._initClosure.addClosure(StackOpsFactory.push(PrimitiveTypeFactory.createPrimitiveType(0.0)));
        } else if (type.isClass() || type.isEnum() || type.isArray() || type.isParam() || type.getName().equals("String")) {
            this._initClosure.addClosure(StackOpsFactory.push(NullTypeFactory.createNullType()));
        } else {
            throw KenyaPreconditionError.get();
        }
        this._initClosure.addClosure(StackOpsFactory.storeNewVariable(smName, false));
        this._initClosure.addClosure(StackOpsFactory.fetch(smName));
        this._initClosure.addClosure(new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                RestrictedStackMachineBuilder.this._clazz.addMutableInstanceVariable(smName, sm.pop());
            }
        });
    }

    public void caseAArrayDecInnerDeclaration(AArrayDecInnerDeclaration node) {
        int i;
        block4: {
            String name = node.getIdentifier().getText().trim();
            for (i = 0; i < this._cIClass.getDeclarations().length; ++i) {
                if (!this._cIClass.getDeclarations()[i].getName().equals(name)) {
                    continue;
                }
                break block4;
            }
            throw KenyaPreconditionError.get();
        }
        IVariable decl = this._cIClass.getDeclarations()[i];
        final String smName = this._isim.lookupVariable(decl);
        VariableLookupTable vlt = new VariableLookupTable(this._cIClass.getDeclarations());
        vlt.push();
        this._smb.setVariableLookupTable(vlt);
        if (node.getArrayInitialiser() != null) {
            node.getArrayInitialiser().apply(this._smb);
        } else {
            this._initClosure.addClosure(StackOpsFactory.push(NullTypeFactory.createNullType()));
        }
        this._initClosure.addClosure(StackOpsFactory.storeNewVariable(smName, false));
        this._initClosure.addClosure(StackOpsFactory.fetch(smName));
        this._initClosure.addClosure(new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                RestrictedStackMachineBuilder.this._clazz.addMutableInstanceVariable(smName, sm.pop());
            }
        });
    }

    public void caseAConstDecDeclaration(AConstDecDeclaration node) {
        this.inAConstDecDeclaration(node);
        String name = node.getIdentifier().getText().trim();
        IVariable cons7 = this._ih.getConstantByName(name);
        String smName = this._isim.lookupVariable(cons7);
        this._initClosure.addClosure(StackOpsFactory.push(ClassTypeFactory.createClassStaticType(this._clazz)));
        VariableLookupTable vlt = new VariableLookupTable(this._ih.getConstants());
        vlt.push();
        this._smb.setVariableLookupTable(vlt);
        node.getInitialiser().apply(this._smb);
        this._initClosure.addClosure(StackOpsFactory.declareStaticImmutable(smName));
        this.outAConstDecDeclaration(node);
    }
}

