/*
 * Decompiled with CFR 0.152.
 */
package kenya.passes;

import java.util.List;
import java.util.Map;
import kenya.builtIns.IBuiltInMethod;
import kenya.errors.KenyaPreconditionError;
import kenya.passes.RestrictedTranslator;
import kenya.types.KBasicType;
import kenya.types.KBoundClassType;
import kenya.types.KClassType;
import kenya.types.KFunction;
import kenya.types.KType;
import mediator.IJavaCode;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.AAndBoolTerm;
import minijava.node.AArrayAllocate;
import minijava.node.AArrayDecInnerDeclaration;
import minijava.node.AArrayInit;
import minijava.node.AArrayInitList;
import minijava.node.AAssertStatement;
import minijava.node.AAssignment;
import minijava.node.AAssignmentStatement;
import minijava.node.ABlock;
import minijava.node.ABlockElseFollow;
import minijava.node.ACasePossibleCase;
import minijava.node.AClassDecDeclaration;
import minijava.node.AColonString;
import minijava.node.ACommaArrayInit;
import minijava.node.ACommaEnumList;
import minijava.node.ACommaExp;
import minijava.node.ACommaType;
import minijava.node.ACommaTypeName;
import minijava.node.AConstDecDeclaration;
import minijava.node.ADefaultPossibleCase;
import minijava.node.ADivTerm;
import minijava.node.ADynamicArrayInitialiser;
import minijava.node.AElsePart;
import minijava.node.AEnumDecDeclaration;
import minijava.node.AEnumList;
import minijava.node.AEqEquality;
import minijava.node.AExpActualParamList;
import minijava.node.AExpressionFactor;
import minijava.node.AForStatement;
import minijava.node.AFormalParamList;
import minijava.node.AFuncDecDeclaration;
import minijava.node.AFunctionApplication;
import minijava.node.AFunctioncallStatement;
import minijava.node.AGtRelational;
import minijava.node.AGteqRelational;
import minijava.node.AIfElseFollow;
import minijava.node.AIfStat;
import minijava.node.AIfStatement;
import minijava.node.AInitialiser;
import minijava.node.AInnerDecStatement;
import minijava.node.AJavaForControl;
import minijava.node.AListActualParamList;
import minijava.node.AListStatements;
import minijava.node.ALtRelational;
import minijava.node.ALteqRelational;
import minijava.node.AMinusMathExpression;
import minijava.node.AModTerm;
import minijava.node.AMultTerm;
import minijava.node.ANeqEquality;
import minijava.node.AOrBoolExpression;
import minijava.node.APlusMathExpression;
import minijava.node.AReturnStatement;
import minijava.node.AScalarInitList;
import minijava.node.AStaticArrayInitialiser;
import minijava.node.ASwitchBlock;
import minijava.node.ASwitchStatement;
import minijava.node.ATypeName;
import minijava.node.ATypeParam;
import minijava.node.ATypeParamList;
import minijava.node.AVarDecInnerDeclaration;
import minijava.node.AWhileStatement;
import minijava.node.AXorBoolExpression;
import minijava.node.Node;
import minijava.node.PArrayAccess;
import minijava.node.PClassInnerDeclaration;
import minijava.node.PCommaArrayInit;
import minijava.node.PCommaEnumList;
import minijava.node.PCommaExp;
import minijava.node.PCommaType;
import minijava.node.PCommaTypeName;
import minijava.node.PPossibleCase;
import minijava.node.TAnd;
import minijava.node.TAssert;
import minijava.node.TAssign;
import minijava.node.TBoolean;
import minijava.node.TBracketPair;
import minijava.node.TBreak;
import minijava.node.TCase;
import minijava.node.TChar;
import minijava.node.TCharliteral;
import minijava.node.TColon;
import minijava.node.TComma;
import minijava.node.TConst;
import minijava.node.TDefault;
import minijava.node.TDivide;
import minijava.node.TDot;
import minijava.node.TDouble;
import minijava.node.TDpnumber;
import minijava.node.TElse;
import minijava.node.TEnum;
import minijava.node.TEqual;
import minijava.node.TFalse;
import minijava.node.TFor;
import minijava.node.TGreater;
import minijava.node.TGreaterequal;
import minijava.node.TIdentifier;
import minijava.node.TIf;
import minijava.node.TInt;
import minijava.node.TIntnumber;
import minijava.node.TKlass;
import minijava.node.TLBrace;
import minijava.node.TLBracket;
import minijava.node.TLParenthese;
import minijava.node.TLess;
import minijava.node.TLessequal;
import minijava.node.TMinus;
import minijava.node.TMinusminus;
import minijava.node.TMod;
import minijava.node.TNew;
import minijava.node.TNot;
import minijava.node.TNotequal;
import minijava.node.TNull;
import minijava.node.TOr;
import minijava.node.TPlus;
import minijava.node.TPlusplus;
import minijava.node.TRBrace;
import minijava.node.TRBracket;
import minijava.node.TRParenthese;
import minijava.node.TReturn;
import minijava.node.TSemicolon;
import minijava.node.TString;
import minijava.node.TStringliteral;
import minijava.node.TSwitch;
import minijava.node.TTimes;
import minijava.node.TTrue;
import minijava.node.TVoid;
import minijava.node.TWhile;
import minijava.node.TXor;

public class Translator
extends DepthFirstAdapter {
    public static final String INDENT = "    ";
    private static final int MAX_WIDTH = 80;
    public static final int FUNCTIONS = 1;
    public static final int CLASSES = 2;
    public static final int ENUMS = 4;
    public static final int CONSTANTS = 8;
    private static final char DELIM = '\ubabe';
    private StringBuffer _code;
    private final Map _functionMap;
    private final Map _typeMap;
    private final Node _globalMain;
    private int _options;
    private int _indentLevel;
    private final boolean _doBreaking;
    private boolean _inTypeParams;
    private int _lastNlPos;
    private int _lastPos;
    private int _oldIndent;

    public Translator(Map functionMap, Node globalMain, Map typeMap, boolean doBreaking) {
        this._functionMap = functionMap;
        this._code = new StringBuffer();
        this._options = 0;
        this._indentLevel = 0;
        this._oldIndent = 0;
        this._globalMain = globalMain;
        this._lastPos = 0;
        this._lastNlPos = 0;
        this._doBreaking = doBreaking;
        this._inTypeParams = false;
        this._typeMap = typeMap;
    }

    public void reset(int newOptions) {
        this._code = new StringBuffer();
        this._options = newOptions;
        this._indentLevel = 0;
        this._oldIndent = 0;
        this._lastPos = 0;
        this._lastNlPos = 0;
    }

    public String getLastCode() {
        if (!this._doBreaking) {
            throw KenyaPreconditionError.get();
        }
        return this._code.toString();
    }

    public String[] getCodeArray() {
        if (this._doBreaking) {
            throw KenyaPreconditionError.get();
        }
        return this._code.toString().split("\ubabe");
    }

    private void doIndent() {
        for (int i = 0; i < this._indentLevel; ++i) {
            this._code.append(INDENT);
        }
    }

    private void doSpace() {
        this._code.append(" ");
        this.tokenOut();
    }

    private void doNewLine() {
        this._code.append(IJavaCode.NEWLINE);
        this._lastNlPos = this._code.length();
        this._lastPos = this._code.length();
    }

    public void tokenOut() {
        if (!this._doBreaking) {
            this._code.append('\ubabe');
            return;
        }
        int lnLen = this._code.length() - this._lastNlPos;
        int lastItemLen = this._code.length() - this._lastPos;
        if (lnLen > 80 && lastItemLen < 80) {
            String lastAdded = this._code.substring(this._lastPos);
            this._code = new StringBuffer(this._code.substring(0, this._lastPos));
            int tmp = this._indentLevel;
            this._indentLevel = this._oldIndent + 1;
            this.doNewLine();
            this.doIndent();
            this._indentLevel = tmp;
            this._code.append(lastAdded);
        }
        this._oldIndent = this._indentLevel;
        this._lastPos = this._code.length();
    }

    public void caseAClassDecDeclaration(AClassDecDeclaration node) {
        if ((this._options & 2) != 2) {
            return;
        }
        this.inAClassDecDeclaration(node);
        this._indentLevel = 0;
        this.doNewLine();
        this.doNewLine();
        node.getKlass().apply(this);
        this.doSpace();
        node.getIdentifier().apply(this);
        if (node.getTypeParam() != null) {
            node.getTypeParam().apply(this);
        }
        node.getLBrace().apply(this);
        this._indentLevel = 1;
        Object[] temp = node.getClassInnerDeclaration().toArray();
        for (int i = 0; i < temp.length; ++i) {
            this.doNewLine();
            this.doIndent();
            ((PClassInnerDeclaration)temp[i]).apply(this);
        }
        this.doNewLine();
        node.getRBrace().apply(this);
        this.outAClassDecDeclaration(node);
    }

    public void caseAEnumDecDeclaration(AEnumDecDeclaration node) {
        if ((this._options & 4) != 4) {
            return;
        }
        this.inAEnumDecDeclaration(node);
        this.doNewLine();
        node.getEnum().apply(this);
        this.doSpace();
        node.getIdentifier().apply(this);
        node.getLBrace().apply(this);
        this.doNewLine();
        this._indentLevel = 1;
        this.doIndent();
        if (node.getEnumList() != null) {
            node.getEnumList().apply(this);
        }
        node.getSemicolon().apply(this);
        this.doNewLine();
        node.getRBrace().apply(this);
        this.outAEnumDecDeclaration(node);
    }

    public void caseAFuncDecDeclaration(AFuncDecDeclaration node) {
        if ((this._options & 1) != 1) {
            return;
        }
        this.inAFuncDecDeclaration(node);
        this.doNewLine();
        this.doNewLine();
        this._indentLevel = 1;
        this.doIndent();
        if (this._globalMain == node) {
            this._code.append("public ");
        }
        this._code.append("static");
        if (node.getTypeParam() != null) {
            node.getTypeParam().apply(this);
        }
        this.doSpace();
        node.getType().apply(this);
        Object[] temp = node.getBracketPair().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((TBracketPair)temp[i]).apply(this);
        }
        this.doSpace();
        node.getIdentifier().apply(this);
        node.getLParenthese().apply(this);
        if (node.getFormalParamList() != null) {
            node.getFormalParamList().apply(this);
        }
        node.getRParenthese().apply(this);
        this.doSpace();
        node.getBlock().apply(this);
        this.outAFuncDecDeclaration(node);
    }

    public void caseAConstDecDeclaration(AConstDecDeclaration node) {
        if ((this._options & 8) != 8) {
            return;
        }
        this.inAConstDecDeclaration(node);
        this.doNewLine();
        this._indentLevel = 1;
        this.doIndent();
        node.getConst().apply(this);
        this.doSpace();
        node.getType().apply(this);
        this.doSpace();
        node.getIdentifier().apply(this);
        this.doSpace();
        node.getInitialiser().apply(this);
        node.getSemicolon().apply(this);
        this.outAConstDecDeclaration(node);
    }

    public void caseAListStatements(AListStatements node) {
        this.inAListStatements(node);
        this.doNewLine();
        this.doIndent();
        node.getStatement().apply(this);
        if (node.getStatements() != null) {
            node.getStatements().apply(this);
        }
        this.outAListStatements(node);
    }

    public void caseAFunctioncallStatement(AFunctioncallStatement node) {
        this.inAFunctioncallStatement(node);
        node.getFunctionApplication().apply(this);
        node.getSemicolon().apply(this);
        this.outAFunctioncallStatement(node);
    }

    public void caseAInnerDecStatement(AInnerDecStatement node) {
        this.inAInnerDecStatement(node);
        node.getInnerDeclaration().apply(this);
        node.getSemicolon().apply(this);
        this.outAInnerDecStatement(node);
    }

    public void caseAAssignmentStatement(AAssignmentStatement node) {
        this.inAAssignmentStatement(node);
        node.getAssignment().apply(this);
        node.getSemicolon().apply(this);
        this.outAAssignmentStatement(node);
    }

    public void caseAAssignment(AAssignment node) {
        this.inAAssignment(node);
        node.getFieldAccess().apply(this);
        this.doSpace();
        node.getAssign().apply(this);
        this.doSpace();
        node.getExpression().apply(this);
        this.outAAssignment(node);
    }

    public void caseAWhileStatement(AWhileStatement node) {
        this.inAWhileStatement(node);
        this.doNewLine();
        this.doIndent();
        node.getWhile().apply(this);
        this.doSpace();
        node.getLParenthese().apply(this);
        this.doSpace();
        node.getBoolExpression().apply(this);
        this.doSpace();
        node.getRParenthese().apply(this);
        this.doSpace();
        node.getBlock().apply(this);
        this.outAWhileStatement(node);
    }

    public void caseAReturnStatement(AReturnStatement node) {
        this.inAReturnStatement(node);
        node.getReturn().apply(this);
        if (node.getExpression() != null) {
            this.doSpace();
            node.getExpression().apply(this);
        }
        node.getSemicolon().apply(this);
        this.outAReturnStatement(node);
    }

    public void caseASwitchStatement(ASwitchStatement node) {
        this.inASwitchStatement(node);
        this.doNewLine();
        this.doIndent();
        node.getSwitch().apply(this);
        this.doSpace();
        node.getLParenthese().apply(this);
        this.doSpace();
        node.getBoolExpression().apply(this);
        this.doSpace();
        node.getRParenthese().apply(this);
        this.doSpace();
        node.getSwitchBlock().apply(this);
        this.outASwitchStatement(node);
    }

    public void caseASwitchBlock(ASwitchBlock node) {
        this.inASwitchBlock(node);
        ++this._indentLevel;
        node.getLBrace().apply(this);
        Object[] temp = node.getPossibleCase().toArray();
        for (int i = 0; i < temp.length; ++i) {
            this.doNewLine();
            this.doIndent();
            ((PPossibleCase)temp[i]).apply(this);
        }
        --this._indentLevel;
        this.doNewLine();
        this.doIndent();
        node.getRBrace().apply(this);
        this.outASwitchBlock(node);
    }

    public void caseACasePossibleCase(ACasePossibleCase node) {
        this.inACasePossibleCase(node);
        node.getCase().apply(this);
        this.doSpace();
        node.getBoolExpression().apply(this);
        node.getColon().apply(this);
        node.getBlock().apply(this);
        this.outACasePossibleCase(node);
    }

    public void caseADefaultPossibleCase(ADefaultPossibleCase node) {
        this.inADefaultPossibleCase(node);
        node.getDefault().apply(this);
        node.getColon().apply(this);
        node.getBlock().apply(this);
        this.outADefaultPossibleCase(node);
    }

    public void caseAForStatement(AForStatement node) {
        this.inAForStatement(node);
        this.doNewLine();
        this.doIndent();
        node.getFor().apply(this);
        this.doSpace();
        node.getForControl().apply(this);
        this.doSpace();
        node.getBlock().apply(this);
        this.outAForStatement(node);
    }

    public void caseAAssertStatement(AAssertStatement node) {
        this.inAAssertStatement(node);
        node.getAssert().apply(this);
        this.doSpace();
        node.getBoolExpression().apply(this);
        if (node.getColonString() != null) {
            node.getColonString().apply(this);
        }
        if (node.getSemicolon() != null) {
            node.getSemicolon().apply(this);
        }
        this.outAAssertStatement(node);
    }

    public void caseAColonString(AColonString node) {
        this.inAColonString(node);
        this.doSpace();
        node.getColon().apply(this);
        this.doSpace();
        node.getExpression().apply(this);
        this.outAColonString(node);
    }

    public void caseAIfStatement(AIfStatement node) {
        this.inAIfStatement(node);
        this.doNewLine();
        this.doIndent();
        node.getIfStat().apply(this);
        this.outAIfStatement(node);
    }

    public void caseAIfStat(AIfStat node) {
        this.inAIfStat(node);
        node.getIf().apply(this);
        this.doSpace();
        node.getLParenthese().apply(this);
        this.doSpace();
        node.getBoolExpression().apply(this);
        this.doSpace();
        node.getRParenthese().apply(this);
        this.doSpace();
        node.getBlock1().apply(this);
        if (node.getElsePart() != null) {
            node.getElsePart().apply(this);
        }
        this.outAIfStat(node);
    }

    public void caseAElsePart(AElsePart node) {
        this.inAElsePart(node);
        this.doSpace();
        node.getElse().apply(this);
        this.doSpace();
        node.getElseFollow().apply(this);
        this.outAElsePart(node);
    }

    public void caseABlockElseFollow(ABlockElseFollow node) {
        this.inABlockElseFollow(node);
        if (node.getBlock() != null) {
            node.getBlock().apply(this);
        }
        this.outABlockElseFollow(node);
    }

    public void caseAIfElseFollow(AIfElseFollow node) {
        this.inAIfElseFollow(node);
        node.getIfStat().apply(this);
        this.outAIfElseFollow(node);
    }

    public void caseAJavaForControl(AJavaForControl node) {
        this.inAJavaForControl(node);
        node.getLParenthese().apply(this);
        node.getForLeftStat().apply(this);
        this.doSpace();
        node.getS1().apply(this);
        this.doSpace();
        node.getBoolExpression().apply(this);
        this.doSpace();
        node.getS2().apply(this);
        this.doSpace();
        if (node.getForRightStat() != null) {
            node.getForRightStat().apply(this);
        }
        this.doSpace();
        node.getRParenthese().apply(this);
        this.outAJavaForControl(node);
    }

    public void caseABlock(ABlock node) {
        this.inABlock(node);
        node.getLBrace().apply(this);
        ++this._indentLevel;
        if (node.getStatements() != null) {
            node.getStatements().apply(this);
        }
        this.doNewLine();
        --this._indentLevel;
        this.doIndent();
        node.getRBrace().apply(this);
        this.outABlock(node);
    }

    public void caseAFunctionApplication(AFunctionApplication node) {
        this.inAFunctionApplication(node);
        KFunction kf = (KFunction)this._functionMap.get(node);
        if (kf.isBuiltin()) {
            List args = RestrictedTranslator.getParams(node.getActualParamList(), this._functionMap, this._typeMap, node);
            IBuiltInMethod ibm = kf.getBuiltinMethod();
            String[] codeToAppend = ibm.getCode(args);
            for (int i = 0; i < codeToAppend.length; ++i) {
                this._code.append(codeToAppend[i]);
                this.tokenOut();
            }
        } else {
            node.getName().apply(this);
            node.getLParenthese().apply(this);
            if (node.getActualParamList() != null) {
                this.doSpace();
                node.getActualParamList().apply(this);
                this.doSpace();
            }
            node.getRParenthese().apply(this);
        }
        this.outAFunctionApplication(node);
    }

    public void caseAListActualParamList(AListActualParamList node) {
        this.inAListActualParamList(node);
        node.getActualParamList().apply(this);
        node.getComma().apply(this);
        this.doSpace();
        node.getExpression().apply(this);
        this.outAListActualParamList(node);
    }

    public void caseAExpActualParamList(AExpActualParamList node) {
        this.inAExpActualParamList(node);
        node.getExpression().apply(this);
        this.outAExpActualParamList(node);
    }

    public void caseAVarDecInnerDeclaration(AVarDecInnerDeclaration node) {
        this.inAVarDecInnerDeclaration(node);
        node.getType().apply(this);
        this.doSpace();
        node.getIdentifier().apply(this);
        if (node.getInitialiser() != null) {
            this.doSpace();
            node.getInitialiser().apply(this);
        } else {
            KType ct = (KType)this._typeMap.get(node);
            if (ct instanceof KBoundClassType) {
                this.doSpace();
                this.caseTAssign(null);
                this.doSpace();
                this.caseTNew(null);
                this.doSpace();
                this._code.append(ct.getName());
                this.caseTLParenthese(null);
                KClassType underlying = ((KBoundClassType)ct).getBase();
                if (underlying == KClassType.getCharacter()) {
                    this.doSpace();
                    this._code.append("'\\0'");
                    this.doSpace();
                } else if (underlying == KClassType.getInteger()) {
                    this.doSpace();
                    this._code.append("0");
                    this.doSpace();
                } else if (underlying == KClassType.getDouble()) {
                    this.doSpace();
                    this._code.append("0.0");
                    this.doSpace();
                } else if (underlying == KClassType.getBoolean()) {
                    this.doSpace();
                    this._code.append("false");
                    this.doSpace();
                }
                this.caseTRParenthese(null);
            }
        }
        this.outAVarDecInnerDeclaration(node);
    }

    public void caseAArrayDecInnerDeclaration(AArrayDecInnerDeclaration node) {
        this.inAArrayDecInnerDeclaration(node);
        node.getType().apply(this);
        Object[] temp = node.getBracketPair().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((TBracketPair)temp[i]).apply(this);
        }
        this.doSpace();
        node.getIdentifier().apply(this);
        if (node.getArrayInitialiser() != null) {
            this.doSpace();
            node.getArrayInitialiser().apply(this);
        }
        this.outAArrayDecInnerDeclaration(node);
    }

    public void caseAFormalParamList(AFormalParamList node) {
        this.inAFormalParamList(node);
        node.getTypeName().apply(this);
        Object[] temp = node.getCommaTypeName().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PCommaTypeName)temp[i]).apply(this);
        }
        this.outAFormalParamList(node);
    }

    public void caseATypeName(ATypeName node) {
        this.inATypeName(node);
        node.getType().apply(this);
        Object[] temp = node.getBracketPair().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((TBracketPair)temp[i]).apply(this);
        }
        this.doSpace();
        node.getIdentifier().apply(this);
        this.outATypeName(node);
    }

    public void caseATypeParam(ATypeParam node) {
        this.inATypeParam(node);
        boolean tmp = this._inTypeParams;
        this._inTypeParams = true;
        node.getLess().apply(this);
        node.getTypeParamList().apply(this);
        node.getGreater().apply(this);
        this._inTypeParams = tmp;
        this.outATypeParam(node);
    }

    public void caseACommaTypeName(ACommaTypeName node) {
        this.inACommaTypeName(node);
        node.getComma().apply(this);
        this.doSpace();
        node.getTypeName().apply(this);
        this.outACommaTypeName(node);
    }

    public void caseAEnumList(AEnumList node) {
        this.inAEnumList(node);
        node.getIdentifier().apply(this);
        Object[] temp = node.getCommaEnumList().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PCommaEnumList)temp[i]).apply(this);
        }
        this.outAEnumList(node);
    }

    public void caseACommaEnumList(ACommaEnumList node) {
        this.inACommaEnumList(node);
        node.getComma().apply(this);
        this.doSpace();
        node.getIdentifier().apply(this);
        this.outACommaEnumList(node);
    }

    public void caseAInitialiser(AInitialiser node) {
        this.inAInitialiser(node);
        node.getAssign().apply(this);
        this.doSpace();
        node.getBoolExpression().apply(this);
        this.outAInitialiser(node);
    }

    public void caseAStaticArrayInitialiser(AStaticArrayInitialiser node) {
        this.inAStaticArrayInitialiser(node);
        node.getAssign().apply(this);
        this.doSpace();
        node.getArrayInit().apply(this);
        this.outAStaticArrayInitialiser(node);
    }

    public void caseADynamicArrayInitialiser(ADynamicArrayInitialiser node) {
        this.inADynamicArrayInitialiser(node);
        node.getAssign().apply(this);
        this.doSpace();
        node.getArrayAllocate().apply(this);
        this.outADynamicArrayInitialiser(node);
    }

    public void caseAArrayInit(AArrayInit node) {
        this.inAArrayInit(node);
        node.getLBrace().apply(this);
        this.doSpace();
        node.getInitList().apply(this);
        this.doSpace();
        node.getRBrace().apply(this);
        this.outAArrayInit(node);
    }

    public void caseAScalarInitList(AScalarInitList node) {
        this.inAScalarInitList(node);
        node.getExpression().apply(this);
        Object[] temp = node.getCommaExp().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PCommaExp)temp[i]).apply(this);
        }
        this.outAScalarInitList(node);
    }

    public void caseACommaExp(ACommaExp node) {
        this.inACommaExp(node);
        node.getComma().apply(this);
        this.doSpace();
        node.getExpression().apply(this);
        this.outACommaExp(node);
    }

    public void caseAArrayInitList(AArrayInitList node) {
        this.inAArrayInitList(node);
        node.getArrayInit().apply(this);
        Object[] temp = node.getCommaArrayInit().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PCommaArrayInit)temp[i]).apply(this);
        }
        this.outAArrayInitList(node);
    }

    public void caseACommaArrayInit(ACommaArrayInit node) {
        this.inACommaArrayInit(node);
        node.getComma().apply(this);
        this.doSpace();
        node.getArrayInit().apply(this);
        this.outACommaArrayInit(node);
    }

    public void caseACommaType(ACommaType node) {
        this.inACommaType(node);
        node.getComma().apply(this);
        this.doSpace();
        node.getType().apply(this);
        Object[] temp = node.getBracketPair().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((TBracketPair)temp[i]).apply(this);
        }
        this.outACommaType(node);
    }

    public void caseAArrayAllocate(AArrayAllocate node) {
        int i;
        this.inAArrayAllocate(node);
        node.getNew().apply(this);
        this.doSpace();
        node.getType().apply(this);
        Object[] temp = node.getArrayAccess().toArray();
        for (i = 0; i < temp.length; ++i) {
            ((PArrayAccess)temp[i]).apply(this);
        }
        temp = node.getBracketPair().toArray();
        for (i = 0; i < temp.length; ++i) {
            ((TBracketPair)temp[i]).apply(this);
        }
        this.outAArrayAllocate(node);
    }

    public void caseAPlusMathExpression(APlusMathExpression node) {
        this.inAPlusMathExpression(node);
        node.getMathExpression().apply(this);
        this.doSpace();
        node.getPlus().apply(this);
        this.doSpace();
        node.getTerm().apply(this);
        this.outAPlusMathExpression(node);
    }

    public void caseAMinusMathExpression(AMinusMathExpression node) {
        this.inAMinusMathExpression(node);
        node.getMathExpression().apply(this);
        this.doSpace();
        node.getMinus().apply(this);
        this.doSpace();
        node.getTerm().apply(this);
        this.outAMinusMathExpression(node);
    }

    public void caseAMultTerm(AMultTerm node) {
        this.inAMultTerm(node);
        node.getTerm().apply(this);
        this.doSpace();
        node.getTimes().apply(this);
        this.doSpace();
        node.getUnaryExp().apply(this);
        this.outAMultTerm(node);
    }

    public void caseADivTerm(ADivTerm node) {
        this.inADivTerm(node);
        node.getTerm().apply(this);
        this.doSpace();
        node.getDivide().apply(this);
        this.doSpace();
        node.getUnaryExp().apply(this);
        this.outADivTerm(node);
    }

    public void caseAModTerm(AModTerm node) {
        this.inAModTerm(node);
        node.getTerm().apply(this);
        this.doSpace();
        node.getMod().apply(this);
        this.doSpace();
        node.getUnaryExp().apply(this);
        this.outAModTerm(node);
    }

    public void caseAExpressionFactor(AExpressionFactor node) {
        this.inAExpressionFactor(node);
        node.getLParenthese().apply(this);
        this.doSpace();
        node.getBoolExpression().apply(this);
        this.doSpace();
        node.getRParenthese().apply(this);
        this.outAExpressionFactor(node);
    }

    public void caseAOrBoolExpression(AOrBoolExpression node) {
        this.inAOrBoolExpression(node);
        node.getBoolExpression().apply(this);
        this.doSpace();
        node.getOr().apply(this);
        this.doSpace();
        node.getBoolTerm().apply(this);
        this.outAOrBoolExpression(node);
    }

    public void caseAXorBoolExpression(AXorBoolExpression node) {
        this.inAXorBoolExpression(node);
        node.getBoolExpression().apply(this);
        this.doSpace();
        node.getXor().apply(this);
        this.doSpace();
        node.getBoolTerm().apply(this);
        this.outAXorBoolExpression(node);
    }

    public void caseAAndBoolTerm(AAndBoolTerm node) {
        this.inAAndBoolTerm(node);
        node.getBoolTerm().apply(this);
        this.doSpace();
        node.getAnd().apply(this);
        this.doSpace();
        node.getEquality().apply(this);
        this.outAAndBoolTerm(node);
    }

    public void caseAEqEquality(AEqEquality node) {
        this.inAEqEquality(node);
        if (this._typeMap.get(node) == KBasicType.getString()) {
            this.caseTLParenthese(null);
            this.doSpace();
            node.getEquality().apply(this);
            this.doSpace();
            this.caseTRParenthese(null);
            this.caseTDot(null);
            this._code.append("equals");
            this.tokenOut();
            this.caseTLParenthese(null);
            this.doSpace();
            node.getRelational().apply(this);
            this.doSpace();
            this.caseTRParenthese(null);
        } else {
            node.getEquality().apply(this);
            this.doSpace();
            node.getEqual().apply(this);
            this.doSpace();
            node.getRelational().apply(this);
        }
        this.outAEqEquality(node);
    }

    public void caseANeqEquality(ANeqEquality node) {
        this.inANeqEquality(node);
        if (this._typeMap.get(node) == KBasicType.getString()) {
            this.caseTNot(null);
            this.caseTLParenthese(null);
            this.doSpace();
            node.getEquality().apply(this);
            this.doSpace();
            this.caseTRParenthese(null);
            this.caseTDot(null);
            this._code.append("equals");
            this.tokenOut();
            this.caseTLParenthese(null);
            this.doSpace();
            node.getRelational().apply(this);
            this.doSpace();
            this.caseTRParenthese(null);
        } else {
            node.getEquality().apply(this);
            this.doSpace();
            node.getNotequal().apply(this);
            this.doSpace();
            node.getRelational().apply(this);
            this.outANeqEquality(node);
        }
    }

    public void caseALtRelational(ALtRelational node) {
        this.inALtRelational(node);
        node.getRelational().apply(this);
        this.doSpace();
        node.getLess().apply(this);
        this.doSpace();
        node.getMathExpression().apply(this);
        this.outALtRelational(node);
    }

    public void caseAGtRelational(AGtRelational node) {
        this.inAGtRelational(node);
        node.getRelational().apply(this);
        this.doSpace();
        node.getGreater().apply(this);
        this.doSpace();
        node.getMathExpression().apply(this);
        this.outAGtRelational(node);
    }

    public void caseALteqRelational(ALteqRelational node) {
        this.inALteqRelational(node);
        node.getRelational().apply(this);
        this.doSpace();
        node.getLessequal().apply(this);
        this.doSpace();
        node.getMathExpression().apply(this);
        this.outALteqRelational(node);
    }

    public void caseAGteqRelational(AGteqRelational node) {
        this.inAGteqRelational(node);
        node.getRelational().apply(this);
        this.doSpace();
        node.getGreaterequal().apply(this);
        this.doSpace();
        node.getMathExpression().apply(this);
        this.outAGteqRelational(node);
    }

    public void caseATypeParamList(ATypeParamList node) {
        int i;
        this.inATypeParamList(node);
        boolean iTP = this._inTypeParams;
        if (node.getBracketPair().size() != 0) {
            this._inTypeParams = false;
        }
        node.getType().apply(this);
        this._inTypeParams = iTP;
        Object[] temp = node.getBracketPair().toArray();
        for (i = 0; i < temp.length; ++i) {
            ((TBracketPair)temp[i]).apply(this);
        }
        temp = node.getCommaType().toArray();
        for (i = 0; i < temp.length; ++i) {
            ((PCommaType)temp[i]).apply(this);
        }
        this.outATypeParamList(node);
    }

    public void caseTBoolean(TBoolean node) {
        this.defaultIn(node);
        if (this._inTypeParams) {
            this._code.append("Boolean");
        } else {
            this._code.append("boolean");
        }
        this.tokenOut();
    }

    public void caseTChar(TChar node) {
        this.defaultIn(node);
        if (this._inTypeParams) {
            this._code.append("Character");
        } else {
            this._code.append("char");
        }
        this.tokenOut();
    }

    public void caseTInt(TInt node) {
        this.defaultIn(node);
        if (this._inTypeParams) {
            this._code.append("Integer");
        } else {
            this._code.append("int");
        }
        this.tokenOut();
    }

    public void caseTDouble(TDouble node) {
        this.defaultIn(node);
        if (this._inTypeParams) {
            this._code.append("Double");
        } else {
            this._code.append("double");
        }
        this.tokenOut();
    }

    public void caseTString(TString node) {
        this.defaultIn(node);
        this._code.append("String");
        this.tokenOut();
    }

    public void caseTVoid(TVoid node) {
        this.defaultIn(node);
        this._code.append("void");
        this.tokenOut();
    }

    public void caseTKlass(TKlass node) {
        this.defaultIn(node);
        this._code.append("class");
        this.tokenOut();
    }

    public void caseTConst(TConst node) {
        this.defaultIn(node);
        this._code.append("static final");
        this.tokenOut();
    }

    public void caseTIf(TIf node) {
        this.defaultIn(node);
        this._code.append("if");
        this.tokenOut();
    }

    public void caseTElse(TElse node) {
        this.defaultIn(node);
        this._code.append("else");
        this.tokenOut();
    }

    public void caseTWhile(TWhile node) {
        this.defaultIn(node);
        this._code.append("while");
        this.tokenOut();
    }

    public void caseTReturn(TReturn node) {
        this.defaultIn(node);
        this._code.append("return");
        this.tokenOut();
    }

    public void caseTSwitch(TSwitch node) {
        this.defaultIn(node);
        this._code.append("switch");
        this.tokenOut();
    }

    public void caseTCase(TCase node) {
        this.defaultIn(node);
        this._code.append("case");
        this.tokenOut();
    }

    public void caseTBreak(TBreak node) {
        this.defaultIn(node);
        this._code.append("break");
        this.tokenOut();
    }

    public void caseTDefault(TDefault node) {
        this.defaultIn(node);
        this._code.append("default");
        this.tokenOut();
    }

    public void caseTFor(TFor node) {
        this.defaultIn(node);
        this._code.append("for");
        this.tokenOut();
    }

    public void caseTAssert(TAssert node) {
        this.defaultIn(node);
        this._code.append("assert");
        this.tokenOut();
    }

    public void caseTNew(TNew node) {
        this.defaultIn(node);
        this._code.append("new");
        this.tokenOut();
    }

    public void caseTEnum(TEnum node) {
        this.defaultIn(node);
        this._code.append("enum");
        this.tokenOut();
    }

    public void caseTTrue(TTrue node) {
        this.defaultIn(node);
        this._code.append("true");
        this.tokenOut();
    }

    public void caseTFalse(TFalse node) {
        this.defaultIn(node);
        this._code.append("false");
        this.tokenOut();
    }

    public void caseTNull(TNull node) {
        this.defaultIn(node);
        this._code.append("null");
        this.tokenOut();
    }

    public void caseTAnd(TAnd node) {
        this.defaultIn(node);
        this._code.append("&&");
        this.tokenOut();
    }

    public void caseTOr(TOr node) {
        this.defaultIn(node);
        this._code.append("||");
        this.tokenOut();
    }

    public void caseTXor(TXor node) {
        this.defaultIn(node);
        this._code.append("^");
        this.tokenOut();
    }

    public void caseTNot(TNot node) {
        this.defaultIn(node);
        this._code.append("!");
        this.tokenOut();
    }

    public void caseTIdentifier(TIdentifier node) {
        this.defaultIn(node);
        this._code.append(node.getText().trim());
        this.tokenOut();
    }

    public void caseTStringliteral(TStringliteral node) {
        this.defaultIn(node);
        this._code.append(node.getText().trim());
        this.tokenOut();
    }

    public void caseTCharliteral(TCharliteral node) {
        this.defaultIn(node);
        this._code.append(node.getText().trim());
        this.tokenOut();
    }

    public void caseTLParenthese(TLParenthese node) {
        this.defaultIn(node);
        this._code.append("(");
        this.tokenOut();
    }

    public void caseTRParenthese(TRParenthese node) {
        this.defaultIn(node);
        this._code.append(")");
        this.tokenOut();
    }

    public void caseTLBrace(TLBrace node) {
        this.defaultIn(node);
        this._code.append("{");
        this.tokenOut();
    }

    public void caseTRBrace(TRBrace node) {
        this.defaultIn(node);
        this._code.append("}");
        this.tokenOut();
    }

    public void caseTLBracket(TLBracket node) {
        this.defaultIn(node);
        this._code.append("[");
        this.tokenOut();
    }

    public void caseTRBracket(TRBracket node) {
        this.defaultIn(node);
        this._code.append("]");
        this.tokenOut();
    }

    public void caseTBracketPair(TBracketPair node) {
        this.defaultIn(node);
        this._code.append("[]");
        this.tokenOut();
    }

    public void caseTSemicolon(TSemicolon node) {
        this.defaultIn(node);
        this._code.append(";");
        this.tokenOut();
    }

    public void caseTColon(TColon node) {
        this.defaultIn(node);
        this._code.append(":");
        this.tokenOut();
    }

    public void caseTComma(TComma node) {
        this.defaultIn(node);
        this._code.append(",");
        this.tokenOut();
    }

    public void caseTDot(TDot node) {
        this.defaultIn(node);
        this._code.append(".");
        this.tokenOut();
    }

    public void caseTPlus(TPlus node) {
        this.defaultIn(node);
        this._code.append("+");
        this.tokenOut();
    }

    public void caseTPlusplus(TPlusplus node) {
        this.defaultIn(node);
        this._code.append("++");
        this.tokenOut();
    }

    public void caseTMinus(TMinus node) {
        this.defaultIn(node);
        this._code.append("-");
        this.tokenOut();
    }

    public void caseTMinusminus(TMinusminus node) {
        this.defaultIn(node);
        this._code.append("--");
        this.tokenOut();
    }

    public void caseTTimes(TTimes node) {
        this.defaultIn(node);
        this._code.append("*");
        this.tokenOut();
    }

    public void caseTDivide(TDivide node) {
        this._code.append("/");
        this.tokenOut();
    }

    public void caseTMod(TMod node) {
        this._code.append("%");
        this.tokenOut();
    }

    public void caseTLess(TLess node) {
        this._code.append("<");
        this.tokenOut();
    }

    public void caseTLessequal(TLessequal node) {
        this._code.append("<=");
        this.tokenOut();
    }

    public void caseTGreater(TGreater node) {
        this._code.append(">");
        this.tokenOut();
    }

    public void caseTGreaterequal(TGreaterequal node) {
        this._code.append(">=");
        this.tokenOut();
    }

    public void caseTEqual(TEqual node) {
        this._code.append("==");
        this.tokenOut();
    }

    public void caseTNotequal(TNotequal node) {
        this._code.append("!=");
        this.tokenOut();
    }

    public void caseTAssign(TAssign node) {
        this._code.append("=");
        this.tokenOut();
    }

    public void caseTIntnumber(TIntnumber node) {
        this._code.append(node.getText().trim());
        this.tokenOut();
    }

    public void caseTDpnumber(TDpnumber node) {
        this._code.append(node.getText().trim());
        this.tokenOut();
    }
}

