/*
 * Decompiled with CFR 0.152.
 */
package kenya.passes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kenya.errors.KenyaBadLocationError;
import kenya.errors.KenyaInternalError;
import kenya.errors.KenyaPreconditionError;
import kenya.errors.SourceCodeException;
import kenya.passes.Util;
import kenya.types.KArrayType;
import kenya.types.KBasicType;
import kenya.types.KBoundClassType;
import kenya.types.KClassType;
import kenya.types.KEnumType;
import kenya.types.KFunction;
import kenya.types.KNullType;
import kenya.types.KParamType;
import kenya.types.KType;
import kenya.types.KVariable;
import kenya.types.tables.ClassTable;
import kenya.types.tables.FunctionTable;
import kenya.types.tables.SymbolTable;
import kenya.types.tables.util.PairKFunctionReturnType;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.AAndBoolTerm;
import minijava.node.AArrayAccess;
import minijava.node.AArrayAllocate;
import minijava.node.AArrayDecInnerDeclaration;
import minijava.node.AArrayFieldAccess;
import minijava.node.AArrayInit;
import minijava.node.AArrayInitList;
import minijava.node.AAssertStatement;
import minijava.node.AAssignment;
import minijava.node.AAssignmentForLeftStat;
import minijava.node.AAssignmentForRightStat;
import minijava.node.AAssignmentStatement;
import minijava.node.ABlock;
import minijava.node.ABooleanBasicType;
import minijava.node.ABoolliteralFactor;
import minijava.node.ACasePossibleCase;
import minijava.node.ACharBasicType;
import minijava.node.ACharliteralFactor;
import minijava.node.AClassDecDeclaration;
import minijava.node.AClassTypeReferenceType;
import minijava.node.AColonString;
import minijava.node.ACommaArrayInit;
import minijava.node.ACommaEnumList;
import minijava.node.ACommaExp;
import minijava.node.ACommaType;
import minijava.node.ACommaTypeName;
import minijava.node.AConstDecDeclaration;
import minijava.node.ADNumber;
import minijava.node.ADefaultPossibleCase;
import minijava.node.ADivTerm;
import minijava.node.ADoubleBasicType;
import minijava.node.ADynamicArrayInitialiser;
import minijava.node.AEnumDecDeclaration;
import minijava.node.AEnumList;
import minijava.node.AEqEquality;
import minijava.node.AExpActualParamList;
import minijava.node.AFalseBooleanliteral;
import minijava.node.AForStatement;
import minijava.node.AFormalParamList;
import minijava.node.AFuncDecDeclaration;
import minijava.node.AFunctionApplication;
import minijava.node.AFunctioncallForRightStat;
import minijava.node.AFunctioncallStatement;
import minijava.node.AGtRelational;
import minijava.node.AGteqRelational;
import minijava.node.AINumber;
import minijava.node.AIfStat;
import minijava.node.AInitialiser;
import minijava.node.AIntBasicType;
import minijava.node.AJavaForControl;
import minijava.node.AListActualParamList;
import minijava.node.AListStatements;
import minijava.node.ALtRelational;
import minijava.node.ALteqRelational;
import minijava.node.AMinusMathExpression;
import minijava.node.AMinusUnaryExp;
import minijava.node.AModTerm;
import minijava.node.AMultTerm;
import minijava.node.ANegateUnaryExp;
import minijava.node.ANeqEquality;
import minijava.node.ANullFactor;
import minijava.node.AOrBoolExpression;
import minijava.node.APlusMathExpression;
import minijava.node.APlusUnaryExp;
import minijava.node.APostdecr;
import minijava.node.APostincr;
import minijava.node.APredecr;
import minijava.node.APreincr;
import minijava.node.AQualifiedName;
import minijava.node.AReturnStatement;
import minijava.node.AScalarInitList;
import minijava.node.ASimpleName;
import minijava.node.ASimpleNameName;
import minijava.node.AStaticArrayInitialiser;
import minijava.node.AStringBasicType;
import minijava.node.AStringliteralFactor;
import minijava.node.ASwitchBlock;
import minijava.node.ASwitchStatement;
import minijava.node.ATrueBooleanliteral;
import minijava.node.ATypeName;
import minijava.node.ATypeParam;
import minijava.node.ATypeParamList;
import minijava.node.AVarDecInnerDeclaration;
import minijava.node.AVoidBasicType;
import minijava.node.AWhileStatement;
import minijava.node.AXorBoolExpression;
import minijava.node.PArrayAccess;
import minijava.node.PCommaArrayInit;
import minijava.node.PCommaExp;
import minijava.node.PName;
import minijava.node.PPossibleCase;

public class TypeChecker
extends DepthFirstAdapter {
    private ClassTable _classTable;
    private FunctionTable _funcTable;
    private SymbolTable _symTab;
    private Map _paramMap;
    private Stack _typeStack;
    private KType _retVal;
    private KType _switchType;
    private KType _arrType;
    private List _errors;
    private Set _errNodes;
    private List _warnings;
    private String _cScope;
    private KType _typeContext;
    private Map _typeMap;
    private Map _funcMap;
    private Set _arrayLengthRef;
    private Set _enumChildSet;

    public TypeChecker(ClassTable ct, SymbolTable symTab, FunctionTable ft, Set errNodes, Map typeMap) {
        this._classTable = ct;
        this._funcTable = ft;
        this._symTab = symTab;
        this._paramMap = new HashMap();
        this._typeStack = new Stack();
        this._errors = new LinkedList();
        this._warnings = new LinkedList();
        this._errNodes = errNodes;
        this._typeContext = null;
        this._cScope = "<global>";
        this._typeMap = typeMap;
        this._funcMap = new HashMap();
        this._arrayLengthRef = new HashSet();
        this._enumChildSet = new HashSet();
    }

    TypeChecker(ClassTable ct, SymbolTable st, Map paramMap, Set errNodes, Map typeMap, KType retType) {
        this._classTable = ct;
        this._funcTable = new FunctionTable();
        this._symTab = st;
        this._paramMap = paramMap;
        this._typeStack = new Stack();
        this._errors = new LinkedList();
        this._warnings = new LinkedList();
        this._errNodes = errNodes;
        this._typeContext = retType;
        this._cScope = "<global>";
        this._typeMap = typeMap;
        this._funcMap = new HashMap();
        this._arrayLengthRef = new HashSet();
        this._enumChildSet = new HashSet();
        this._arrType = retType;
    }

    public List getErrors() {
        return this._errors;
    }

    public List getWarnings() {
        return this._warnings;
    }

    public Set getArrayLengthRefs() {
        return this._arrayLengthRef;
    }

    public Set getEnumChildSet() {
        return this._enumChildSet;
    }

    public Map getTypeMap() {
        return this._typeMap;
    }

    public Set getErrorNodes() {
        return this._errNodes;
    }

    public Map getFuncMap() {
        return this._funcMap;
    }

    public Set getErrorStatements() {
        return this._errNodes;
    }

    public KType getTopOfTypeStack() {
        return (KType)this._typeStack.pop();
    }

    void setWantChar() {
        this._typeContext = KBasicType.getChar();
    }

    public void caseAListStatements(AListStatements node) {
        this.inAListStatements(node);
        try {
            if (!this._errNodes.contains(node.getStatement())) {
                node.getStatement().apply(this);
            }
        }
        catch (SourceCodeException sce) {
            this._errors.add(sce);
            this._errNodes.add(node.getStatement());
            this._typeStack.clear();
        }
        node.getStatements().apply(this);
        this.outAListStatements(node);
    }

    public void caseAAssignmentStatement(AAssignmentStatement node) {
        this.inAAssignmentStatement(node);
        node.getAssignment().apply(this);
        this._typeMap.put(node, this._typeStack.pop());
        this.outAAssignmentStatement(node);
    }

    public void caseAAssignment(AAssignment node) {
        this.inAAssignment(node);
        node.getFieldAccess().apply(this);
        KType fla = (KType)this._typeStack.pop();
        this._typeContext = fla instanceof KArrayType ? ((KArrayType)fla).getBaseType() : fla;
        node.getExpression().apply(this);
        KType exp = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(fla, exp)) {
            int[] pos = Util.getFirstIdent(node.getExpression());
            SourceCodeException.throwIncompatibleTypes_Assignment(pos[0], pos[1], pos[2], fla, exp);
        }
        this._typeMap.put(node, fla);
        this._typeStack.push(fla);
        this.inAAssignment(node);
    }

    public void caseAIfStat(AIfStat node) {
        KType boolRet;
        this.inAIfStat(node);
        if (node.getBoolExpression() != null) {
            node.getBoolExpression().apply(this);
        }
        if (!Util.isAssignmentCompatible(boolRet = (KType)this._typeStack.pop(), KBasicType.getBoolean())) {
            int[] pos = Util.getFirstIdent(node.getBoolExpression());
            SourceCodeException.throwIncompatibleTypes_IfBoolean(pos[0], pos[1], pos[2], boolRet);
        }
        if (node.getBlock1() != null) {
            node.getBlock1().apply(this);
        }
        if (node.getElsePart() != null) {
            node.getElsePart().apply(this);
        }
        this.outAIfStat(node);
    }

    public void caseAWhileStatement(AWhileStatement node) {
        this.inAWhileStatement(node);
        node.getBoolExpression().apply(this);
        KType boolRet = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(boolRet, KBasicType.getBoolean())) {
            int[] pos = Util.getFirstIdent(node.getBoolExpression());
            SourceCodeException.throwIncompatibleTypes_WhileBoolean(pos[0], pos[1], pos[2], boolRet);
        }
        if (node.getBlock() != null) {
            node.getBlock().apply(this);
        }
        this.outAWhileStatement(node);
    }

    public void caseAReturnStatement(AReturnStatement node) {
        KType retted;
        this.inAReturnStatement(node);
        this._typeContext = this._retVal;
        if (node.getExpression() != null) {
            node.getExpression().apply(this);
            retted = (KType)this._typeStack.pop();
        } else {
            retted = null;
        }
        int ln = node.getReturn().getLine();
        int pos = node.getReturn().getPos();
        int len = node.getReturn().getText().trim().length();
        if (retted == null) {
            if (this._retVal != KBasicType.getVoid()) {
                SourceCodeException.throwReturn_MissingReturnValue(ln, pos, len, this._retVal);
            }
        } else if (!Util.isAssignmentCompatible(this._retVal, retted)) {
            if (this._retVal == KBasicType.getVoid()) {
                SourceCodeException.throwReturn_ValueInVoid(ln, pos, len, retted);
            } else {
                SourceCodeException.throwIncompatibleTypes_Return(ln, pos, len, retted, this._retVal);
            }
        }
        this._typeMap.put(node, this._retVal);
        this._typeContext = null;
        this.outAReturnStatement(node);
    }

    public void caseASwitchStatement(ASwitchStatement node) {
        this.inASwitchStatement(node);
        KType tmp = this._switchType;
        this._switchType = null;
        node.getBoolExpression().apply(this);
        this._switchType = (KType)this._typeStack.pop();
        if (this._switchType instanceof KEnumType || Util.isAssignmentCompatible(KBasicType.getInt(), this._switchType)) {
            if (node.getSwitchBlock() != null) {
                node.getSwitchBlock().apply(this);
            }
        } else {
            int[] pos = Util.getFirstIdent(node.getBoolExpression());
            SourceCodeException.throwIncompatibleTypes_SwitchTopLevel(pos[0], pos[1], pos[2], this._switchType);
        }
        this._switchType = tmp;
        this.outASwitchStatement(node);
    }

    public void caseASwitchBlock(ASwitchBlock node) {
        this.inASwitchBlock(node);
        Iterator it = node.getPossibleCase().iterator();
        boolean foundDefault = false;
        KType tmpSwitchType = this._switchType;
        while (it.hasNext()) {
            PPossibleCase ppc = (PPossibleCase)it.next();
            if (ppc instanceof ACasePossibleCase) {
                ACasePossibleCase acpc = (ACasePossibleCase)ppc;
                KType tmpContext = this._typeContext;
                this._typeContext = this._switchType;
                acpc.getBoolExpression().apply(this);
                this._typeContext = tmpContext;
                KType retType = (KType)this._typeStack.pop();
                if (!Util.isAssignmentCompatible(this._switchType, retType)) {
                    int[] pos = Util.getFirstIdent(acpc.getBoolExpression());
                    if (this._switchType instanceof KEnumType) {
                        SourceCodeException.throwSwitch_EnumCaseExpected(pos[0], pos[1], pos[2], this._switchType);
                    } else {
                        SourceCodeException.throwIncompatibleTypes_SwitchCaseLevel(pos[0], pos[1], pos[2], this._switchType, retType);
                    }
                }
                this._switchType = null;
                acpc.getBlock().apply(this);
                this._switchType = tmpSwitchType;
                continue;
            }
            if (ppc instanceof ADefaultPossibleCase) {
                ADefaultPossibleCase adpc = (ADefaultPossibleCase)ppc;
                if (foundDefault) {
                    int ln = adpc.getDefault().getLine();
                    int pos = adpc.getDefault().getPos();
                    int len = adpc.getDefault().getText().trim().length();
                    SourceCodeException.throwSwitch_DuplicateDefault(ln, pos, len);
                }
                foundDefault = true;
                this._switchType = null;
                adpc.getBlock().apply(this);
                this._switchType = tmpSwitchType;
                continue;
            }
            throw new KenyaInternalError("Got a switch possible case that isn't default or case.");
        }
        this.outASwitchBlock(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void caseAForStatement(AForStatement node) {
        this.inAForStatement(node);
        this._symTab.newLocalScope();
        try {
            node.getForControl().apply(this);
            node.getBlock().apply(this);
        }
        finally {
            this._symTab.pop();
        }
        this.outAForStatement(node);
    }

    public void caseAJavaForControl(AJavaForControl node) {
        this.inAJavaForControl(node);
        node.getForLeftStat().apply(this);
        node.getBoolExpression().apply(this);
        KType boolTop = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(boolTop, KBasicType.getBoolean())) {
            int[] pos = Util.getFirstIdent(node.getBoolExpression());
            SourceCodeException.throwIncompatibleTypes_ForBoolean(pos[0], pos[1], pos[2], boolTop);
        }
        if (node.getForRightStat() != null) {
            node.getForRightStat().apply(this);
        }
        this.outAJavaForControl(node);
    }

    public void caseAFunctioncallForRightStat(AFunctioncallForRightStat node) {
        this.inAFunctioncallForRightStat(node);
        node.getFunctionApplication().apply(this);
        this._typeStack.pop();
        this.outAFunctioncallForRightStat(node);
    }

    public void caseAAssignmentForRightStat(AAssignmentForRightStat node) {
        this.inAAssignmentForRightStat(node);
        node.getAssignment().apply(this);
        this._typeStack.pop();
        this.outAAssignmentForRightStat(node);
    }

    public void caseAAssignmentForLeftStat(AAssignmentForLeftStat node) {
        this.inAAssignmentForLeftStat(node);
        node.getAssignment().apply(this);
        this._typeStack.pop();
        this.outAAssignmentForLeftStat(node);
    }

    public void caseAAssertStatement(AAssertStatement node) {
        this.inAAssertStatement(node);
        node.getBoolExpression().apply(this);
        KType tos = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(tos, KBasicType.getBoolean())) {
            int[] pos = Util.getFirstIdent(node.getBoolExpression());
            SourceCodeException.throwIncompatibleTypes_AssertBoolean(pos[0], pos[1], pos[2], tos);
        }
        if (node.getColonString() != null) {
            node.getColonString().apply(this);
        }
        this.outAAssertStatement(node);
    }

    public void caseAColonString(AColonString node) {
        this.inAColonString(node);
        node.getExpression().apply(this);
        KType type = (KType)this._typeStack.pop();
        if (type == KBasicType.getVoid()) {
            int[] pos = Util.getFirstIdent(node);
            SourceCodeException.throwVoidInAssert(pos[0], pos[1], pos[2]);
        }
        this.outAColonString(node);
    }

    public void caseAFunctioncallStatement(AFunctioncallStatement node) {
        this.inAFunctioncallStatement(node);
        node.getFunctionApplication().apply(this);
        this._typeStack.pop();
        this.outAFunctioncallStatement(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void caseABlock(ABlock node) {
        this.inABlock(node);
        this._symTab.newLocalScope();
        try {
            node.getStatements().apply(this);
        }
        finally {
            this._symTab.pop();
        }
        this.outABlock(node);
    }

    public void caseAFunctionApplication(AFunctionApplication node) {
        this.inAFunctionApplication(node);
        PName unName = node.getName();
        if (!(unName instanceof ASimpleNameName)) {
            int[] errPos = Util.getFirstIdent(unName);
            SourceCodeException.throwFunctionApplication_NoDots(errPos[0], errPos[1], errPos[2]);
            return;
        }
        String name = ((ASimpleName)((ASimpleNameName)unName).getSimpleName()).getIdentifier().getText().trim();
        Stack tmpStack = this._typeStack;
        this._typeStack = new Stack();
        if (node.getActualParamList() != null) {
            node.getActualParamList().apply(this);
        }
        int[] pos = Util.getFirstIdent(node.getName());
        PairKFunctionReturnType pkfrt = this._funcTable.getFuncAndRetType(name, this._typeStack, pos[0], pos[1], pos[2], this._warnings, this._cScope);
        KType retType = pkfrt.getRetType();
        KFunction kf = pkfrt.getKFunction();
        if (retType instanceof KParamType && !this._paramMap.containsKey(retType.toString())) {
            retType = this._typeContext;
        }
        this._typeStack = tmpStack;
        this._typeMap.put(node, retType);
        this._funcMap.put(node, kf);
        this._typeStack.push(retType);
        this.outAFunctionApplication(node);
    }

    public void caseAListActualParamList(AListActualParamList node) {
        this.inAListActualParamList(node);
        node.getActualParamList().apply(this);
        node.getComma().apply(this);
        node.getExpression().apply(this);
        KType retType = (KType)this._typeStack.peek();
        if (retType == KBasicType.getVoid()) {
            int[] pos = Util.getFirstIdent(node.getExpression());
            SourceCodeException.throwFunctionApplication_Void(pos[0], pos[1], pos[2]);
        }
        this.outAListActualParamList(node);
    }

    public void caseAExpActualParamList(AExpActualParamList node) {
        this.inAExpActualParamList(node);
        node.getExpression().apply(this);
        KType retType = (KType)this._typeStack.peek();
        if (retType == KBasicType.getVoid()) {
            int[] pos = Util.getFirstIdent(node.getExpression());
            SourceCodeException.throwFunctionApplication_Void(pos[0], pos[1], pos[2]);
        }
        this.outAExpActualParamList(node);
    }

    public void caseAVarDecInnerDeclaration(AVarDecInnerDeclaration node) {
        this.inAVarDecInnerDeclaration(node);
        String ident = node.getIdentifier().getText().trim();
        KType kt = Util.getType(node.getType(), this._classTable, this._paramMap, 0, this._cScope);
        if (kt == KBasicType.getVoid()) {
            int[] pos = Util.getFirstIdent(node.getType());
            SourceCodeException.throwVariableDeclaration_Void(pos[0], pos[1], pos[2]);
        }
        KVariable kv = new KVariable(ident, kt, false, node);
        this._typeContext = kt;
        if (node.getInitialiser() != null) {
            node.getInitialiser().apply(this);
            KType assigType = (KType)this._typeStack.pop();
            if (!Util.isAssignmentCompatible(kt, assigType)) {
                int[] pos = Util.getFirstIdent(((AInitialiser)node.getInitialiser()).getBoolExpression());
                SourceCodeException.throwIncompatibleTypes_Assignment(pos[0], pos[1], pos[2], kt, assigType);
            }
        }
        if (!this._symTab.pushLocal(ident, kv)) {
            int ln = node.getIdentifier().getLine();
            int pos = node.getIdentifier().getPos();
            int len = node.getIdentifier().getText().trim().length();
            KVariable conf = this._symTab.lookupVariable(ident);
            int[][] lnkPos = new int[][]{Util.getFirstIdent(conf.getNode())};
            SourceCodeException.throwDuplicateVariable(ln, pos, len, lnkPos, ident, this._cScope);
        }
        this._typeMap.put(node, kt);
        this.outAVarDecInnerDeclaration(node);
    }

    public void caseAArrayDecInnerDeclaration(AArrayDecInnerDeclaration node) {
        int len;
        int pos;
        int ln;
        this.inAArrayDecInnerDeclaration(node);
        String ident = node.getIdentifier().getText().trim();
        int numBrackets = node.getBracketPair().size();
        KType kt = Util.getType(node.getType(), this._classTable, this._paramMap, numBrackets, this._cScope);
        this._typeMap.put(node, kt);
        if (kt == KBasicType.getVoid()) {
            int[] pos2 = Util.getFirstIdent(node.getType());
            SourceCodeException.throwVariableDeclaration_Void(pos2[0], pos2[1], pos2[2]);
        }
        KVariable kv = new KVariable(ident, kt, false, node);
        if (kt == KBasicType.getVoid()) {
            ln = node.getIdentifier().getLine();
            pos = node.getIdentifier().getPos();
            len = node.getIdentifier().getText().trim().length();
            SourceCodeException.throwVoidArrayType(ln, pos, len);
        }
        if (node.getArrayInitialiser() != null) {
            KBoundClassType kbct;
            boolean genericClassType = false;
            if (((KArrayType)kt).getBaseType() instanceof KBoundClassType && (kbct = (KBoundClassType)((KArrayType)kt).getBaseType()).getBase().getTypeParamList().size() != 0) {
                genericClassType = true;
            }
            if (((KArrayType)kt).getBaseType() instanceof KParamType || genericClassType) {
                if (node.getArrayInitialiser() instanceof AStaticArrayInitialiser) {
                    int[] pos3 = Util.getFirstIdent(((AStaticArrayInitialiser)node.getArrayInitialiser()).getArrayInit());
                    SourceCodeException.throwGeneric_Array_Creation(pos3[0], pos3[1], pos3[2]);
                } else if (node.getArrayInitialiser() instanceof ADynamicArrayInitialiser) {
                    int[] pos4 = Util.getFirstIdent(((ADynamicArrayInitialiser)node.getArrayInitialiser()).getArrayAllocate());
                    SourceCodeException.throwGeneric_Array_Creation(pos4[0], pos4[1], pos4[2]);
                }
            }
            KType tmp = this._arrType;
            this._arrType = kt;
            node.getArrayInitialiser().apply(this);
            this._arrType = tmp;
            KType assigType = (KType)this._typeStack.pop();
            if (!Util.isAssignmentCompatible(kt, assigType)) {
                int[] pos5 = Util.getFirstIdent(node.getArrayInitialiser());
                SourceCodeException.throwIncompatibleTypes_Assignment(pos5[0], pos5[1], pos5[2], kt, assigType);
            }
        }
        if (!this._symTab.pushLocal(ident, kv)) {
            ln = node.getIdentifier().getLine();
            pos = node.getIdentifier().getPos();
            len = node.getIdentifier().getText().trim().length();
            KVariable conf = this._symTab.lookupVariable(ident);
            int[][] lnkPos = new int[][]{Util.getFirstIdent(conf.getNode())};
            SourceCodeException.throwDuplicateVariable(ln, pos, len, lnkPos, ident, this._cScope);
        }
        this.outAArrayDecInnerDeclaration(node);
    }

    public void caseAClassDecDeclaration(AClassDecDeclaration node) {
        this.inAClassDecDeclaration(node);
        this.outAClassDecDeclaration(node);
    }

    public void caseAEnumDecDeclaration(AEnumDecDeclaration node) {
        this.inAEnumDecDeclaration(node);
        this.outAEnumDecDeclaration(node);
    }

    public void caseAEnumList(AEnumList node) {
        throw KenyaBadLocationError.get();
    }

    public void caseACommaEnumList(ACommaEnumList node) {
        throw KenyaBadLocationError.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void caseAFuncDecDeclaration(AFuncDecDeclaration node) {
        block6: {
            if (this._errNodes.contains(node)) {
                return;
            }
            try {
                this.inAFuncDecDeclaration(node);
                KFunction kf = Util.makeFunction(node, this._classTable);
                this._funcMap.put(node, kf);
                this._paramMap = kf.getTypeParamMap();
                if (node.getBlock() == null) break block6;
                this._cScope = "method " + kf.getName() + FunctionTable.paramsToString(kf.getArgs());
                this._symTab.push(kf.getSymbolTable());
                this._retVal = kf.getReturnType();
                try {
                    node.getBlock().apply(this);
                }
                finally {
                    this._symTab.pop();
                    this._cScope = null;
                }
            }
            catch (SourceCodeException sce) {
                this._errors.add(sce);
                this._errNodes.add(node);
            }
        }
        this.outAFuncDecDeclaration(node);
    }

    public void caseAConstDecDeclaration(AConstDecDeclaration node) {
        this.inAConstDecDeclaration(node);
        this.outAConstDecDeclaration(node);
    }

    public void inAFormalParamList(AFormalParamList node) {
        throw KenyaBadLocationError.get();
    }

    public void inATypeName(ATypeName node) {
        throw KenyaBadLocationError.get();
    }

    public void inACommaTypeName(ACommaTypeName node) {
        throw KenyaBadLocationError.get();
    }

    public void caseAArrayInit(AArrayInit node) {
        this.inAArrayInit(node);
        KType tmp = this._arrType;
        if (!(this._arrType instanceof KArrayType)) {
            int ln = node.getLBrace().getLine();
            int pos = node.getLBrace().getPos();
            int len = node.getLBrace().getText().trim().length();
            SourceCodeException.throwArrayDeclaration_TooManyBraces(ln, pos, len, this._arrType);
        }
        this._arrType = ((KArrayType)this._arrType).getChildType();
        node.getInitList().apply(this);
        KType kt = (KType)this._typeStack.pop();
        if (kt == KBasicType.getVoid()) {
            int[] pos = Util.getFirstIdent(node.getInitList());
            SourceCodeException.throwVoidArrayType(pos[0], pos[1], pos[2]);
        }
        if (Util.isAssignmentCompatible(this._arrType, kt)) {
            this._typeMap.put(node, new KArrayType(this._arrType));
            this._typeStack.push(new KArrayType(this._arrType));
        } else {
            this._typeMap.put(node, new KArrayType(kt));
            this._typeStack.push(new KArrayType(kt));
        }
        this._arrType = tmp;
        this.outAArrayInit(node);
    }

    public void caseAScalarInitList(AScalarInitList node) {
        this.inAScalarInitList(node);
        node.getExpression().apply(this);
        KType cType = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(this._arrType, cType)) {
            int[] pos = Util.getFirstIdent(node.getExpression());
            SourceCodeException.throwIncompatibleTypes_Assignment(pos[0], pos[1], pos[2], this._arrType, cType);
        }
        Object[] temp = node.getCommaExp().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PCommaExp)temp[i]).apply(this);
            KType nType = (KType)this._typeStack.pop();
            if (Util.isAssignmentCompatible(this._arrType, nType)) continue;
            int[] pos = Util.getFirstIdent(((ACommaExp)temp[i]).getExpression());
            SourceCodeException.throwIncompatibleTypes_Assignment(pos[0], pos[1], pos[2], this._arrType, nType);
        }
        this._typeMap.put(node, cType);
        this._typeStack.push(cType);
        this.outAScalarInitList(node);
    }

    public void caseAArrayInitList(AArrayInitList node) {
        this.inAArrayInitList(node);
        node.getArrayInit().apply(this);
        KType cType = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(this._arrType, cType)) {
            int[] pos = Util.getFirstIdent(node.getArrayInit());
            SourceCodeException.throwIncompatibleTypes_Assignment(pos[0], pos[1], pos[2], this._arrType, cType);
        }
        Object[] temp = node.getCommaArrayInit().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PCommaArrayInit)temp[i]).apply(this);
            KType nType = (KType)this._typeStack.pop();
            if (Util.isAssignmentCompatible(this._arrType, nType)) continue;
            int[] pos = Util.getFirstIdent(((ACommaArrayInit)temp[i]).getArrayInit());
            SourceCodeException.throwIncompatibleTypes_Assignment(pos[0], pos[1], pos[2], this._arrType, nType);
        }
        this._typeMap.put(node, cType);
        this._typeStack.push(cType);
        this.outAArrayInitList(node);
    }

    public void caseAArrayAllocate(AArrayAllocate node) {
        KBoundClassType kbct;
        this.inAArrayAllocate(node);
        int numBrackets = node.getArrayAccess().size();
        Object[] temp = node.getArrayAccess().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PArrayAccess)temp[i]).apply(this);
        }
        KType kt = Util.getType(node.getType(), this._classTable, this._paramMap, numBrackets += node.getBracketPair().size(), this._cScope);
        boolean genericBase = false;
        if (((KArrayType)kt).getBaseType() instanceof KBoundClassType && (kbct = (KBoundClassType)((KArrayType)kt).getBaseType()).getBase().getTypeParamList().size() != 0) {
            genericBase = true;
        }
        if (((KArrayType)kt).getBaseType() instanceof KParamType || genericBase) {
            int[] pos = Util.getFirstIdent(node);
            SourceCodeException.throwGeneric_Array_Creation(pos[0], pos[1], pos[2]);
        }
        this._typeMap.put(node, kt);
        this._typeStack.push(kt);
        this.outAArrayAllocate(node);
    }

    public void inATrueBooleanliteral(ATrueBooleanliteral node) {
        throw KenyaBadLocationError.get();
    }

    public void inAFalseBooleanliteral(AFalseBooleanliteral node) {
        throw KenyaBadLocationError.get();
    }

    public void inACharBasicType(ACharBasicType node) {
        throw KenyaBadLocationError.get();
    }

    public void inAIntBasicType(AIntBasicType node) {
        throw KenyaBadLocationError.get();
    }

    public void inADoubleBasicType(ADoubleBasicType node) {
        throw KenyaBadLocationError.get();
    }

    public void inAStringBasicType(AStringBasicType node) {
        throw KenyaBadLocationError.get();
    }

    public void inABooleanBasicType(ABooleanBasicType node) {
        throw KenyaBadLocationError.get();
    }

    public void inAVoidBasicType(AVoidBasicType node) {
        throw KenyaBadLocationError.get();
    }

    public void inAClassTypeReferenceType(AClassTypeReferenceType node) {
        throw KenyaBadLocationError.get();
    }

    public void inATypeParam(ATypeParam node) {
        throw KenyaBadLocationError.get();
    }

    public void inATypeParamList(ATypeParamList node) {
        throw KenyaBadLocationError.get();
    }

    public void inACommaType(ACommaType node) {
        throw KenyaBadLocationError.get();
    }

    public void caseAPlusMathExpression(APlusMathExpression node) {
        this.inAPlusMathExpression(node);
        node.getMathExpression().apply(this);
        KType lhs = (KType)this._typeStack.pop();
        node.getTerm().apply(this);
        KType rhs = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(KBasicType.getDouble(), lhs) && !Util.isAssignmentCompatible(KBasicType.getDouble(), rhs) && lhs != KBasicType.getString() && rhs != KBasicType.getString()) {
            int ln = node.getPlus().getLine();
            int pos = node.getPlus().getPos();
            int len = node.getPlus().getText().trim().length();
            SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, "+", rhs);
            return;
        }
        if (lhs != KBasicType.getString() || rhs == KBasicType.getVoid()) {
            if (rhs == KBasicType.getString() && lhs != KBasicType.getVoid()) {
                lhs = rhs;
            } else if (!Util.isAssignmentCompatible(lhs, rhs)) {
                if (Util.isAssignmentCompatible(rhs, lhs)) {
                    lhs = rhs;
                } else {
                    int ln = node.getPlus().getLine();
                    int pos = node.getPlus().getPos();
                    int len = node.getPlus().getText().trim().length();
                    SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, "+", rhs);
                }
            }
        }
        this._typeMap.put(node, lhs);
        this._typeStack.push(lhs);
        this.outAPlusMathExpression(node);
    }

    public void caseAMinusMathExpression(AMinusMathExpression node) {
        int len;
        int pos;
        int ln;
        node.getMathExpression().apply(this);
        KType lhs = (KType)this._typeStack.pop();
        node.getTerm().apply(this);
        KType rhs = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(KBasicType.getDouble(), lhs)) {
            ln = node.getMinus().getLine();
            pos = node.getMinus().getPos();
            len = node.getMinus().getText().trim().length();
            SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, "-", rhs);
        }
        if (!Util.isAssignmentCompatible(lhs, rhs)) {
            if (Util.isAssignmentCompatible(rhs, lhs)) {
                lhs = rhs;
            } else {
                ln = node.getMinus().getLine();
                pos = node.getMinus().getPos();
                len = node.getMinus().getText().trim().length();
                SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, "-", rhs);
            }
        }
        this._typeMap.put(node, lhs);
        this._typeStack.push(lhs);
    }

    public void caseAMultTerm(AMultTerm node) {
        int len;
        int pos;
        int ln;
        this.inAMultTerm(node);
        node.getTerm().apply(this);
        KType lhs = (KType)this._typeStack.pop();
        node.getUnaryExp().apply(this);
        KType rhs = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(KBasicType.getDouble(), lhs)) {
            ln = node.getTimes().getLine();
            pos = node.getTimes().getPos();
            len = node.getTimes().getText().trim().length();
            SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, "*", rhs);
        }
        if (!Util.isAssignmentCompatible(lhs, rhs)) {
            if (Util.isAssignmentCompatible(rhs, lhs)) {
                lhs = rhs;
            } else {
                ln = node.getTimes().getLine();
                pos = node.getTimes().getPos();
                len = node.getTimes().getText().trim().length();
                SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, "*", rhs);
            }
        }
        this._typeMap.put(node, lhs);
        this._typeStack.push(lhs);
        this.outAMultTerm(node);
    }

    public void caseADivTerm(ADivTerm node) {
        int len;
        int pos;
        int ln;
        this.inADivTerm(node);
        node.getTerm().apply(this);
        KType lhs = (KType)this._typeStack.pop();
        node.getUnaryExp().apply(this);
        KType rhs = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(KBasicType.getDouble(), lhs)) {
            ln = node.getDivide().getLine();
            pos = node.getDivide().getPos();
            len = node.getDivide().getText().trim().length();
            SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, "/", rhs);
        }
        if (!Util.isAssignmentCompatible(lhs, rhs)) {
            if (Util.isAssignmentCompatible(rhs, lhs)) {
                lhs = rhs;
            } else {
                ln = node.getDivide().getLine();
                pos = node.getDivide().getPos();
                len = node.getDivide().getText().trim().length();
                SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, "/", rhs);
            }
        }
        this._typeMap.put(node, lhs);
        this._typeStack.push(lhs);
        this.outADivTerm(node);
    }

    public void caseAModTerm(AModTerm node) {
        int len;
        int pos;
        int ln;
        this.inAModTerm(node);
        node.getTerm().apply(this);
        KType lhs = (KType)this._typeStack.pop();
        node.getUnaryExp().apply(this);
        KType rhs = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(KBasicType.getDouble(), lhs)) {
            ln = node.getMod().getLine();
            pos = node.getMod().getPos();
            len = node.getMod().getText().trim().length();
            SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, "%", rhs);
        }
        if (!Util.isAssignmentCompatible(lhs, rhs)) {
            if (Util.isAssignmentCompatible(rhs, lhs)) {
                lhs = rhs;
            } else {
                ln = node.getMod().getLine();
                pos = node.getMod().getPos();
                len = node.getMod().getText().trim().length();
                SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, "%", rhs);
                return;
            }
        }
        this._typeMap.put(node, lhs);
        this._typeStack.push(lhs);
        this.outAModTerm(node);
    }

    public void caseAMinusUnaryExp(AMinusUnaryExp node) {
        this.inAMinusUnaryExp(node);
        node.getUnaryExp().apply(this);
        KType kt = (KType)this._typeStack.peek();
        if (!Util.isAssignmentCompatible(KBasicType.getDouble(), kt)) {
            int ln = node.getMinus().getLine();
            int pos = node.getMinus().getPos();
            int len = node.getMinus().getText().trim().length();
            SourceCodeException.throwUnop_InvalidApplication(ln, pos, len, "-", kt);
        }
        this.outAMinusUnaryExp(node);
    }

    public void caseAPlusUnaryExp(APlusUnaryExp node) {
        this.inAPlusUnaryExp(node);
        node.getUnaryExp().apply(this);
        KType kt = (KType)this._typeStack.peek();
        if (!Util.isAssignmentCompatible(KBasicType.getDouble(), kt)) {
            int ln = node.getPlus().getLine();
            int pos = node.getPlus().getPos();
            int len = node.getPlus().getText().trim().length();
            SourceCodeException.throwUnop_InvalidApplication(ln, pos, len, "+", kt);
        }
        this.outAPlusUnaryExp(node);
    }

    public void caseANegateUnaryExp(ANegateUnaryExp node) {
        this.inANegateUnaryExp(node);
        node.getUnaryExp().apply(this);
        KType kt = (KType)this._typeStack.peek();
        if (!Util.isAssignmentCompatible(kt, KBasicType.getBoolean())) {
            int ln = node.getNot().getLine();
            int pos = node.getNot().getPos();
            int len = node.getNot().getText().trim().length();
            SourceCodeException.throwUnop_InvalidApplication(ln, pos, len, "!", kt);
        }
        this.outANegateUnaryExp(node);
    }

    public void caseAPostdecr(APostdecr node) {
        this.inAPostdecr(node);
        node.getFieldAccess().apply(this);
        KType kt = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(KBasicType.getInt(), kt)) {
            int ln = node.getMinusminus().getLine();
            int pos = node.getMinusminus().getPos();
            int len = node.getMinusminus().getText().trim().length();
            SourceCodeException.throwUnop_InvalidApplication(ln, pos, len, "--", kt);
        }
        this.outAPostdecr(node);
    }

    public void caseAPostincr(APostincr node) {
        this.inAPostincr(node);
        node.getFieldAccess().apply(this);
        KType kt = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(KBasicType.getInt(), kt)) {
            int ln = node.getPlusplus().getLine();
            int pos = node.getPlusplus().getPos();
            int len = node.getPlusplus().getText().trim().length();
            SourceCodeException.throwUnop_InvalidApplication(ln, pos, len, "++", kt);
        }
        this.outAPostincr(node);
    }

    public void caseAPredecr(APredecr node) {
        this.inAPredecr(node);
        node.getFieldAccess().apply(this);
        KType kt = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(KBasicType.getInt(), kt)) {
            int ln = node.getMinusminus().getLine();
            int pos = node.getMinusminus().getPos();
            int len = node.getMinusminus().getText().trim().length();
            SourceCodeException.throwUnop_InvalidApplication(ln, pos, len, "--", kt);
        }
        this.outAPredecr(node);
    }

    public void caseAPreincr(APreincr node) {
        this.inAPreincr(node);
        node.getFieldAccess().apply(this);
        KType kt = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(KBasicType.getInt(), kt)) {
            int ln = node.getPlusplus().getLine();
            int pos = node.getPlusplus().getPos();
            int len = node.getPlusplus().getText().trim().length();
            SourceCodeException.throwUnop_InvalidApplication(ln, pos, len, "++", kt);
        }
        this.outAPreincr(node);
    }

    public void caseANullFactor(ANullFactor node) {
        this.inANullFactor(node);
        this._typeMap.put(node, KNullType.get());
        this._typeStack.push(KNullType.get());
        this.outANullFactor(node);
    }

    public void caseAINumber(AINumber node) {
        this.inAINumber(node);
        if (this._typeContext == KBasicType.getChar()) {
            this._typeMap.put(node, KBasicType.getChar());
            this._typeStack.push(KBasicType.getChar());
        } else {
            this._typeMap.put(node, KBasicType.getInt());
            this._typeStack.push(KBasicType.getInt());
        }
        this.outAINumber(node);
    }

    public void caseADNumber(ADNumber node) {
        this.inADNumber(node);
        this._typeMap.put(node, KBasicType.getDouble());
        this._typeStack.push(KBasicType.getDouble());
        this.outADNumber(node);
    }

    public void caseACharliteralFactor(ACharliteralFactor node) {
        this.inACharliteralFactor(node);
        this._typeMap.put(node, KBasicType.getChar());
        this._typeStack.push(KBasicType.getChar());
        this.outACharliteralFactor(node);
    }

    public void caseABoolliteralFactor(ABoolliteralFactor node) {
        this.inABoolliteralFactor(node);
        this._typeMap.put(node, KBasicType.getBoolean());
        this._typeStack.push(KBasicType.getBoolean());
        this.outABoolliteralFactor(node);
    }

    public void caseAStringliteralFactor(AStringliteralFactor node) {
        this.inAStringliteralFactor(node);
        this._typeMap.put(node, KBasicType.getString());
        this._typeStack.push(KBasicType.getString());
        this.outAStringliteralFactor(node);
    }

    public void caseAOrBoolExpression(AOrBoolExpression node) {
        int len;
        int pos;
        int ln;
        this.inAOrBoolExpression(node);
        node.getBoolExpression().apply(this);
        KType lhs = (KType)this._typeStack.pop();
        node.getBoolTerm().apply(this);
        KType rhs = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(lhs, KBasicType.getBoolean())) {
            ln = node.getOr().getLine();
            pos = node.getOr().getPos();
            len = node.getOr().getText().trim().length();
            SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, node.getOr().getText().trim(), rhs);
        }
        if (!Util.isAssignmentCompatible(rhs, KBasicType.getBoolean())) {
            ln = node.getOr().getLine();
            pos = node.getOr().getPos();
            len = node.getOr().getText().trim().length();
            SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, node.getOr().getText().trim(), rhs);
        }
        this._typeMap.put(node, KBasicType.getBoolean());
        this._typeStack.push(KBasicType.getBoolean());
        this.outAOrBoolExpression(node);
    }

    public void caseAXorBoolExpression(AXorBoolExpression node) {
        int len;
        int pos;
        int ln;
        this.inAXorBoolExpression(node);
        node.getBoolExpression().apply(this);
        KType lhs = (KType)this._typeStack.pop();
        node.getBoolTerm().apply(this);
        KType rhs = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(lhs, KBasicType.getBoolean())) {
            ln = node.getXor().getLine();
            pos = node.getXor().getPos();
            len = node.getXor().getText().trim().length();
            SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, node.getXor().getText().trim(), rhs);
        }
        if (!Util.isAssignmentCompatible(rhs, KBasicType.getBoolean())) {
            ln = node.getXor().getLine();
            pos = node.getXor().getPos();
            len = node.getXor().getText().trim().length();
            SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, node.getXor().getText().trim(), rhs);
        }
        this._typeMap.put(node, KBasicType.getBoolean());
        this._typeStack.push(KBasicType.getBoolean());
        this.outAXorBoolExpression(node);
    }

    public void caseAAndBoolTerm(AAndBoolTerm node) {
        int len;
        int pos;
        int ln;
        this.inAAndBoolTerm(node);
        node.getBoolTerm().apply(this);
        KType lhs = (KType)this._typeStack.pop();
        node.getEquality().apply(this);
        KType rhs = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(lhs, KBasicType.getBoolean())) {
            ln = node.getAnd().getLine();
            pos = node.getAnd().getPos();
            len = node.getAnd().getText().trim().length();
            SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, node.getAnd().getText().trim(), rhs);
        }
        if (!Util.isAssignmentCompatible(rhs, KBasicType.getBoolean())) {
            ln = node.getAnd().getLine();
            pos = node.getAnd().getPos();
            len = node.getAnd().getText().trim().length();
            SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, node.getAnd().getText().trim(), rhs);
        }
        this._typeMap.put(node, KBasicType.getBoolean());
        this._typeStack.push(KBasicType.getBoolean());
        this.outAAndBoolTerm(node);
    }

    public void caseAEqEquality(AEqEquality node) {
        this.inAEqEquality(node);
        node.getEquality().apply(this);
        KType lhs = (KType)this._typeStack.pop();
        node.getRelational().apply(this);
        KType rhs = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(rhs, lhs) && !Util.isAssignmentCompatible(lhs, rhs)) {
            int ln = node.getEqual().getLine();
            int pos = node.getEqual().getPos();
            int len = node.getEqual().getText().trim().length();
            SourceCodeException.throwIncomparable(ln, pos, len, lhs, "==", rhs);
        }
        if (lhs == KBasicType.getString() && rhs != KNullType.get() || rhs == KBasicType.getString() && lhs != KNullType.get()) {
            this._typeMap.put(node, KBasicType.getString());
        } else {
            this._typeMap.put(node, KBasicType.getBoolean());
        }
        this._typeStack.push(KBasicType.getBoolean());
        this.outAEqEquality(node);
    }

    public void caseANeqEquality(ANeqEquality node) {
        this.inANeqEquality(node);
        node.getEquality().apply(this);
        KType lhs = (KType)this._typeStack.pop();
        node.getRelational().apply(this);
        KType rhs = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(rhs, lhs) && !Util.isAssignmentCompatible(lhs, rhs)) {
            int ln = node.getNotequal().getLine();
            int pos = node.getNotequal().getPos();
            int len = node.getNotequal().getText().trim().length();
            SourceCodeException.throwIncomparable(ln, pos, len, lhs, "!=", rhs);
        }
        if (lhs == KBasicType.getString() && rhs != KNullType.get() || rhs == KBasicType.getString() && lhs != KNullType.get()) {
            this._typeMap.put(node, KBasicType.getString());
        } else {
            this._typeMap.put(node, KBasicType.getBoolean());
        }
        this._typeStack.push(KBasicType.getBoolean());
        this.outANeqEquality(node);
    }

    public void caseALtRelational(ALtRelational node) {
        this.inALtRelational(node);
        node.getRelational().apply(this);
        KType lhs = (KType)this._typeStack.pop();
        node.getMathExpression().apply(this);
        KType rhs = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(KBasicType.getDouble(), lhs) || !Util.isAssignmentCompatible(KBasicType.getDouble(), rhs)) {
            int ln = node.getLess().getLine();
            int pos = node.getLess().getPos();
            int len = node.getLess().getText().trim().length();
            SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, "<", rhs);
        }
        this._typeMap.put(node, KBasicType.getBoolean());
        this._typeStack.push(KBasicType.getBoolean());
        this.outALtRelational(node);
    }

    public void caseAGtRelational(AGtRelational node) {
        this.inAGtRelational(node);
        node.getRelational().apply(this);
        KType lhs = (KType)this._typeStack.pop();
        node.getMathExpression().apply(this);
        KType rhs = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(KBasicType.getDouble(), lhs) || !Util.isAssignmentCompatible(KBasicType.getDouble(), rhs)) {
            int ln = node.getGreater().getLine();
            int pos = node.getGreater().getPos();
            int len = node.getGreater().getText().trim().length();
            SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, ">", rhs);
        }
        this._typeMap.put(node, KBasicType.getBoolean());
        this._typeStack.push(KBasicType.getBoolean());
        this.outAGtRelational(node);
    }

    public void caseALteqRelational(ALteqRelational node) {
        this.inALteqRelational(node);
        node.getRelational().apply(this);
        KType lhs = (KType)this._typeStack.pop();
        node.getMathExpression().apply(this);
        KType rhs = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(KBasicType.getDouble(), lhs) || !Util.isAssignmentCompatible(KBasicType.getDouble(), rhs)) {
            int ln = node.getLessequal().getLine();
            int pos = node.getLessequal().getPos();
            int len = node.getLessequal().getText().trim().length();
            SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, "<=", rhs);
        }
        this._typeMap.put(node, KBasicType.getBoolean());
        this._typeStack.push(KBasicType.getBoolean());
        this.outALteqRelational(node);
    }

    public void caseAGteqRelational(AGteqRelational node) {
        this.inAGteqRelational(node);
        node.getRelational().apply(this);
        KType lhs = (KType)this._typeStack.pop();
        node.getMathExpression().apply(this);
        KType rhs = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(KBasicType.getDouble(), lhs) || !Util.isAssignmentCompatible(KBasicType.getDouble(), rhs)) {
            int ln = node.getGreaterequal().getLine();
            int pos = node.getGreaterequal().getPos();
            int len = node.getGreaterequal().getText().trim().length();
            SourceCodeException.throwBinop_InvalidApplication(ln, pos, len, lhs, ">=", rhs);
        }
        this._typeMap.put(node, KBasicType.getBoolean());
        this._typeStack.push(KBasicType.getBoolean());
        this.outAGteqRelational(node);
    }

    public void caseAArrayFieldAccess(AArrayFieldAccess node) {
        this.inAArrayFieldAccess(node);
        node.getName().apply(this);
        KType kt = (KType)this._typeStack.pop();
        Object[] temp = node.getArrayAccess().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PArrayAccess)temp[i]).apply(this);
        }
        for (int i = 0; i < node.getArrayAccess().size(); ++i) {
            if (!(kt instanceof KArrayType)) {
                int ln = ((AArrayAccess)node.getArrayAccess().get(i)).getLBracket().getLine();
                int pos = ((AArrayAccess)node.getArrayAccess().get(i)).getLBracket().getPos();
                int len = ((AArrayAccess)node.getArrayAccess().get(i)).getLBracket().getText().trim().length();
                SourceCodeException.throwArray_TooManyAccesses(ln, pos, len, kt);
            }
            kt = ((KArrayType)kt).getChildType();
        }
        this._typeMap.put(node, kt);
        this._typeStack.push(kt);
        this.outAArrayFieldAccess(node);
    }

    public void caseASimpleName(ASimpleName node) {
        KType kt;
        this.inASimpleName(node);
        String ident = node.getIdentifier().getText().trim();
        if (this._switchType != null && this._switchType instanceof KEnumType) {
            KEnumType enumSwi = (KEnumType)this._switchType;
            if (enumSwi.hasChild(ident)) {
                this._typeStack.push(enumSwi);
                this._typeMap.put(node, enumSwi);
                this._enumChildSet.add(node);
                this.outASimpleName(node);
                return;
            }
            int[] pos = Util.getFirstIdent(node);
            SourceCodeException.throwSwitch_EnumCaseExpected(pos[0], pos[1], pos[2], this._switchType);
        }
        if (this._symTab.containsVariable(ident)) {
            kt = this._symTab.lookupVariable(ident).getType();
            this._typeMap.put(node, kt);
            this._typeStack.push(kt);
        } else if (this._classTable.isEnum(ident)) {
            kt = this._classTable.getType(ident);
            if (node.parent() == null || node.parent().parent() == null || !(node.parent().parent().parent() instanceof AQualifiedName)) {
                int ln = node.getIdentifier().getLine();
                int pos = node.getIdentifier().getPos();
                int len = node.getIdentifier().getText().trim().length();
                SourceCodeException.throwLost_Variable(ln, pos, len, ident, this._cScope);
            }
            this._typeMap.put(node, kt);
            this._typeStack.push(kt);
        } else {
            int ln = node.getIdentifier().getLine();
            int pos = node.getIdentifier().getPos();
            int len = node.getIdentifier().getText().trim().length();
            SourceCodeException.throwLost_Variable(ln, pos, len, ident, this._cScope);
        }
        this.outASimpleName(node);
    }

    public void caseAQualifiedName(AQualifiedName node) {
        this.inAQualifiedName(node);
        if (this._switchType != null && this._switchType instanceof KEnumType) {
            int[] pos = Util.getFirstIdent(node);
            SourceCodeException.throwSwitch_EnumCaseExpected(pos[0], pos[1], pos[2], this._switchType);
        }
        node.getFieldAccess().apply(this);
        KType type = (KType)this._typeStack.pop();
        if (type instanceof KBoundClassType) {
            String partName;
            KBoundClassType kbct = (KBoundClassType)type;
            SymbolTable st = kbct.getBoundChildren();
            if (st.containsVariable(partName = node.getIdentifier().getText().trim())) {
                KVariable kv = st.lookupVariable(partName);
                this._typeMap.put(node, kv.getType());
                this._typeStack.push(kv.getType());
            } else {
                int ln = node.getIdentifier().getLine();
                int pos = node.getIdentifier().getPos();
                int len = node.getIdentifier().getText().trim().length();
                SourceCodeException.throwLost_Variable(ln, pos, len, partName, kbct.toString());
            }
        } else {
            if (type instanceof KClassType) {
                throw KenyaPreconditionError.get();
            }
            if (type instanceof KEnumType) {
                KEnumType et = (KEnumType)type;
                String chName = node.getIdentifier().getText().trim();
                if (et.hasChild(chName)) {
                    this._enumChildSet.add(node);
                    this._typeMap.put(node, type);
                    this._typeStack.push(type);
                } else {
                    int ln = node.getIdentifier().getLine();
                    int pos = node.getIdentifier().getPos();
                    int len = node.getIdentifier().getText().trim().length();
                    SourceCodeException.throwLost_Variable(ln, pos, len, chName, et.getName());
                }
            } else if (type instanceof KArrayType) {
                String partName = node.getIdentifier().getText().trim();
                if (partName.equals("length")) {
                    this._arrayLengthRef.add(node);
                    this._typeMap.put(node, KBasicType.getInt());
                    this._typeStack.push(KBasicType.getInt());
                } else {
                    int ln = node.getIdentifier().getLine();
                    int pos = node.getIdentifier().getPos();
                    int len = node.getIdentifier().getText().trim().length();
                    SourceCodeException.throwArray_Dereference(ln, pos, len, partName, "class " + type);
                }
            } else {
                if (type instanceof KParamType) {
                    int ln = node.getIdentifier().getLine();
                    int pos = node.getIdentifier().getPos();
                    int len = node.getIdentifier().getText().trim().length();
                    String name = node.getIdentifier().getText().trim();
                    SourceCodeException.throwTypeParam_Dereference(ln, pos, len, name);
                    return;
                }
                if (type instanceof KBasicType) {
                    int ln = node.getIdentifier().getLine();
                    int pos = node.getIdentifier().getPos();
                    int len = node.getIdentifier().getText().trim().length();
                    SourceCodeException.throwBasicType_Dereference(ln, pos, len, type);
                    return;
                }
                throw new KenyaInternalError("Unknown type" + type);
            }
        }
        this.outAQualifiedName(node);
    }

    public void caseAArrayAccess(AArrayAccess node) {
        this.inAArrayAccess(node);
        KType tmpType = this._typeContext;
        this._typeContext = KBasicType.getInt();
        node.getMathExpression().apply(this);
        KType kt = (KType)this._typeStack.pop();
        if (!Util.isAssignmentCompatible(KBasicType.getInt(), kt)) {
            int[] pos = Util.getFirstIdent(node.getMathExpression());
            SourceCodeException.throwIncompatibleTypes_ArrayIndex(pos[0], pos[1], pos[2], kt);
            return;
        }
        this._typeContext = tmpType;
        this.outAArrayAccess(node);
    }
}

