/*
 * Decompiled with CFR 0.152.
 */
package kenya.sourceCodeInformation.util;

import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.interfaces.ISourceCodeWarning;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import kenya.sourceCodeInformation.util.SourceCodeWarning;

public class SourceCodeWarningFactory {
    private SourceCodeWarningFactory() {
    }

    public static ISourceCodeWarning alwaysTrueIf(int ln, int pos, int len) {
        return new SourceCodeWarning("This if condition expression is always true", 1001, new SourceCodeLocation(ln, pos, len), null);
    }

    public static ISourceCodeWarning alwaysFalseIf(int ln, int pos, int len) {
        return new SourceCodeWarning("This if condition expression is always false", 1002, new SourceCodeLocation(ln, pos, len), null);
    }

    public static ISourceCodeWarning alwaysTrueWhile(int ln, int pos, int len) {
        return new SourceCodeWarning("This while loop condition expression is always true", 1003, new SourceCodeLocation(ln, pos, len), null);
    }

    public static ISourceCodeWarning alwaysFalseWhile(int ln, int pos, int len) {
        return new SourceCodeWarning("This while loop condition expression is always false", 1004, new SourceCodeLocation(ln, pos, len), null);
    }

    public static ISourceCodeWarning alwaysConstantInSwitch(int ln, int pos, int len) {
        return new SourceCodeWarning("This switch is always performed on the same constant value", 1005, new SourceCodeLocation(ln, pos, len), null);
    }

    public static ISourceCodeWarning alwaysTrueFor(int ln, int pos, int len) {
        return new SourceCodeWarning("This for loop condition expression is always true", 1006, new SourceCodeLocation(ln, pos, len), null);
    }

    public static ISourceCodeWarning alwaysFalseFor(int ln, int pos, int len) {
        return new SourceCodeWarning("This for loop condition expression is always false", 1007, new SourceCodeLocation(ln, pos, len), null);
    }

    public static ISourceCodeWarning alwaysTrueAssert(int ln, int pos, int len) {
        return new SourceCodeWarning("This assert condition expression is always true", 1008, new SourceCodeLocation(ln, pos, len), null);
    }

    public static ISourceCodeWarning alwaysFalseAssert(int ln, int pos, int len) {
        return new SourceCodeWarning("This assert condition expression is always false", 1009, new SourceCodeLocation(ln, pos, len), null);
    }

    public static ISourceCodeWarning ignoredReturnValue(int ln, int pos, int len, int[][] lnkPos) {
        ISourceCodeLocation[] isc = new ISourceCodeLocation[lnkPos.length];
        for (int i = 0; i < lnkPos.length; ++i) {
            isc[i] = new SourceCodeLocation(lnkPos[i][0], lnkPos[i][1], lnkPos[i][2]);
        }
        return new SourceCodeWarning("The returned value of this FunctionCall is being ignored", 1010, new SourceCodeLocation(ln, pos, len), isc);
    }

    public static ISourceCodeWarning divideByZero(int ln, int pos, int len) {
        return new SourceCodeWarning("Possible Divide-By-Zero detected", 1011, new SourceCodeLocation(ln, pos, len), null);
    }

    public static ISourceCodeWarning moduloByZero(int ln, int pos, int len) {
        return new SourceCodeWarning("Possible Modulo-By-Zero detected", 1012, new SourceCodeLocation(ln, pos, len), null);
    }

    public static ISourceCodeWarning attemptedBasicTypeArrayUsage(int ln, int pos, int len, int[][] lnkPos) {
        ISourceCodeLocation[] isc = new ISourceCodeLocation[lnkPos.length];
        for (int i = 0; i < lnkPos.length; ++i) {
            isc[i] = new SourceCodeLocation(lnkPos[i][0], lnkPos[i][1], lnkPos[i][2]);
        }
        return new SourceCodeWarning("It is possible that this function-call is trying to match a basic-type array against a parameter-type array - java does not allow this.", 1013, new SourceCodeLocation(ln, pos, len), isc);
    }
}

