/*
 * Decompiled with CFR 0.152.
 */
package kenya.types;

import java.util.Map;
import kenya.errors.KenyaInternalError;
import kenya.passes.Util;
import kenya.types.KArrayType;
import kenya.types.KBasicType;
import kenya.types.KBoundClassType;
import kenya.types.KClassType;
import kenya.types.KNullType;
import kenya.types.KParamTypeMapper;
import kenya.types.KType;
import kenya.types.tables.TypeTable;
import minijava.node.Node;

public class KParamType
extends KType {
    private final String _name;
    private Node _node;

    public KParamType(String name, Node declNode) {
        this._name = KParamTypeMapper.get().mapName(name);
        this._node = declNode;
    }

    public KParamType(String name) {
        this._name = KParamTypeMapper.get().mapName(name);
        this._node = null;
    }

    public KParamType(String name, boolean flag) {
        this._name = name;
        this._node = null;
    }

    public Node getNode() {
        if (this._node == null) {
            throw new KenyaInternalError("Getting a null node.");
        }
        return this._node;
    }

    public boolean exactlyMatches(KType kt) {
        if (kt instanceof KParamType) {
            KParamType kpt = (KParamType)kt;
            return kpt._name.equals(this._name);
        }
        return false;
    }

    public KType bind(TypeTable tt) {
        if (tt.containsKey(this)) {
            return tt.lookup(this);
        }
        return this;
    }

    public String getName() {
        return this._name;
    }

    public boolean isTypeMatch(KType kt) {
        return true;
    }

    public int compareAndBind(KType target, TypeTable tt) {
        if (tt.containsKey(this)) {
            KBoundClassType kbct;
            KType kt = tt.lookup(this);
            if (target == KBasicType.getDouble() && Util.isAssignmentCompatible(target, kt)) {
                tt.force(this, KBasicType.getDouble());
            } else if (target == KBasicType.getInt() && Util.isAssignmentCompatible(target, kt)) {
                tt.force(this, KBasicType.getInt());
            }
            if (kt == KBasicType.getDouble() && Util.isAssignmentCompatible(kt, target)) {
                tt.force(this, KBasicType.getDouble());
            } else if (kt == KBasicType.getInt() && Util.isAssignmentCompatible(kt, target)) {
                tt.force(this, KBasicType.getInt());
            }
            if (kt instanceof KBoundClassType) {
                kbct = (KBoundClassType)kt;
                if (kbct.getBase() == KClassType.getDouble() && Util.isAssignmentCompatible(KBasicType.getDouble(), target)) {
                    tt.force(this, kbct);
                } else if (kbct.getBase() == KClassType.getInteger() && Util.isAssignmentCompatible(KBasicType.getInt(), target)) {
                    tt.force(this, kbct);
                }
            }
            if (target instanceof KBoundClassType) {
                kbct = (KBoundClassType)target;
                if (kbct.getBase() == KClassType.getDouble() && Util.isAssignmentCompatible(KBasicType.getDouble(), kt)) {
                    tt.force(this, kbct);
                } else if (kbct.getBase() == KClassType.getInteger() && Util.isAssignmentCompatible(KBasicType.getInt(), kt)) {
                    tt.force(this, kbct);
                }
            }
            if (kt instanceof KParamType) {
                if (((KParamType)kt).exactlyMatches(target)) {
                    return 0;
                }
                return -1;
            }
            int res = kt.compareAndBind(target, tt);
            if (res == -1) {
                return -1;
            }
            if (kt instanceof KArrayType) {
                KArrayType klt = (KArrayType)kt;
                return 1 + klt.getDepth() + res;
            }
            return 1 + res;
        }
        if (target == KNullType.get()) {
            return 1;
        }
        tt.put(this, target);
        return 1;
    }

    public String toString() {
        return KParamTypeMapper.get().lookupName(this._name);
    }

    public boolean isBound(Map paramMap) {
        return paramMap.containsKey(KParamTypeMapper.get().lookupName(this.getName()));
    }

    public void populateParamMap(Map paramMap) {
        paramMap.put(KParamTypeMapper.get().lookupName(this._name), this);
    }
}

