/*
 * Decompiled with CFR 0.152.
 */
package kenya.types.tables;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kenya.errors.SourceCodeException;
import kenya.types.KBasicType;
import kenya.types.KClassType;
import kenya.types.KEnumType;
import kenya.types.KType;
import mediator.IJavaCode;
import minijava.node.AClassDecDeclaration;
import minijava.node.AEnumDecDeclaration;
import minijava.node.PDeclaration;

public class ClassTable {
    private HashMap _classType = new HashMap();
    private HashMap _classNode = new HashMap();
    private HashMap _enumType = new HashMap();
    private HashMap _enumNode = new HashMap();
    private HashMap _basicType = new HashMap();

    public ClassTable() {
        this._basicType.put("int", KBasicType.getInt());
        this._basicType.put("double", KBasicType.getDouble());
        this._basicType.put("char", KBasicType.getChar());
        this._basicType.put("String", KBasicType.getString());
        this._basicType.put("boolean", KBasicType.getString());
        this._basicType.put("void", KBasicType.getVoid());
    }

    public void put(String name, KClassType kt, AClassDecDeclaration node) throws SourceCodeException {
        int[][] lnkPos;
        int len;
        int pos;
        int ln;
        int len1;
        int pos1;
        int ln1;
        AClassDecDeclaration otherNode;
        if (this._basicType.containsKey(name)) {
            int ln2 = node.getIdentifier().getLine();
            int pos2 = node.getIdentifier().getPos();
            int len2 = node.getIdentifier().getText().trim().length();
            SourceCodeException.throwClassConflictBasicType(ln2, pos2, len2, kt);
        }
        if (this._classType.containsKey(name) && (otherNode = (AClassDecDeclaration)this._classNode.get(name)) != null) {
            ln1 = otherNode.getIdentifier().getLine();
            pos1 = otherNode.getIdentifier().getPos();
            len1 = otherNode.getIdentifier().getText().trim().length();
            ln = node.getIdentifier().getLine();
            pos = node.getIdentifier().getPos();
            len = node.getIdentifier().getText().trim().length();
            lnkPos = new int[][]{{ln1, pos1, len1}};
            SourceCodeException.throwDuplicateClassName(ln, pos, len, lnkPos, kt);
        }
        if (this._enumType.containsKey(name)) {
            AEnumDecDeclaration otherNode2 = (AEnumDecDeclaration)this._enumNode.get(name);
            ln1 = otherNode2.getIdentifier().getLine();
            pos1 = otherNode2.getIdentifier().getPos();
            len1 = otherNode2.getIdentifier().getText().trim().length();
            ln = node.getIdentifier().getLine();
            pos = node.getIdentifier().getPos();
            len = node.getIdentifier().getText().trim().length();
            lnkPos = new int[][]{{ln1, pos1, len1}};
            SourceCodeException.throwDuplicateClassEnumName(ln, pos, len, lnkPos, kt);
        }
        this._classType.put(name, kt);
        this._classNode.put(name, node);
    }

    public void put(String name, KEnumType et, AEnumDecDeclaration node) throws SourceCodeException {
        int[][] lnkPos;
        int len;
        int pos;
        int ln;
        int len1;
        int pos1;
        int ln1;
        if (this._basicType.containsKey(name)) {
            int ln2 = node.getIdentifier().getLine();
            int pos2 = node.getIdentifier().getPos();
            int len2 = node.getIdentifier().getText().trim().length();
            SourceCodeException.throwEnumConflictBasicType(ln2, pos2, len2, et);
        }
        if (this._classType.containsKey(name)) {
            AClassDecDeclaration otherNode = (AClassDecDeclaration)this._classNode.get(name);
            ln1 = otherNode.getIdentifier().getLine();
            pos1 = otherNode.getIdentifier().getPos();
            len1 = otherNode.getIdentifier().getText().trim().length();
            ln = node.getIdentifier().getLine();
            pos = node.getIdentifier().getPos();
            len = node.getIdentifier().getText().trim().length();
            lnkPos = new int[][]{{ln1, pos1, len1}};
            SourceCodeException.throwDuplicateEnumClassName(ln, pos, len, lnkPos, et);
        }
        if (this._enumType.containsKey(name)) {
            AEnumDecDeclaration otherNode = (AEnumDecDeclaration)this._enumNode.get(name);
            ln1 = otherNode.getIdentifier().getLine();
            pos1 = otherNode.getIdentifier().getPos();
            len1 = otherNode.getIdentifier().getText().trim().length();
            ln = node.getIdentifier().getLine();
            pos = node.getIdentifier().getPos();
            len = node.getIdentifier().getText().trim().length();
            lnkPos = new int[][]{{ln1, pos1, len1}};
            SourceCodeException.throwDuplicateEnumName(ln, pos, len, lnkPos, et);
        }
        this._enumType.put(name, et);
        this._enumNode.put(name, node);
    }

    public boolean containsMapping(String name) {
        return this._basicType.containsKey(name) || this._classType.containsKey(name) || this._enumType.containsKey(name);
    }

    public boolean isBasicType(String name) {
        return this._basicType.containsKey(name);
    }

    public boolean isEnum(String name) {
        return this._enumType.containsKey(name);
    }

    public boolean isClass(String name) {
        return this._classType.containsKey(name);
    }

    public KType getType(String name) throws NoSuchElementException {
        if (this._basicType.containsKey(name)) {
            return (KType)this._basicType.get(name);
        }
        if (this._classType.containsKey(name)) {
            return (KType)this._classType.get(name);
        }
        if (this._enumType.containsKey(name)) {
            return (KType)this._enumType.get(name);
        }
        throw new NoSuchElementException("Name is not a type that exists.");
    }

    public PDeclaration getNode(String name) throws NoSuchElementException {
        if (this._classNode.containsKey(name)) {
            return (PDeclaration)this._classNode.get(name);
        }
        if (this._enumNode.containsKey(name)) {
            return (PDeclaration)this._enumNode.get(name);
        }
        throw new NoSuchElementException(name + " is not a type that exists with a node.");
    }

    public Iterator getClassIterator() {
        return this._classType.keySet().iterator();
    }

    public Iterator getEnumIterator() {
        return this._enumType.keySet().iterator();
    }

    public String toString() {
        KType kct;
        String name;
        StringBuffer sb = new StringBuffer();
        sb.append("ClassTypes:");
        sb.append(IJavaCode.NEWLINE);
        Iterator it = this._classType.keySet().iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            kct = (KClassType)this._classType.get(name);
            sb.append("\t");
            sb.append(kct);
            if (!it.hasNext()) continue;
            sb.append(";");
            sb.append(IJavaCode.NEWLINE);
        }
        sb.append(IJavaCode.NEWLINE);
        sb.append("EnumTypes:");
        sb.append(IJavaCode.NEWLINE);
        it = this._enumType.keySet().iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            kct = (KEnumType)this._enumType.get(name);
            sb.append("\t");
            sb.append(kct);
            if (!it.hasNext()) continue;
            sb.append(";");
            sb.append(IJavaCode.NEWLINE);
        }
        sb.append(IJavaCode.NEWLINE);
        sb.append("BasicTypes:");
        sb.append(IJavaCode.NEWLINE);
        it = this._basicType.keySet().iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            kct = (KBasicType)this._basicType.get(name);
            sb.append("\t");
            sb.append(kct);
            if (!it.hasNext()) continue;
            sb.append(";");
            sb.append(IJavaCode.NEWLINE);
        }
        return sb.toString();
    }
}

