/*
 * Decompiled with CFR 0.152.
 */
package mediator.stackMachine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kenya.passes.StackMachineBuilder;
import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.interfaces.IVariable;
import mediator.stackMachine.BidirectionalMap;
import mediator.stackMachine.IStackMachineInformationManager;
import mediator.stackMachine.IStackMachineInformationProvider;
import mediator.stackMachine.NameGenerator;
import mediator.stackMachine.StackMachineInformationProvider;
import mediator.util.InformationHolder;
import mediator.util.ValidMainChecker;
import minijava.node.AFuncDecDeclaration;
import org.wellquite.kenya.stackMachine.InterpretedBuildableClosure;
import org.wellquite.kenya.stackMachine.InterpretedClass;
import org.wellquite.kenya.stackMachine.InterpretedEnumeration;
import org.wellquite.kenya.stackMachine.InterpretedMethod;
import org.wellquite.kenya.stackMachine.types.interfaces.IBuildableClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedEnumeration;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;

public class StackMachineInformationManager
implements IStackMachineInformationManager {
    private final NameGenerator _classGen = new NameGenerator("_cls");
    private final NameGenerator _enumGen = new NameGenerator("_enu");
    private final NameGenerator _funcGen = new NameGenerator("_fun");
    private final NameGenerator _varGen = new NameGenerator("_var");
    final BidirectionalMap _classMap = new BidirectionalMap();
    final BidirectionalMap _enumMap = new BidirectionalMap();
    final BidirectionalMap _funcMap = new BidirectionalMap();
    final BidirectionalMap _varMap = new BidirectionalMap();
    final BidirectionalMap _normClassMap = new BidirectionalMap();
    final BidirectionalMap _normEnumMap = new BidirectionalMap();
    final BidirectionalMap _normFuncMap = new BidirectionalMap();
    final BidirectionalMap _normVarMap = new BidirectionalMap();
    final Map _classBodies = new HashMap();
    final Map _funcBodies = new HashMap();
    final Map _enumBodies = new HashMap();
    final Map _funcNodeMap = new HashMap();
    final InformationHolder _ih;
    final IInterpretedClass _globalClass = new InterpretedClass("<GLOBAL>");
    final IBuildableClosure _preInitClosure = new InterpretedBuildableClosure();
    final List _codePoints;

    public StackMachineInformationManager(InformationHolder ih) {
        this._ih = ih;
        this._codePoints = new ArrayList();
        this.addBasicDetails(ih);
    }

    private synchronized void addBasicDetails(InformationHolder ih) {
        String name;
        int i;
        IClass[] classes = ih.getClasses();
        for (i = 0; i < classes.length; ++i) {
            name = this._classGen.getNewName();
            this._classMap.associate(classes[i], name);
            this._normClassMap.associate(classes[i], classes[i].normalise());
            this._classBodies.put(name, new InterpretedClass(name));
            IVariable[] classDecs = classes[i].getDeclarations();
            for (int j = 0; j < classDecs.length; ++j) {
                String smName = this._varGen.getNewName();
                this._varMap.associate(classDecs[j], smName);
                this._normVarMap.associate(classDecs[j], classDecs[j].normalise());
            }
        }
        IClass[] enums = ih.getEnums();
        for (i = 0; i < enums.length; ++i) {
            name = this._enumGen.getNewName();
            this._enumMap.associate(enums[i], name);
            this._normEnumMap.associate(enums[i], enums[i].normalise());
            Object[] kids = enums[i].getEnumConstants();
            this._enumBodies.put(name, new InterpretedEnumeration(name, kids));
        }
        IFunction[] functions = ih.getFunctions();
        for (i = 0; i < functions.length; ++i) {
            name = this._funcGen.getNewName();
            this._funcMap.associate(functions[i], name);
            this._normFuncMap.associate(functions[i], functions[i].normalise());
            this._funcNodeMap.put(functions[i].getDeclarationNode(), functions[i]);
            boolean hasRet = functions[i].getReturnType() != ih.getVoid();
            InterpretedMethod method = new InterpretedMethod(name, this._globalClass, true, hasRet);
            this._funcBodies.put(name, method);
            this._globalClass.addStaticMethod(method);
        }
        IVariable[] vars = ih.getConstants();
        for (i = 0; i < vars.length; ++i) {
            name = this._varGen.getNewName();
            this._varMap.associate(vars[i], name);
            this._normVarMap.associate(vars[i], vars[i].normalise());
        }
    }

    public synchronized String addNewVariable(IVariable var) {
        String name = this._varGen.getNewName();
        this._varMap.associate(var, name);
        this._normVarMap.associate(var, var.normalise());
        return name;
    }

    public synchronized IStackMachineInformationProvider build(ValidMainChecker vmc) {
        StackMachineBuilder smb = new StackMachineBuilder(this, this._ih, true);
        this._ih.getRootNode().apply(smb);
        return new StackMachineInformationProvider(this, vmc);
    }

    public synchronized IInterpretedClass getClassBody(IClass clazz) {
        String name = (String)this._classMap.lookupRHS(clazz);
        return (IInterpretedClass)this._classBodies.get(name);
    }

    public IInterpretedEnumeration getEnumBody(IClass enumm) {
        String name = (String)this._enumMap.lookupRHS(enumm);
        return (IInterpretedEnumeration)this._enumBodies.get(name);
    }

    public synchronized IInterpretedMethod getMethodBody(IFunction func) {
        String name = (String)this._funcMap.lookupRHS(func);
        return (IInterpretedMethod)this._funcBodies.get(name);
    }

    public synchronized String lookupClass(IClass clazz) {
        return (String)this._classMap.lookupRHS(clazz);
    }

    public synchronized String lookupEnum(IClass zenum) {
        return (String)this._enumMap.lookupRHS(zenum);
    }

    public synchronized String lookupFunction(IFunction func) {
        return (String)this._funcMap.lookupRHS(func);
    }

    public synchronized String lookupVariable(IVariable var) {
        return (String)this._varMap.lookupRHS(var);
    }

    public IFunction getFunctionFromNode(AFuncDecDeclaration node) {
        return (IFunction)this._funcNodeMap.get(node);
    }

    public IInterpretedClass getGlobalClassBody() {
        return this._globalClass;
    }

    public IBuildableClosure getPreInitClosure() {
        return this._preInitClosure;
    }

    public void addCodePoint(ISourceCodeLocation iscl) {
        this._codePoints.add(iscl);
    }
}

