/*
 * Decompiled with CFR 0.152.
 */
package mediator.subscription;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import mediator.subscription.ISubscription;
import mediator.subscription.ISubscriptionService;
import mediator.subscription.ISubscriptionTerms;

public class DefaultSubscriptionService
implements ISubscriptionService {
    protected DefaultSubscriptionServiceThread service = new DefaultSubscriptionServiceThread((Runnable)this);
    protected static DefaultSubscriptionService inst;
    protected HashMap subscriptionMap = new HashMap();
    boolean stopRunning = false;

    protected DefaultSubscriptionService() {
    }

    public static DefaultSubscriptionService getInstance() {
        if (inst == null) {
            inst = new DefaultSubscriptionService();
        }
        return inst;
    }

    public synchronized String addSubscription(ISubscription sub) {
        String id = this.generateUniqueID();
        this.subscriptionMap.put(id, sub);
        return id;
    }

    public synchronized ISubscription getSubscription(String id) {
        return (ISubscription)this.subscriptionMap.get(id);
    }

    public synchronized void cancelSubscription(String id) {
        this.subscriptionMap.remove(id);
    }

    public synchronized void provideSubscriptionUpdate() {
        Set ids = this.subscriptionMap.keySet();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            this.provideASyncSubscriptionUpdate((String)it.next());
        }
    }

    public synchronized void provideASyncSubscriptionUpdate(final String id) {
        new Thread(){

            public void run() {
                DefaultSubscriptionService.this.provideSyncSubscriptionUpdate(id);
            }
        }.start();
    }

    public synchronized void provideSyncSubscriptionUpdate(String id) {
        ISubscription sub = this.getSubscription(id);
        if (sub == null) {
            return;
        }
        ISubscriptionTerms[] terms = sub.getSubscriptionTerms();
        for (int i = 0; i < terms.length; ++i) {
            terms[i].executeTerms();
            sub.getSubscriber().subscriptionUpdate(sub.getReturnData());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.stopRunning = false;
        DefaultSubscriptionService defaultSubscriptionService = this;
        synchronized (defaultSubscriptionService) {
            this.service.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        DefaultSubscriptionService defaultSubscriptionService = this;
        synchronized (defaultSubscriptionService) {
            this.stopRunning();
            this.notifyAll();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.subscriptionMap.clear();
            }
        }
    }

    private void stopRunning() {
        this.stopRunning = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DefaultSubscriptionService defaultSubscriptionService;
        while (!this.stopRunning) {
            defaultSubscriptionService = this;
            synchronized (defaultSubscriptionService) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        defaultSubscriptionService = this;
        synchronized (defaultSubscriptionService) {
            this.notifyAll();
        }
    }

    protected String generateUniqueID() {
        String id = "";
        while (id.length() < 10) {
            id = id + (char)(64.0 + Math.random() * 63.0);
        }
        while (this.subscriptionMap.containsKey(id)) {
            char[] i = id.toCharArray();
            int rand = (int)(Math.random() * 10.0);
            i[rand] = (char)(64 + (i[rand] + '\u0001') % 63);
            id = new String(i);
        }
        return id;
    }

    protected class DefaultSubscriptionServiceThread
    extends Thread {
        DefaultSubscriptionServiceThread(Runnable run) {
            super(run);
        }
    }
}

