/*
 * Decompiled with CFR 0.152.
 */
package mediator.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import kenya.KenyaCore;
import mediator.IJavaCode;
import mediator.util.StreamHandler;
import mediator.util.StreamHandlerWatcher;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;

public class JavaCode
implements IJavaCode {
    private final String _imports;
    private final String _constants;
    private final String _functions;
    private final String _classesAndEnums;
    private final Set _typeNames;
    private final Object lock = new Object();
    private Process _lastProcess;
    private boolean recompile = true;
    private String oldClassName = null;
    private String oldFilePath = null;
    private final boolean require15;
    private static final String KEYWORDS = ".Boolean.Double.Character.Integer.String.Object.assert.enum.abstract.default.if.private.this.boolean.do.implements.protected.throw.break.double.import.public.throws.byte.else.instanceof.return.transient.case.extends.int.short.try.catch.final.interface.static.void.char.finally.long.strictfp.volatile.class.float.native.super.while.const.for.new.switch.continue.goto.package.synchronized.";

    public JavaCode(String imports, String constants, String functions, String classesAndEnums, Set typeNames, boolean require15) {
        this._imports = imports;
        this._constants = constants;
        this._functions = functions;
        this._classesAndEnums = classesAndEnums;
        this._typeNames = typeNames;
        this.require15 = require15;
    }

    public Reader getCode(String className) {
        if (!this.isValidClassName(className)) {
            throw new IllegalArgumentException("Bad ClassName: " + className);
        }
        return this.getUncheckedCode(className);
    }

    public Reader getPlaceHeldCode() {
        return this.getUncheckedCode("<global>");
    }

    private Reader getUncheckedCode(String className) {
        String outCode = this._imports + (this._imports.equals("") ? "" : NEWLINE) + "public class " + className + "{" + NEWLINE + this._constants + (this._constants.equals("") ? "" : NEWLINE) + this._functions + NEWLINE + "}" + NEWLINE + this._classesAndEnums;
        return new StringReader(outCode);
    }

    public boolean require15() {
        return this.require15;
    }

    public void killLastProcess() {
        Process lastProcess = this.getLastProcess();
        if (lastProcess != null) {
            lastProcess.destroy();
            boolean finished = false;
            while (!finished) {
                try {
                    lastProcess.waitFor();
                    finished = true;
                }
                catch (InterruptedException e) {}
            }
            try {
                lastProcess.getInputStream().close();
                lastProcess.getErrorStream().close();
                lastProcess.getOutputStream().close();
            }
            catch (IOException e) {
                System.err.println("IOException when closing lastProcess.");
            }
            if (this.getLastProcess() == lastProcess) {
                this.setLastProcess(null);
            }
        }
    }

    public synchronized boolean execute(String filePath, String className, BufferedReader nStdIn, BufferedWriter nStdInWriter, BufferedWriter nStdOut, BufferedWriter nStdErr, String[] args) {
        if (this.oldClassName == null || !this.oldClassName.equals(className) || this.oldFilePath == null || !this.oldFilePath.equals(filePath)) {
            this.setRecompile(true);
            this.oldClassName = className;
            this.oldFilePath = filePath;
        }
        if (this.getLastProcess() != null) {
            throw new IllegalStateException("A process is already running");
        }
        PrintWriter stdErrPW = new PrintWriter(nStdErr);
        String classpath = System.getProperty("java.class.path", ".");
        File classFile = new File(filePath, className + ".java");
        if (!(classFile.exists() && classFile.canRead() && classFile.isFile())) {
            this.setRecompile(true);
        }
        if (this.isRecompile()) {
            if (!this.writeOutFile(filePath, className, stdErrPW)) {
                if (KenyaCore.DEBUG_OUTPUT) {
                    System.err.println("Write out failed.");
                }
                this.setRecompile(true);
                return false;
            }
            if (!this.compile(classpath, filePath, className, nStdOut, nStdErr, stdErrPW)) {
                if (KenyaCore.DEBUG_OUTPUT) {
                    System.err.println("compile failed.");
                }
                this.setRecompile(true);
                return false;
            }
        }
        if (!this.run(filePath, classpath, className, args, nStdOut, nStdErr, nStdIn, nStdInWriter, stdErrPW)) {
            if (KenyaCore.DEBUG_OUTPUT) {
                System.err.println("execute failed.");
            }
            this.setRecompile(true);
            return false;
        }
        this.setRecompile(false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile(String classpath, String filePath, String className, BufferedWriter nStdOut, BufferedWriter nStdErr, PrintWriter stdErrPW) {
        String[] cmdArray;
        if (KenyaCore.DEBUG_OUTPUT) {
            System.out.println(classpath);
        }
        if (this.require15()) {
            cmdArray = new String[]{"javac", "-source", "1.5", "-classpath", classpath, filePath + File.separatorChar + className + ".java"};
            if (KenyaCore.DEBUG_OUTPUT) {
                System.out.println("java 1.5");
            }
        } else {
            cmdArray = new String[]{"javac", "-source", "1.4", "-classpath", classpath, filePath + File.separatorChar + className + ".java"};
            if (KenyaCore.DEBUG_OUTPUT) {
                System.out.println("java 1.4");
            }
        }
        try {
            Process p = Runtime.getRuntime().exec(cmdArray);
            this.setLastProcess(p);
            InputStreamReader stdOutReader = new InputStreamReader(p.getInputStream());
            InputStreamReader stdErrReader = new InputStreamReader(p.getErrorStream());
            StreamHandler stdOutH = new StreamHandler(stdOutReader, nStdOut);
            StreamHandler stdErrH = new StreamHandler(stdErrReader, nStdErr);
            StreamHandlerWatcher shw = new StreamHandlerWatcher();
            shw.addStreamHandler(stdOutH);
            shw.addStreamHandler(stdErrH);
            JobDispatch.enqueueJob(shw);
            JobDispatch.enqueueJob(stdOutH);
            JobDispatch.enqueueJob(stdErrH);
            StreamHandlerWatcher streamHandlerWatcher = shw;
            synchronized (streamHandlerWatcher) {
                while (!shw.isFinished()) {
                    shw.wait();
                }
            }
            int exitValue = p.waitFor();
            this.setLastProcess(null);
            if (KenyaCore.DEBUG_OUTPUT) {
                System.out.println("Javac finished");
            }
            if (exitValue != 0) {
                return false;
            }
        }
        catch (IOException e) {
            stdErrPW.println(e.getMessage());
            return false;
        }
        catch (InterruptedException e) {
            stdErrPW.println(e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean run(String filePath, String classpath, String className, String[] args, BufferedWriter nStdOut, BufferedWriter nStdErr, BufferedReader nStdIn, BufferedWriter nStdInWriter, PrintWriter stdErrPW) {
        String[] cmdArrayPart = new String[]{"java", "-ea", "-cp", filePath + File.separatorChar + File.pathSeparatorChar + classpath, className};
        String[] cmdArray = new String[cmdArrayPart.length + args.length];
        System.arraycopy(cmdArrayPart, 0, cmdArray, 0, cmdArrayPart.length);
        System.arraycopy(args, 0, cmdArray, cmdArrayPart.length, args.length);
        try {
            Process p = Runtime.getRuntime().exec(cmdArray);
            this.setLastProcess(p);
            if (KenyaCore.DEBUG_OUTPUT) {
                System.out.println("Process started.");
            }
            InputStreamReader stdOutReader = new InputStreamReader(p.getInputStream());
            InputStreamReader stdErrReader = new InputStreamReader(p.getErrorStream());
            final OutputStreamWriter stdInWriter = new OutputStreamWriter(p.getOutputStream());
            StreamHandler stdOutH = new StreamHandler(stdOutReader, nStdOut);
            StreamHandler stdErrH = new StreamHandler(stdErrReader, nStdErr);
            final StreamHandler stdInH = new StreamHandler(nStdIn, stdInWriter);
            StreamHandlerWatcher shw = new StreamHandlerWatcher();
            shw.addStreamHandler(stdOutH);
            shw.addStreamHandler(stdErrH);
            shw.addStreamHandler(stdInH);
            JobDispatch.enqueueJob(shw);
            JobDispatch.enqueueJob(stdOutH);
            JobDispatch.enqueueJob(stdErrH);
            JobDispatch.enqueueJob(stdInH);
            JobDispatch.enqueueJob(new AbstractJob(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute() {
                    try {
                        StreamHandler streamHandler = stdInH;
                        synchronized (streamHandler) {
                            while (!stdInH.isFinished()) {
                                stdInH.wait();
                            }
                        }
                        if (KenyaCore.DEBUG_OUTPUT) {
                            System.out.println("stream handler A finished");
                        }
                        stdInWriter.close();
                        if (KenyaCore.DEBUG_OUTPUT) {
                            System.out.println("stream handler AB finished");
                        }
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            });
            int exitValue = p.waitFor();
            this.setLastProcess(null);
            nStdInWriter.flush();
            nStdInWriter.close();
            StreamHandlerWatcher streamHandlerWatcher = shw;
            synchronized (streamHandlerWatcher) {
                while (!shw.isFinished()) {
                    shw.wait();
                }
            }
            if (KenyaCore.DEBUG_OUTPUT) {
                System.err.println("Java Finished");
            }
            if (exitValue != 0) {
                return false;
            }
        }
        catch (IOException e) {
            stdErrPW.println(e.getMessage());
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    private boolean writeOutFile(String filePath, String className, PrintWriter stdErrPW) {
        BufferedReader br;
        PrintWriter fw;
        try {
            String ln;
            fw = new PrintWriter(new FileWriter(new File(filePath, className + ".java")));
            br = new BufferedReader(this.getCode(className));
            while ((ln = br.readLine()) != null) {
                fw.println(ln);
            }
        }
        catch (IOException e) {
            stdErrPW.println(e.getMessage());
            return false;
        }
        fw.close();
        try {
            br.close();
        }
        catch (IOException e) {
            stdErrPW.println(e.getMessage());
            return false;
        }
        return true;
    }

    public boolean isValidClassName(String name) {
        if (name == null) {
            return false;
        }
        if (this._typeNames.contains(name)) {
            return false;
        }
        char[] nameChars = name.toCharArray();
        int nameLength = nameChars.length;
        if (nameLength == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(nameChars[0])) {
            return false;
        }
        boolean identifierStarted = true;
        int identifierStart = 0;
        for (int i = 1; i < nameLength; ++i) {
            char currentChar = nameChars[i];
            if (currentChar == '.') {
                return false;
            }
            if (identifierStarted) {
                if (Character.isJavaIdentifierPart(currentChar)) continue;
                return false;
            }
            if (!Character.isJavaIdentifierStart(currentChar)) {
                return false;
            }
            identifierStart = i;
            identifierStarted = true;
        }
        String maybeKeyword = '.' + name.substring(identifierStart) + '.';
        return KEYWORDS.indexOf(maybeKeyword) == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Process getLastProcess() {
        Object object = this.lock;
        synchronized (object) {
            return this._lastProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastProcess(Process process) {
        Object object = this.lock;
        synchronized (object) {
            if (process != null && this._lastProcess != null) {
                throw new IllegalStateException("A process is already running");
            }
            this._lastProcess = process;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRecompile() {
        Object object = this.lock;
        synchronized (object) {
            return this.recompile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRecompile(boolean recompile) {
        Object object = this.lock;
        synchronized (object) {
            this.recompile = recompile;
        }
    }
}

