/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine;

import java.util.ArrayList;
import java.util.List;
import org.wellquite.kenya.stackMachine.ClosureMiscHelper;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.scope.IClosureScope;
import org.wellquite.kenya.stackMachine.types.AbstractHaltableClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IBuildableClosure;

public class InterpretedBuildableClosure
extends AbstractHaltableClosure
implements IBuildableClosure {
    private final List instructions = new ArrayList();
    private IAtomicClosure currentInstruction = null;

    public synchronized void execute(StackMachine sm) {
        IClosureScope scope = this.getClosureScope();
        if (scope == null) {
            throw new IllegalStateException("Can't execute closure without a scope.");
        }
        for (int idx = 0; idx < this.instructions.size() && !scope.getReturn(); ++idx) {
            this.currentInstruction = (IAtomicClosure)this.instructions.get(idx);
            ClosureMiscHelper.executeClosureInScope(scope, this.currentInstruction, sm);
        }
    }

    public synchronized void addClosure(IAtomicClosure op) {
        if (op == null) {
            throw new RuntimeException("Attempt to add null closure.");
        }
        this.instructions.add(op);
    }

    public synchronized String toString() {
        return "BuildableClosure:\n\t" + this.instructions;
    }
}

