/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClassInstance;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;

public class InterpretedClassInstance
implements IInterpretedClassInstance {
    private final Map methods;
    private final Map mutableVariables;
    private final Map immutableVariables;
    private final IInterpretedClass myClass;

    public InterpretedClassInstance(IInterpretedClass myClass, Map instanceMethods, Map instanceImmutableVariables, Map instanceMutableVariables) {
        this.myClass = myClass;
        this.methods = Collections.unmodifiableMap(instanceMethods);
        this.immutableVariables = Collections.unmodifiableMap(new HashMap(instanceImmutableVariables));
        this.mutableVariables = new HashMap(instanceMutableVariables);
    }

    public synchronized IInterpretedClass getInterpretedClass() {
        return this.myClass;
    }

    public synchronized IInterpretedMethod getMethod(String methodName) {
        if (this.methods.containsKey(methodName)) {
            return (IInterpretedMethod)this.methods.get(methodName);
        }
        return this.myClass.getMethod(methodName);
    }

    public synchronized String toString() {
        return "InterpretedClassInstance of: " + this.getInterpretedClass().getName();
    }

    public synchronized Map getMutableInstanceVariables() {
        return this.mutableVariables;
    }

    public synchronized Map getImmutableInstanceVariables() {
        return this.immutableVariables;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return 0;
    }
}

