/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.ops;

import java.util.ArrayList;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.types.AbstractAtomicClosure;
import org.wellquite.kenya.stackMachine.types.ArrayTypeFactory;
import org.wellquite.kenya.stackMachine.types.IntType;
import org.wellquite.kenya.stackMachine.types.PrimitiveTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IArrayType;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.INumericType;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class ArrayOpsFactory {
    private static final IAtomicClosure get = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            int index = ((INumericType)sm.pop()).getValue().intValue();
            IArrayType array = (IArrayType)sm.pop();
            sm.push(array.get(index));
        }

        public String toString() {
            return "getArrayElement";
        }
    };
    private static final IAtomicClosure set = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            int index = ((INumericType)sm.pop()).getValue().intValue();
            IArrayType array = (IArrayType)sm.pop();
            IType value = sm.pop();
            array.set(index, value);
        }

        public String toString() {
            return "setArrayElement";
        }
    };
    private static final IAtomicClosure getLength = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            IArrayType array = (IArrayType)sm.pop();
            IntType len = PrimitiveTypeFactory.createPrimitiveType(array.getLength());
            sm.push(len);
        }

        public String toString() {
            return "getLengthArray";
        }
    };
    private static final IAtomicClosure buildArrayWithValues = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            INumericType t = (INumericType)sm.pop();
            int length = t.getValue().intValue();
            IType[] ary = new IType[length];
            for (int idx = length - 1; idx >= 0; --idx) {
                ary[idx] = sm.pop();
            }
            sm.push(ArrayTypeFactory.createArrayType(ary, t.getTypeName()));
        }

        public String toString() {
            return "buildArray";
        }
    };
    private static final IAtomicClosure buildMultidimensionalArray = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            IType value = sm.pop();
            int dimensions = ((INumericType)sm.pop()).getValue().intValue();
            if (dimensions < 1) {
                throw new IllegalArgumentException("Can not create an array with " + dimensions + " dimensions.");
            }
            int[] sizes = new int[dimensions];
            for (int idx = dimensions - 1; idx >= 0; --idx) {
                sizes[idx] = ((INumericType)sm.pop()).getValue().intValue();
            }
            int count = 1;
            for (int idx = 0; idx < dimensions; ++idx) {
                count *= sizes[idx];
            }
            ArrayList<IArrayType> holdingPen = new ArrayList<IArrayType>();
            for (int dimIdx = dimensions - 1; dimIdx >= 0; --dimIdx) {
                count /= sizes[dimIdx];
                for (int idx = 0; idx < count; ++idx) {
                    int childrenCount;
                    IArrayType ary = ArrayTypeFactory.createArrayType(new IType[sizes[dimIdx]], value.getTypeName());
                    if (dimIdx == dimensions - 1) {
                        for (childrenCount = 0; childrenCount < sizes[dimIdx]; ++childrenCount) {
                            ary.set(childrenCount, value);
                        }
                    } else {
                        for (childrenCount = 0; childrenCount < sizes[dimIdx]; ++childrenCount) {
                            ary.set(childrenCount, (IType)holdingPen.remove(0));
                        }
                    }
                    holdingPen.add(ary);
                }
            }
            sm.push((IType)holdingPen.remove(0));
            if (!holdingPen.isEmpty()) {
                throw new IllegalStateException("Error occured when creating " + dimensions + "-dimensional array. Holding Pen left with contents: " + holdingPen);
            }
        }

        public String toString() {
            return "buildMultidimensionalArray";
        }
    };

    private ArrayOpsFactory() {
    }

    public static IAtomicClosure get() {
        return get;
    }

    public static IAtomicClosure set() {
        return set;
    }

    public static IAtomicClosure getLength() {
        return getLength;
    }

    public static IAtomicClosure buildArrayWithValues() {
        return buildArrayWithValues;
    }

    public static IAtomicClosure buildMultidimensionalArray() {
        return buildMultidimensionalArray;
    }
}

