/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.ops;

import org.wellquite.kenya.stackMachine.ClosureMiscHelper;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.types.AbstractAtomicClosure;
import org.wellquite.kenya.stackMachine.types.IntType;
import org.wellquite.kenya.stackMachine.types.PrimitiveTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IBooleanType;
import org.wellquite.kenya.stackMachine.types.interfaces.ICharType;
import org.wellquite.kenya.stackMachine.types.interfaces.INumericType;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class LogicalOpsFactory {
    private static final IAtomicClosure lessThan = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            double left = 0.0;
            double right = 0.0;
            IType arg0 = sm.pop();
            IType arg1 = sm.pop();
            if (arg0 instanceof INumericType) {
                left = ((INumericType)arg0).getValue().doubleValue();
            } else if (arg0 instanceof ICharType) {
                left = ((ICharType)arg0).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform < op on arg: " + arg0);
            }
            if (arg1 instanceof INumericType) {
                right = ((INumericType)arg1).getValue().doubleValue();
            } else if (arg1 instanceof ICharType) {
                right = ((ICharType)arg1).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform < op on arg: " + arg1);
            }
            if (left < right) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(true));
            } else {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(false));
            }
        }

        public String toString() {
            return "<";
        }
    };
    private static final IAtomicClosure lessThanEqual = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            double left = 0.0;
            double right = 0.0;
            IType arg0 = sm.pop();
            IType arg1 = sm.pop();
            if (arg0 instanceof INumericType) {
                left = ((INumericType)arg0).getValue().doubleValue();
            } else if (arg0 instanceof ICharType) {
                left = ((ICharType)arg0).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform <= op on arg: " + arg0);
            }
            if (arg1 instanceof INumericType) {
                right = ((INumericType)arg1).getValue().doubleValue();
            } else if (arg1 instanceof ICharType) {
                right = ((ICharType)arg1).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform <= op on arg: " + arg1);
            }
            if (left <= right) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(true));
            } else {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(false));
            }
        }

        public String toString() {
            return "<=";
        }
    };
    private static final IAtomicClosure greaterThan = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            double left = 0.0;
            double right = 0.0;
            IType arg0 = sm.pop();
            IType arg1 = sm.pop();
            if (arg0 instanceof INumericType) {
                left = ((INumericType)arg0).getValue().doubleValue();
            } else if (arg0 instanceof ICharType) {
                left = ((ICharType)arg0).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform > op on arg: " + arg0);
            }
            if (arg1 instanceof INumericType) {
                right = ((INumericType)arg1).getValue().doubleValue();
            } else if (arg1 instanceof ICharType) {
                right = ((ICharType)arg1).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform > op on arg: " + arg1);
            }
            if (left > right) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(true));
            } else {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(false));
            }
        }

        public String toString() {
            return ">";
        }
    };
    private static final IAtomicClosure greaterThanEqual = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            double left = 0.0;
            double right = 0.0;
            IType arg0 = sm.pop();
            IType arg1 = sm.pop();
            if (arg0 instanceof INumericType) {
                left = ((INumericType)arg0).getValue().doubleValue();
            } else if (arg0 instanceof ICharType) {
                left = ((ICharType)arg0).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform >= op on arg: " + arg0);
            }
            if (arg1 instanceof INumericType) {
                right = ((INumericType)arg1).getValue().doubleValue();
            } else if (arg1 instanceof ICharType) {
                right = ((ICharType)arg1).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform >= op on arg: " + arg1);
            }
            if (left >= right) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(true));
            } else {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(false));
            }
        }

        public String toString() {
            return ">=";
        }
    };
    private static final IAtomicClosure equal = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            IType arg1;
            IType arg0 = sm.pop();
            if (arg0.equals(arg1 = sm.pop())) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(true));
            } else {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(false));
            }
        }

        public String toString() {
            return "equal";
        }
    };
    private static final IAtomicClosure notEqual = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            IType arg1;
            IType arg0 = sm.pop();
            if (arg0.equals(arg1 = sm.pop())) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(false));
            } else {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(true));
            }
        }

        public String toString() {
            return "notEqual";
        }
    };
    private static final IAtomicClosure xor = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            IType arg0 = sm.pop();
            IType arg1 = sm.pop();
            if (arg0 instanceof IntType && arg1 instanceof IntType) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(((IntType)arg0).getValue().intValue() ^ ((IntType)arg1).getValue().intValue()));
            } else if (arg0 instanceof IBooleanType && arg1 instanceof IBooleanType) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(((IBooleanType)arg0).getValue() ^ ((IBooleanType)arg1).getValue()));
            } else {
                throw new IllegalArgumentException("Can not perform xor on args: " + arg0 + ", " + arg1);
            }
        }

        public String toString() {
            return "xor";
        }
    };
    private static final IAtomicClosure not = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            boolean arg = ((IBooleanType)sm.pop()).getValue();
            if (arg) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(false));
            } else {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(true));
            }
        }

        public String toString() {
            return "not";
        }
    };

    private LogicalOpsFactory() {
    }

    public static IAtomicClosure lessThan() {
        return lessThan;
    }

    public static IAtomicClosure lessThanEqual() {
        return lessThanEqual;
    }

    public static IAtomicClosure greaterThan() {
        return greaterThan;
    }

    public static IAtomicClosure greaterThanEqual() {
        return greaterThanEqual;
    }

    public static IAtomicClosure equal() {
        return equal;
    }

    public static IAtomicClosure notEqual() {
        return notEqual;
    }

    public static IAtomicClosure and(final IAtomicClosure left, final IAtomicClosure right) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                ClosureMiscHelper.executeClosureInScope(this.getClosureScope(), left, sm);
                IBooleanType leftResult = (IBooleanType)sm.pop();
                if (leftResult.getValue().booleanValue()) {
                    ClosureMiscHelper.executeClosureInScope(this.getClosureScope(), right, sm);
                } else {
                    sm.push(leftResult);
                }
            }

            public String toString() {
                return "and";
            }
        };
    }

    public static IAtomicClosure or(final IAtomicClosure left, final IAtomicClosure right) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                ClosureMiscHelper.executeClosureInScope(this.getClosureScope(), left, sm);
                IBooleanType leftResult = (IBooleanType)sm.pop();
                if (leftResult.getValue().booleanValue()) {
                    sm.push(leftResult);
                } else {
                    ClosureMiscHelper.executeClosureInScope(this.getClosureScope(), right, sm);
                }
            }

            public String toString() {
                return "or";
            }
        };
    }

    public static IAtomicClosure xor() {
        return xor;
    }

    public static IAtomicClosure not() {
        return not;
    }
}

