/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.ops;

import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.types.AbstractAtomicClosure;
import org.wellquite.kenya.stackMachine.types.DoubleType;
import org.wellquite.kenya.stackMachine.types.IntType;
import org.wellquite.kenya.stackMachine.types.PrimitiveTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.ICharType;
import org.wellquite.kenya.stackMachine.types.interfaces.INumericType;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class NumericOpsFactory {
    private static final int INTRESULT = 0;
    private static final int DOUBLERESULT = 1;
    private static final int CHARRESULT = 2;
    private static final IAtomicClosure add = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            IType arg0 = sm.pop();
            IType arg1 = sm.pop();
            int resultType = 0;
            int resultI = 0;
            double resultD = 0.0;
            if (arg0 instanceof INumericType) {
                if (arg0 instanceof IntType) {
                    resultI += ((INumericType)arg0).getValue().intValue();
                    resultD += (double)((INumericType)arg0).getValue().intValue();
                } else if (arg0 instanceof DoubleType) {
                    resultType = 1;
                    resultD += ((INumericType)arg0).getValue().doubleValue();
                }
            } else if (arg0 instanceof ICharType) {
                resultType = 2;
                resultI += ((ICharType)arg0).getValue().charValue();
                resultD += (double)((ICharType)arg0).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform addition on arg0 from stack: " + arg0);
            }
            if (arg1 instanceof INumericType) {
                if (arg1 instanceof IntType) {
                    resultI += ((INumericType)arg1).getValue().intValue();
                    resultD += (double)((INumericType)arg1).getValue().intValue();
                } else if (arg1 instanceof DoubleType) {
                    resultType = 1;
                    resultD += ((INumericType)arg1).getValue().doubleValue();
                }
            } else if (arg1 instanceof ICharType) {
                resultI += ((ICharType)arg1).getValue().charValue();
                resultD += (double)((ICharType)arg1).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform addition on arg1 from stack: " + arg1);
            }
            if (resultType == 0) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(resultI));
            } else if (resultType == 1) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(resultD));
            } else {
                sm.push(PrimitiveTypeFactory.createPrimitiveType((char)resultI));
            }
        }

        public String toString() {
            return "add";
        }
    };
    private static final IAtomicClosure subtract = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            IType arg0 = sm.pop();
            IType arg1 = sm.pop();
            int resultType = 0;
            int resultI = 0;
            double resultD = 0.0;
            if (arg0 instanceof INumericType) {
                if (arg0 instanceof IntType) {
                    resultI += ((INumericType)arg0).getValue().intValue();
                    resultD += (double)((INumericType)arg0).getValue().intValue();
                } else if (arg0 instanceof DoubleType) {
                    resultType = 1;
                    resultD += ((INumericType)arg0).getValue().doubleValue();
                }
            } else if (arg0 instanceof ICharType) {
                resultType = 2;
                resultI += ((ICharType)arg0).getValue().charValue();
                resultD += (double)((ICharType)arg0).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform subtraction on arg0 from stack: " + arg0);
            }
            if (arg1 instanceof INumericType) {
                if (arg1 instanceof IntType) {
                    resultI -= ((INumericType)arg1).getValue().intValue();
                    resultD -= (double)((INumericType)arg1).getValue().intValue();
                } else if (arg1 instanceof DoubleType) {
                    resultType = 1;
                    resultD -= ((INumericType)arg1).getValue().doubleValue();
                }
            } else if (arg1 instanceof ICharType) {
                resultI -= ((ICharType)arg1).getValue().charValue();
                resultD -= (double)((ICharType)arg1).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform subtraction on arg1 from stack: " + arg1);
            }
            if (resultType == 0) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(resultI));
            } else if (resultType == 1) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(resultD));
            } else {
                sm.push(PrimitiveTypeFactory.createPrimitiveType((char)resultI));
            }
        }

        public String toString() {
            return "subtract";
        }
    };
    private static final IAtomicClosure multiply = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            IType arg0 = sm.pop();
            IType arg1 = sm.pop();
            int resultType = 0;
            int resultI = 0;
            double resultD = 0.0;
            if (arg0 instanceof INumericType) {
                if (arg0 instanceof IntType) {
                    resultI += ((INumericType)arg0).getValue().intValue();
                    resultD += (double)((INumericType)arg0).getValue().intValue();
                } else if (arg0 instanceof DoubleType) {
                    resultType = 1;
                    resultD += ((INumericType)arg0).getValue().doubleValue();
                }
            } else if (arg0 instanceof ICharType) {
                resultType = 2;
                resultI += ((ICharType)arg0).getValue().charValue();
                resultD += (double)((ICharType)arg0).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform multiplication on arg0 from stack: " + arg0);
            }
            if (arg1 instanceof INumericType) {
                if (arg1 instanceof IntType) {
                    resultI *= ((INumericType)arg1).getValue().intValue();
                    resultD *= (double)((INumericType)arg1).getValue().intValue();
                } else if (arg1 instanceof DoubleType) {
                    resultType = 1;
                    resultD *= ((INumericType)arg1).getValue().doubleValue();
                }
            } else if (arg1 instanceof ICharType) {
                resultI *= ((ICharType)arg1).getValue().charValue();
                resultD *= (double)((ICharType)arg1).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform multiplication on arg1 from stack: " + arg1);
            }
            if (resultType == 0) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(resultI));
            } else if (resultType == 1) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(resultD));
            } else {
                sm.push(PrimitiveTypeFactory.createPrimitiveType((char)resultI));
            }
        }

        public String toString() {
            return "multiply";
        }
    };
    private static final IAtomicClosure divide = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            IType arg0 = sm.pop();
            IType arg1 = sm.pop();
            int resultType = 0;
            int resultI = 0;
            double resultD = 0.0;
            if (arg0 instanceof INumericType) {
                if (arg0 instanceof IntType) {
                    resultI += ((INumericType)arg0).getValue().intValue();
                    resultD += (double)((INumericType)arg0).getValue().intValue();
                } else if (arg0 instanceof DoubleType) {
                    resultType = 1;
                    resultD += ((INumericType)arg0).getValue().doubleValue();
                }
            } else if (arg0 instanceof ICharType) {
                resultType = 2;
                resultI += ((ICharType)arg0).getValue().charValue();
                resultD += (double)((ICharType)arg0).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform division on arg0 from stack: " + arg0);
            }
            if (arg1 instanceof INumericType) {
                if (arg1 instanceof IntType) {
                    resultI /= ((INumericType)arg1).getValue().intValue();
                    resultD /= (double)((INumericType)arg1).getValue().intValue();
                } else if (arg1 instanceof DoubleType) {
                    resultType = 1;
                    resultD /= ((INumericType)arg1).getValue().doubleValue();
                }
            } else if (arg1 instanceof ICharType) {
                resultI /= ((ICharType)arg1).getValue().charValue();
                resultD /= (double)((ICharType)arg1).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform division on arg1 from stack: " + arg1);
            }
            if (resultType == 0) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(resultI));
            } else if (resultType == 1) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(resultD));
            } else {
                sm.push(PrimitiveTypeFactory.createPrimitiveType((char)resultI));
            }
        }

        public String toString() {
            return "divide";
        }
    };
    private static final IAtomicClosure modulus = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            IType arg0 = sm.pop();
            IType arg1 = sm.pop();
            int resultType = 0;
            int resultI = 0;
            double resultD = 0.0;
            if (arg0 instanceof INumericType) {
                if (arg0 instanceof IntType) {
                    resultI += ((INumericType)arg0).getValue().intValue();
                    resultD += (double)((INumericType)arg0).getValue().intValue();
                } else if (arg0 instanceof DoubleType) {
                    resultType = 1;
                    resultD += ((INumericType)arg0).getValue().doubleValue();
                }
            } else if (arg0 instanceof ICharType) {
                resultType = 2;
                resultI += ((ICharType)arg0).getValue().charValue();
                resultD += (double)((ICharType)arg0).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform modulus on arg0 from stack: " + arg0);
            }
            if (arg1 instanceof INumericType) {
                if (arg1 instanceof IntType) {
                    resultI %= ((INumericType)arg1).getValue().intValue();
                    resultD %= (double)((INumericType)arg1).getValue().intValue();
                } else if (arg1 instanceof DoubleType) {
                    resultType = 1;
                    resultD %= ((INumericType)arg1).getValue().doubleValue();
                }
            } else if (arg1 instanceof ICharType) {
                resultI %= ((ICharType)arg1).getValue().charValue();
                resultD %= (double)((ICharType)arg1).getValue().charValue();
            } else {
                throw new IllegalArgumentException("Can not perform modulus on arg1 from stack: " + arg1);
            }
            if (resultType == 0) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(resultI));
            } else if (resultType == 1) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(resultD));
            } else {
                sm.push(PrimitiveTypeFactory.createPrimitiveType((char)resultI));
            }
        }

        public String toString() {
            return "modulus";
        }
    };
    private static final IAtomicClosure inc = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            IType arg0 = sm.pop();
            if (arg0 instanceof INumericType) {
                if (arg0 instanceof IntType) {
                    sm.push(PrimitiveTypeFactory.createPrimitiveType(((INumericType)arg0).getValue().intValue() + 1));
                } else {
                    sm.push(PrimitiveTypeFactory.createPrimitiveType(((INumericType)arg0).getValue().doubleValue() + 1.0));
                }
            } else if (arg0 instanceof ICharType) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(((ICharType)arg0).getValue().charValue() + '\u0001'));
            } else {
                throw new IllegalArgumentException("Unable to perform inc operation on arg: " + arg0);
            }
        }

        public String toString() {
            return "inc";
        }
    };
    private static final IAtomicClosure dec = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            IType arg0 = sm.pop();
            if (arg0 instanceof INumericType) {
                if (arg0 instanceof IntType) {
                    sm.push(PrimitiveTypeFactory.createPrimitiveType(((INumericType)arg0).getValue().intValue() - 1));
                } else {
                    sm.push(PrimitiveTypeFactory.createPrimitiveType(((INumericType)arg0).getValue().doubleValue() - 1.0));
                }
            } else if (arg0 instanceof ICharType) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(((ICharType)arg0).getValue().charValue() - '\u0001'));
            } else {
                throw new IllegalArgumentException("Unable to perform dec operation on arg: " + arg0);
            }
        }

        public String toString() {
            return "dec";
        }
    };

    private NumericOpsFactory() {
    }

    public static IAtomicClosure add() {
        return add;
    }

    public static IAtomicClosure subtract() {
        return subtract;
    }

    public static IAtomicClosure multiply() {
        return multiply;
    }

    public static IAtomicClosure divide() {
        return divide;
    }

    public static IAtomicClosure modulus() {
        return modulus;
    }

    public static IAtomicClosure inc() {
        return inc;
    }

    public static IAtomicClosure dec() {
        return dec;
    }
}

