/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.ops;

import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.types.AbstractAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassInstanceType;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassStaticType;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClassInstance;
import org.wellquite.kenya.stackMachine.types.interfaces.INullType;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class StackOpsFactory {
    private static final IAtomicClosure pop = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            sm.pop();
        }

        public String toString() {
            return "pop";
        }
    };
    private static final IAtomicClosure print = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            sm.printStackPeek();
        }

        public String toString() {
            return "print";
        }
    };
    private static final IAtomicClosure println = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            sm.printlnStackPeek();
        }

        public String toString() {
            return "println";
        }
    };
    private static final IAtomicClosure startNewVariableScope = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            sm.getMethodScope().startNewVariableClosure();
        }

        public String toString() {
            return "startNewVariableScope";
        }
    };
    private static final IAtomicClosure endNewVariableScope = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            sm.getMethodScope().endNewVariableClosure();
        }

        public String toString() {
            return "endNewVariableScope";
        }
    };

    private StackOpsFactory() {
    }

    public static IAtomicClosure startNewVariableScope() {
        return startNewVariableScope;
    }

    public static IAtomicClosure endNewVariableScope() {
        return endNewVariableScope;
    }

    public static IAtomicClosure pop() {
        return pop;
    }

    public static IAtomicClosure printStackPeek() {
        return print;
    }

    public static IAtomicClosure printlnStackPeek() {
        return println;
    }

    public static IAtomicClosure push(final IType object) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                sm.push(object);
            }

            public String toString() {
                return "push: " + object;
            }
        };
    }

    public static IAtomicClosure fetch(final String varName) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                sm.push(sm.getMethodScope().fetchVariable(varName));
            }

            public String toString() {
                return "fetch: " + varName;
            }
        };
    }

    public static IAtomicClosure fetchFromClassStatic(final String varName) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                IInterpretedClass theClass = ((IClassStaticType)sm.pop()).getValue();
                sm.push(sm.getMethodScope().fetchVariable(theClass, varName));
            }

            public String toString() {
                return "fetchFromClassStatic: " + varName;
            }
        };
    }

    public static IAtomicClosure fetchFromClassInstance(final String varName) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                IInterpretedClassInstance theClassInstance = ((IClassInstanceType)sm.pop()).getValue();
                sm.push(sm.getMethodScope().fetchVariable(theClassInstance, varName));
            }

            public String toString() {
                return "fetchFromClassInstance: " + varName;
            }
        };
    }

    public static IAtomicClosure storeNewVariable(final String varName, final boolean mutable) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                IType value = sm.pop();
                sm.getMethodScope().storeNewVariable(varName, value, mutable);
            }

            public String toString() {
                return "storeNewVariable: " + varName + ", mutable: " + mutable;
            }
        };
    }

    public static IAtomicClosure store(final String varName) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                IType value = sm.pop();
                sm.getMethodScope().updateVariable(varName, value);
            }

            public String toString() {
                return "store: " + varName;
            }
        };
    }

    public static IAtomicClosure storeInClassStatic(final String varName) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                IType value = sm.pop();
                IInterpretedClass theClass = ((IClassStaticType)sm.pop()).getValue();
                sm.getMethodScope().updateVariable(theClass, varName, value);
            }

            public String toString() {
                return "storeInClassStatic: " + varName;
            }
        };
    }

    public static IAtomicClosure storeInClassInstance(final String varName) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                IType value = sm.pop();
                IType inst = sm.pop();
                if (inst instanceof INullType) {
                    throw new NullPointerException();
                }
                IInterpretedClassInstance theClassInstance = ((IClassInstanceType)inst).getValue();
                sm.getMethodScope().updateVariable(theClassInstance, varName, value);
            }

            public String toString() {
                return "storeInClassInstance: " + varName;
            }
        };
    }

    public static IAtomicClosure declareStaticImmutable(final String varName) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                IType value = sm.pop();
                IInterpretedClass theClass = ((IClassStaticType)sm.pop()).getValue();
                sm.getMethodScope().declareImmutableVariable(theClass, varName, value);
            }

            public String toString() {
                return "declareStaticImmutable: " + varName;
            }
        };
    }

    public static IAtomicClosure declareClassImmutable(final String varName) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                IType value = sm.pop();
                IInterpretedClassInstance theClassInstance = ((IClassInstanceType)sm.pop()).getValue();
                sm.getMethodScope().declareImmutableVariable(theClassInstance, varName, value);
            }

            public String toString() {
                return "declareClassImmutable: " + varName;
            }
        };
    }

    public static IAtomicClosure invokeLocalMethod(final String methodName) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                sm.invokeMethod(methodName);
            }

            public String toString() {
                return "invokeLocalMethod: " + methodName;
            }
        };
    }

    public static IAtomicClosure invokeForeignStaticMethod(final String methodName) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                IInterpretedClass theClass = ((IClassStaticType)sm.pop()).getValue();
                sm.invokeMethod(theClass, methodName);
            }

            public String toString() {
                return "invokedForeignStaticMethod: " + methodName;
            }
        };
    }

    public static IAtomicClosure invokeForeignInstanceMethod(final String methodName) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                IInterpretedClassInstance theClassInstance = ((IClassInstanceType)sm.pop()).getValue();
                sm.invokeMethod(theClassInstance, methodName);
            }

            public String toString() {
                return "invokeForeignInstanceMethod: " + methodName;
            }
        };
    }

    public static IAtomicClosure positionReached(final Object data) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                sm.positionReached(data);
            }

            public String toString() {
                return "positionReached";
            }
        };
    }

    public static IAtomicClosure reverseStackTop(final int count) {
        return new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                int idx;
                IType[] ary = new IType[count];
                for (idx = 0; idx < count; ++idx) {
                    ary[idx] = sm.pop();
                }
                for (idx = 0; idx < count; ++idx) {
                    sm.push(ary[idx]);
                    ary[idx] = null;
                }
            }

            public String toString() {
                return "Reverse top " + count + " items on stack";
            }
        };
    }
}

