/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.scope;

import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.scope.IMethodScope;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClassInstance;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class MethodScope
implements IMethodScope {
    private IMethodScope previousScope = null;
    private IInterpretedMethod method = null;
    private final Stack localMutableVariableStack = new Stack();
    private final Stack localImmutableVariableStack = new Stack();
    private volatile Map localMutableVariables = new TreeMap();
    private volatile Map localImmutableVariables = new TreeMap();
    private IInterpretedClassInstance myClass = null;

    public MethodScope() {
    }

    public MethodScope(IInterpretedMethod targetMethod, IInterpretedClass targetClass) {
        if (!targetMethod.isStatic() || !targetMethod.getInterpretedClass().equals(targetClass)) {
            throw new RuntimeException("Attempt made to create scope with non static method and static class: " + targetMethod + ", " + targetClass);
        }
        this.method = targetMethod;
        this.myClass = null;
    }

    public MethodScope(IInterpretedMethod targetMethod, IInterpretedClassInstance targetClassInstance) {
        this.method = targetMethod;
        this.myClass = this.method.isStatic() ? null : targetClassInstance;
    }

    public synchronized IMethodScope getPreviousScope() {
        return this.previousScope;
    }

    public synchronized void setPreviousScope(IMethodScope previousScope) {
        this.previousScope = previousScope;
    }

    public synchronized void setMethod(IInterpretedMethod method) {
        if (this.method != null) {
            throw new RuntimeException("Attempt made to set scope method to '" + method + "' when scope method already set to '" + this.method + "'");
        }
        this.method = method;
    }

    public synchronized IInterpretedMethod getCurrentMethod() {
        return this.method;
    }

    public synchronized void storeNewVariable(String name, IType value, boolean mutable) {
        if (mutable) {
            this.localMutableVariables.put(name, value);
        } else {
            this.localImmutableVariables.put(name, value);
        }
    }

    public synchronized void updateVariable(String name, IType value) {
        Map found = null;
        if (this.localMutableVariables.containsKey(name)) {
            this.localMutableVariables.put(name, value);
            return;
        }
        for (int idx = this.localMutableVariableStack.size() - 1; idx >= 0; --idx) {
            Map variableMap = (Map)this.localMutableVariableStack.get(idx);
            if (!variableMap.containsKey(name)) continue;
            variableMap.put(name, value);
            return;
        }
        if (this.method.getMutableMethodVariables().containsKey(name)) {
            found = this.method.getMutableMethodVariables();
        } else if (!this.method.isStatic() && this.myClass.getMutableInstanceVariables().containsKey(name)) {
            found = this.myClass.getMutableInstanceVariables();
        }
        if (found == null && this.method.getInterpretedClass().getMutableStaticVariables().containsKey(name)) {
            found = this.method.getInterpretedClass().getMutableStaticVariables();
        }
        if (found == null) {
            this.noSuchVariable(name);
        }
        found.put(name, value);
    }

    public synchronized void updateVariable(IInterpretedClass targetClass, String name, IType value) {
        if (targetClass.getMutableStaticVariables().containsKey(name)) {
            targetClass.getMutableStaticVariables().put(name, value);
        } else {
            this.noSuchVariable(targetClass, name);
        }
    }

    public synchronized void updateVariable(IInterpretedClassInstance targetClassInstance, String name, IType value) {
        if (targetClassInstance.getMutableInstanceVariables().containsKey(name)) {
            targetClassInstance.getMutableInstanceVariables().put(name, value);
        } else {
            this.updateVariable(targetClassInstance.getInterpretedClass(), name, value);
        }
    }

    public synchronized IType fetchVariable(String name) {
        Map variableMap;
        int idx;
        if (this.localMutableVariables.containsKey(name)) {
            return (IType)this.localMutableVariables.get(name);
        }
        for (idx = this.localMutableVariableStack.size() - 1; idx >= 0; --idx) {
            variableMap = (Map)this.localMutableVariableStack.get(idx);
            if (!variableMap.containsKey(name)) continue;
            return (IType)variableMap.get(name);
        }
        if (this.localImmutableVariables.containsKey(name)) {
            return (IType)this.localImmutableVariables.get(name);
        }
        for (idx = this.localImmutableVariableStack.size() - 1; idx >= 0; --idx) {
            variableMap = (Map)this.localImmutableVariableStack.get(idx);
            if (!variableMap.containsKey(name)) continue;
            return (IType)variableMap.get(name);
        }
        if (this.method.isStatic()) {
            return this.fetchVariable(this.method.getInterpretedClass(), name);
        }
        return this.fetchVariable(this.myClass, name);
    }

    public synchronized IType fetchVariable(IInterpretedClass targetClass, String name) {
        if (targetClass.getMutableStaticVariables().containsKey(name)) {
            return (IType)targetClass.getMutableStaticVariables().get(name);
        }
        if (targetClass.getImmutableStaticVariables().containsKey(name)) {
            return (IType)targetClass.getImmutableStaticVariables().get(name);
        }
        this.noSuchVariable(targetClass, name);
        return null;
    }

    public synchronized IType fetchVariable(IInterpretedClassInstance targetClass, String name) {
        if (targetClass.getMutableInstanceVariables().containsKey(name)) {
            return (IType)targetClass.getMutableInstanceVariables().get(name);
        }
        if (targetClass.getImmutableInstanceVariables().containsKey(name)) {
            return (IType)targetClass.getImmutableInstanceVariables().get(name);
        }
        return this.fetchVariable(targetClass.getInterpretedClass(), name);
    }

    private void noSuchVariable(String name) {
        throw new RuntimeException("Unable to find variable '" + name + "' in method " + this.method);
    }

    private void noSuchVariable(IInterpretedClass targetClass, String name) {
        throw new RuntimeException("Unable to find variable '" + name + "' in class " + targetClass);
    }

    public synchronized void setClassInstance(IInterpretedClassInstance newClass) {
        if (!this.method.isStatic()) {
            this.myClass = newClass;
        }
    }

    public synchronized IInterpretedClassInstance getCurrentClassInstance() {
        return this.myClass;
    }

    public synchronized boolean isStatic() {
        if (this.method == null) {
            return true;
        }
        return this.method.isStatic();
    }

    public synchronized void setClass(IInterpretedClass newClass) {
        if (!this.method.isStatic()) {
            throw new RuntimeException("Attempt made to set scope to static class context '" + newClass + "' but method is not static.");
        }
        this.myClass = null;
    }

    public synchronized IInterpretedClass getCurrentClass() {
        if (this.method == null) {
            return null;
        }
        return this.method.getInterpretedClass();
    }

    public synchronized void switchToNewScope(IMethodScope newScope, StackMachine sm) {
        newScope.setPreviousScope(sm.getMethodScope());
        sm.setMethodScope(newScope);
    }

    public synchronized void switchToPreviousScope(StackMachine sm) {
        if (sm.getMethodScope() == null) {
            throw new RuntimeException("Unable to switch to non-existant previous scope.");
        }
        sm.setMethodScope(this.getPreviousScope());
        this.method = null;
        this.previousScope = null;
        this.myClass = null;
        this.localMutableVariables.clear();
        this.localImmutableVariables.clear();
        this.localMutableVariableStack.clear();
        this.localImmutableVariableStack.clear();
    }

    public synchronized void declareImmutableVariable(IInterpretedClass targetClass, String name, IType value) {
        if (targetClass.getImmutableStaticVariables().containsKey(name) || targetClass.getMutableStaticVariables().containsKey(name)) {
            throw new RuntimeException("Unable to declare immutable variable " + name + " in class " + targetClass + " as variable already exists.");
        }
        targetClass.addImmutableStaticVariable(name, value);
    }

    public synchronized void declareImmutableVariable(IInterpretedClassInstance targetClassInstance, String name, IType value) {
        if (targetClassInstance.getImmutableInstanceVariables().containsKey(name) || targetClassInstance.getMutableInstanceVariables().containsKey(name) || targetClassInstance.getInterpretedClass().getImmutableStaticVariables().containsKey(name) || targetClassInstance.getInterpretedClass().getMutableStaticVariables().containsKey(name)) {
            throw new RuntimeException("Unable to declare immutable variable " + name + " in class instance " + targetClassInstance + " as variable already exists.");
        }
        targetClassInstance.getInterpretedClass().addImmutableInstanceVariable(name, value);
    }

    public synchronized Map getLocalMutableVariables() {
        TreeMap variableMap = new TreeMap(this.localMutableVariables);
        for (int idx = this.localMutableVariableStack.size() - 1; idx >= 0; --idx) {
            variableMap.putAll((Map)this.localMutableVariableStack.get(idx));
        }
        return variableMap;
    }

    public synchronized Map getLocalImmutableVariables() {
        TreeMap variableMap = new TreeMap(this.localImmutableVariables);
        for (int idx = this.localImmutableVariableStack.size() - 1; idx >= 0; --idx) {
            variableMap.putAll((Map)this.localImmutableVariableStack.get(idx));
        }
        return variableMap;
    }

    public synchronized void startNewVariableClosure() {
        this.localImmutableVariableStack.push(this.localImmutableVariables);
        this.localImmutableVariables = new TreeMap();
        this.localMutableVariableStack.push(this.localMutableVariables);
        this.localMutableVariables = new TreeMap();
    }

    public synchronized void endNewVariableClosure() {
        this.localMutableVariables.clear();
        this.localImmutableVariables.clear();
        this.localMutableVariables = (Map)this.localMutableVariableStack.pop();
        this.localImmutableVariables = (Map)this.localImmutableVariableStack.pop();
    }
}

