/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.types;

import org.wellquite.kenya.stackMachine.types.interfaces.IArrayType;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class ArrayType
implements IArrayType {
    private static final String NULLNAME = "null";
    private IType[] value = null;
    private final String declaredType;
    private boolean assigned = false;

    public ArrayType(String expectedType) {
        this.declaredType = expectedType;
    }

    public ArrayType(IType[] array, String expectedType) {
        this(expectedType);
        this.setValue(array);
    }

    public final synchronized void setValue(IType[] value) {
        if (this.assigned && value != null) {
            ArrayType.illegalAssignmentError(this);
        }
        this.value = value;
        this.assigned = true;
    }

    public final synchronized IType[] getValue() {
        return this.value;
    }

    public synchronized String toString() {
        return "ArrayType: " + this.value;
    }

    private static void illegalAssignmentError(ArrayType variable) {
        throw new RuntimeException("Attempt made to change value of type " + variable);
    }

    public synchronized boolean valueSet() {
        return this.assigned;
    }

    public String valueToString() {
        if (this.value == null) {
            return NULLNAME;
        }
        StringBuffer out = new StringBuffer();
        for (int idx = 0; idx < this.value.length; ++idx) {
            out.append(", ");
            if (this.value[idx] == null) {
                out.append(NULLNAME);
                continue;
            }
            out.append(this.value[idx].valueToString());
        }
        String result = "[Array of length " + this.value.length + ": ";
        if (out.length() > 0) {
            result = result + out.toString().substring(2);
        }
        result = result + "]";
        return result;
    }

    public int getLength() {
        return this.getValue() == null ? 0 : this.getValue().length;
    }

    public IType get(int index) {
        if (this.getValue() == null) {
            return null;
        }
        if (index >= this.getValue().length || index < 0) {
            throw new IndexOutOfBoundsException("Attempt to access element " + index + " in array of length " + this.getLength());
        }
        return this.getValue()[index];
    }

    public void set(int index, IType newValue) {
        if (this.getValue() == null) {
            return;
        }
        if (index >= this.getValue().length || index < 0) {
            throw new IndexOutOfBoundsException("Attempt to access element " + index + " in array of length " + this.getLength());
        }
        this.getValue()[index] = newValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IArrayType) {
            return ((IArrayType)obj).getValue().equals(this.getValue());
        }
        return false;
    }

    public int hashCode() {
        if (this.getValue() == null) {
            return NULLNAME.hashCode();
        }
        return this.getValue().hashCode();
    }

    public String getTypeName() {
        return this.declaredType + "[]";
    }

    public Object clone() throws CloneNotSupportedException {
        ArrayType t = (ArrayType)super.clone();
        return t;
    }
}

