/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.types;

import org.wellquite.kenya.stackMachine.types.interfaces.IClassInstanceType;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClassInstance;

public class ClassInstanceType
implements IClassInstanceType {
    private static final String nullName = ":instance";
    private IInterpretedClassInstance value = null;
    private boolean assigned = false;

    public ClassInstanceType() {
    }

    public ClassInstanceType(IInterpretedClassInstance value) {
        this.value = value;
        this.assigned = true;
    }

    public synchronized IInterpretedClassInstance getValue() {
        return this.value;
    }

    public synchronized void setValue(IInterpretedClassInstance value) {
        if (this.assigned && this.value != null) {
            ClassInstanceType.modificationError(this);
        } else {
            this.value = value;
            this.assigned = true;
        }
    }

    public synchronized String toString() {
        return "ClassInstanceType: " + this.value;
    }

    public synchronized boolean valueSet() {
        return this.assigned && this.value != null;
    }

    public String getValueClassName() {
        if (this.getValue() == null) {
            return nullName;
        }
        return this.getValue().getInterpretedClass().getName() + nullName;
    }

    private static void modificationError(ClassInstanceType variable) {
        throw new RuntimeException("Attempt made to modify String variable: " + variable);
    }

    public String valueToString() {
        return this.getValue().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IClassInstanceType) {
            return ((IClassInstanceType)obj).getValue().equals(this.getValue());
        }
        return false;
    }

    public int hashCode() {
        if (this.getValue() == null) {
            return nullName.hashCode();
        }
        return this.getValue().hashCode();
    }

    public String getTypeName() {
        return this.value.getInterpretedClass().getName();
    }

    public Object clone() throws CloneNotSupportedException {
        ClassInstanceType t = (ClassInstanceType)super.clone();
        return t;
    }
}

