/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse;

import java.util.Arrays;
import kenya.eclipse.KenyaConstants;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class KenyaConventions
implements KenyaConstants {
    public static final String[] KENYA_KEYWORDS = new String[]{"class", "const", "if", "else", "while", "return", "switch", "case", "break", "default", "for", "assert", "new", "enum"};
    public static final String[] KENYA_TYPES = new String[]{"boolean", "char", "int", "double", "String", "void"};
    public static final String[] KENYA_CONSTANTS = new String[]{"false", "null", "true"};
    private static final String[] jkKeyWords;

    static {
        String[] javaReserved = new String[]{"abstract", "byte", "catch", "continue", "do", "extends", "final", "finally", "float", "implements", "import", "instanceof", "interface", "long", "native", "package", "private", "protected", "public", "short", "static", "super", "synchronized", "this", "throw", "throws", "transient", "try", "volatile"};
        int length = javaReserved.length + KENYA_KEYWORDS.length + KENYA_TYPES.length + KENYA_CONSTANTS.length;
        Object[] reserved = new String[length];
        int offset = 0;
        System.arraycopy(javaReserved, 0, reserved, offset, javaReserved.length);
        System.arraycopy(KENYA_KEYWORDS, 0, reserved, offset += javaReserved.length, KENYA_KEYWORDS.length);
        System.arraycopy(KENYA_TYPES, 0, reserved, offset += KENYA_KEYWORDS.length, KENYA_TYPES.length);
        System.arraycopy(KENYA_CONSTANTS, 0, reserved, offset += KENYA_TYPES.length, KENYA_CONSTANTS.length);
        Arrays.sort(reserved);
        jkKeyWords = reserved;
    }

    private KenyaConventions() {
    }

    public static boolean clashesWithReservedWord(String id) {
        int s = Arrays.binarySearch(jkKeyWords, id);
        return s >= 0;
    }

    private static boolean containsIllegalCharacters(String id) {
        return !id.matches("[a-zA-Z_$][a-zA-Z_0-9$]*");
    }

    public static IStatus validateKenyaTypeName(String name) {
        if (name == null || name.length() == 0) {
            return new Status(4, "kenya.eclipse", -1, "Type name is empty", null);
        }
        String trimmed = name.trim();
        if (!name.equals(trimmed)) {
            return new Status(4, "kenya.eclipse", -1, "Type name is not valid. A Kenya/Java type name must not start or end with a blank", null);
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            if (KenyaConventions.clashesWithReservedWord(name)) {
                return new Status(4, "kenya.eclipse", -1, "Type name is not valid. The type name '" + name + "' clashes with a" + " reserved keyword or operator" + " in either Kenya or Java", null);
            }
            if (KenyaConventions.containsIllegalCharacters(name)) {
                return new Status(4, "kenya.eclipse", -1, "Type name is not valid. The type name '" + name + "' is not a valid Kenya/Java identifier", null);
            }
            if (Character.isDigit(name.charAt(0))) {
                return new Status(4, "kenya.eclipse", -1, "Type name is not valid. Identifiers cannot start with a digit.", null);
            }
        } else {
            return new Status(4, "kenya.eclipse", -1, "There is no need to specify a file extension. Kenya type names also must not contain any dots", null);
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (!status.isOK()) {
            return status;
        }
        if (name.indexOf(36) >= 0) {
            return new Status(2, "kenya.eclipse", -1, "Type name is discouraged. By convention, Kenya/Java type names usually don't contain the $ character", null);
        }
        if (name.length() > 0 && Character.isLowerCase(name.charAt(0))) {
            return new Status(2, "kenya.eclipse", -1, "Type name is discouraged. By convention, Kenya/Java type names usually start with an uppercase letter", null);
        }
        return new Status(0, "kenya.eclipse", 0, "", null);
    }
}

