/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kenya.eclipse.buildext.IKenyaPostBuildAnalyserFactory;
import kenya.eclipse.debug.KenyaRunner;
import kenya.eclipse.multieditor.java.util.JavaCodeScanner;
import kenya.eclipse.multieditor.kenya.KenyaPartitionScanner;
import kenya.eclipse.multieditor.kenya.util.KenyaCodeScanner;
import kenya.eclipse.multieditor.util.DefaultSyntaxColorProvider;
import kenya.eclipse.multieditor.util.KenyaColourManager;
import kenya.eclipse.preferences.PreferenceConstants;
import mediator.subscription.MediationService;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.framework.BundleContext;

public class KenyaPlugin
extends AbstractUIPlugin {
    private static KenyaPlugin fgInstance;
    private ResourceBundle resourceBundle;
    private IPreferenceStore fCombinedPreferenceStore;
    private DefaultSyntaxColorProvider fColorProvider;
    private KenyaPartitionScanner fPartitionScanner;
    private KenyaCodeScanner fCodeScanner;
    private JavaCodeScanner fjCodeScanner;
    private KenyaRunner fKenyaRunner;
    protected Map fPostBuildAnalyserMap;
    private KenyaColourManager fColourManager;

    public KenyaPlugin() {
        fgInstance = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("kenya.eclipse.KenyaPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        MediationService.getInstance().start();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        MediationService.getInstance().shutdown();
    }

    public static KenyaPlugin getDefault() {
        return fgInstance;
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), generalTextStore});
        }
        return this.fCombinedPreferenceStore;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        EditorsUI.useAnnotationsPreferencePage((IPreferenceStore)store);
        EditorsUI.useQuickDiffPreferencePage((IPreferenceStore)store);
        PreferenceConstants.initializeDefaultValues(store);
    }

    public KenyaPartitionScanner getKenyaPartitionScanner() {
        if (this.fPartitionScanner == null) {
            this.fPartitionScanner = new KenyaPartitionScanner();
        }
        return this.fPartitionScanner;
    }

    public RuleBasedScanner getKenyaCodeScanner() {
        if (this.fCodeScanner == null) {
            this.fCodeScanner = new KenyaCodeScanner(this.getSyntaxColorProvider());
        }
        return this.fCodeScanner;
    }

    public DefaultSyntaxColorProvider getSyntaxColorProvider() {
        if (this.fColorProvider == null) {
            this.fColorProvider = new DefaultSyntaxColorProvider();
        }
        return this.fColorProvider;
    }

    public RuleBasedScanner getJavaCodeScanner() {
        if (this.fjCodeScanner == null) {
            this.fjCodeScanner = new JavaCodeScanner(this.getSyntaxColorProvider());
        }
        return this.fjCodeScanner;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return KenyaPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = KenyaPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = KenyaPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static String getPluginId() {
        return "kenya.eclipse";
    }

    public static void log(IStatus status) {
        KenyaPlugin.getDefault().getLog().log(status);
    }

    public static void log(String message) {
        KenyaPlugin.log(KenyaPlugin.createErrorStatus(message, null));
    }

    public static void log(String message, Throwable exception) {
        KenyaPlugin.log(KenyaPlugin.createErrorStatus(message, exception));
    }

    public static void log(Throwable e) {
        KenyaPlugin.log(KenyaPlugin.createErrorStatus(null, e));
    }

    private static IStatus createErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = "Internal Error";
        }
        return new Status(4, KenyaPlugin.getPluginId(), 4, message, exception);
    }

    public static void errorDialog(String message, IStatus status) {
        KenyaPlugin.log(status);
        Shell shell = KenyaPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)"Execution error:", (String)message, (IStatus)status);
        }
    }

    public static void errorDialog(String message, Throwable t) {
        KenyaPlugin.log(t);
        Shell shell = KenyaPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            IStatus status = KenyaPlugin.createErrorStatus("Error logged from Kenya Debugging: ", t);
            ErrorDialog.openError((Shell)shell, (String)"Execution error:", (String)message, (IStatus)status);
        }
    }

    public KenyaRunner getKenyaRunner() {
        if (this.fKenyaRunner == null) {
            this.fKenyaRunner = new KenyaRunner();
        }
        return this.fKenyaRunner;
    }

    public Collection getPostBuildAnalyserFactories() {
        if (this.fPostBuildAnalyserMap == null) {
            this.initializePostBuildAnalyserMap();
        }
        Collection c = this.fPostBuildAnalyserMap.values();
        ArrayList<IKenyaPostBuildAnalyserFactory> l = new ArrayList<IKenyaPostBuildAnalyserFactory>(c.size());
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            IConfigurationElement element = (IConfigurationElement)iter.next();
            try {
                l.add((IKenyaPostBuildAnalyserFactory)element.createExecutableExtension("class"));
            }
            catch (CoreException coreException) {}
        }
        return l;
    }

    protected void initializePostBuildAnalyserMap() {
        this.fPostBuildAnalyserMap = new HashMap(10);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(KenyaPlugin.getPluginId(), "postBuildAnalyserFactories");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            String id = infos[i].getAttribute("id");
            this.fPostBuildAnalyserMap.put(id, infos[i]);
            ++i;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public KenyaColourManager getKenyaColourManager() {
        if (this.fColourManager == null) {
            this.fColourManager = new KenyaColourManager();
        }
        return this.fColourManager;
    }
}

