/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ast;

import kenya.eclipse.ast.LastPositionFinder;
import kenya.errors.KenyaInternalError;
import kenya.passes.Util;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import minijava.node.Node;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class AdvancedPositionFinder {
    public static ISourceCodeLocation getFullLocation(Node node, IDocument doc) {
        int c;
        int b;
        int a;
        int[] start;
        ISourceCodeLocation end = LastPositionFinder.getLastLocation(node);
        try {
            start = Util.getFirstIdent((Node)node);
        }
        catch (KenyaInternalError kenyaInternalError) {
            return end;
        }
        int sline = start[0];
        int scol = start[1];
        int eline = end.getLineNumber();
        int ecol = end.getColumnNumber() + end.getTokenLength();
        if (eline != sline) {
            if (eline < sline || ecol <= scol || doc == null) {
                a = sline;
                b = scol;
                c = start[2];
            } else {
                try {
                    a = sline;
                    b = scol;
                    int startoffset = doc.getLineOffset(sline - 1) + scol - 1;
                    int endoffset = doc.getLineOffset(eline - 1) + ecol - 1;
                    c = endoffset - startoffset;
                }
                catch (BadLocationException badLocationException) {
                    a = sline;
                    b = 0;
                    c = 0;
                }
            }
        } else {
            a = sline;
            b = scol;
            c = ecol - scol;
        }
        return new SourceCodeLocation(a, b, c);
    }

    private AdvancedPositionFinder() {
    }
}

