/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ast;

import java.util.Iterator;
import kenya.eclipse.ast.NodeToString;
import kenya.eclipse.ast.bindings.ClassVariableBinding;
import kenya.eclipse.ast.bindings.EnumConstantBinding;
import kenya.eclipse.ast.bindings.IInnerVariableBinding;
import kenya.sourceCodeInformation.interfaces.IClass;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.AArrayDecInnerDeclaration;
import minijava.node.AClassDecDeclaration;
import minijava.node.ACommaEnumList;
import minijava.node.AEnumDecDeclaration;
import minijava.node.AEnumList;
import minijava.node.AFuncDecDeclaration;
import minijava.node.AVarDecInnerDeclaration;
import minijava.node.Node;
import minijava.node.PCommaEnumList;
import minijava.node.Start;
import minijava.node.Switch;
import minijava.node.TIdentifier;

class ClassFieldOrEnumConstantHelper
extends DepthFirstAdapter {
    private IClass cl;
    private TIdentifier id;
    private IInnerVariableBinding dec;

    ClassFieldOrEnumConstantHelper(TIdentifier t, IClass c) {
        this.id = t;
        this.cl = c;
    }

    public IInnerVariableBinding getSignature(Start start) {
        start.apply((Switch)this);
        return this.dec;
    }

    public void caseAClassDecDeclaration(AClassDecDeclaration node) {
        this.inAClassDecDeclaration(node);
        if (NodeToString.toString((Node)node.getIdentifier()).equals(this.cl.getName())) {
            Iterator it = node.getClassInnerDeclaration().iterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                n.apply((Switch)this);
                if (this.dec == null) continue;
                return;
            }
        }
        this.outAClassDecDeclaration(node);
    }

    public void caseAArrayDecInnerDeclaration(AArrayDecInnerDeclaration node) {
        if (node.getIdentifier().toString().equals(this.id.toString())) {
            String d = NodeToString.toString((Node)node);
            if (node.getArrayInitialiser() != null) {
                String init = NodeToString.toString((Node)node.getArrayInitialiser());
                d = d.substring(0, d.indexOf(init) - 1);
            }
            this.dec = new ClassVariableBinding((Node)this.id, this.cl, (Node)node, node.getType(), d);
        }
    }

    public void caseAVarDecInnerDeclaration(AVarDecInnerDeclaration node) {
        if (node.getIdentifier().toString().equals(this.id.toString())) {
            String d = NodeToString.toString((Node)node);
            if (node.getInitialiser() != null) {
                String init = NodeToString.toString((Node)node.getInitialiser());
                d = d.substring(0, d.indexOf(init) - 1);
            }
            this.dec = new ClassVariableBinding((Node)this.id, this.cl, (Node)node, node.getType(), d);
        }
    }

    public void caseAEnumDecDeclaration(AEnumDecDeclaration node) {
        if (node.getIdentifier() == this.id || node.getIdentifier().toString().equals(this.id)) {
            this.dec = new EnumConstantBinding((Node)this.id, this.cl, (Node)node, null, NodeToString.toString((Node)node));
            return;
        }
        if (node.getEnumList() != null) {
            node.getEnumList().apply((Switch)this);
        }
    }

    public void caseAEnumList(AEnumList node) {
        if (node.getIdentifier() == this.id || node.getIdentifier().toString().equals(this.id)) {
            this.dec = new EnumConstantBinding((Node)this.id, this.cl, (Node)node, null, NodeToString.toString((Node)node));
            return;
        }
        if (node.getCommaEnumList() != null) {
            Iterator it = node.getCommaEnumList().iterator();
            while (it.hasNext()) {
                PCommaEnumList list = (PCommaEnumList)it.next();
                list.apply((Switch)this);
            }
        }
    }

    public void caseACommaEnumList(ACommaEnumList node) {
        if (node.getIdentifier() == this.id || node.getIdentifier().toString().equals(this.id)) {
            this.dec = new EnumConstantBinding((Node)this.id, this.cl, (Node)node, null, NodeToString.toString((Node)node));
        }
    }

    public void caseAFuncDecDeclaration(AFuncDecDeclaration node) {
    }
}

