/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ast;

import kenya.eclipse.ast.ClassFieldOrEnumConstantHelper;
import kenya.eclipse.ast.ClassOrEnumHelper;
import kenya.eclipse.ast.ConstantHelper;
import kenya.eclipse.ast.Helper;
import kenya.eclipse.ast.IBinding;
import kenya.eclipse.ast.LocalVariableHelper;
import kenya.eclipse.ast.NodeTools;
import kenya.eclipse.ast.bindings.BuiltinMethodBinding;
import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.IVariable;
import mediator.ICheckedCode;
import minijava.node.ASimpleName;
import minijava.node.ASimpleNameName;
import minijava.node.Node;
import minijava.node.PName;
import minijava.node.Start;
import minijava.node.TIdentifier;

public class DeclarationFinder {
    DeclarationFinder() {
    }

    static IBinding resolveBinding(TIdentifier t, Start s) {
        Helper f = new Helper(t);
        return f.getSignature(s);
    }

    static IBinding resolveFunction(TIdentifier t, IFunction fun) {
        if (fun != null) {
            Start s = (Start)NodeTools.getParent((Node)fun.getDeclarationNode(), Integer.MAX_VALUE);
            if (s == null) {
                return null;
            }
            Helper f = new Helper(t, fun);
            return f.getSignature(s);
        }
        return new BuiltinMethodBinding(t);
    }

    static IBinding resolveLocal(PName name, IFunction f) {
        if (name instanceof ASimpleNameName) {
            ASimpleName n = (ASimpleName)((ASimpleNameName)name).getSimpleName();
            return DeclarationFinder.resolveLocal(n.getIdentifier(), f);
        }
        return null;
    }

    static IBinding resolveLocal(TIdentifier name, IFunction f) {
        LocalVariableHelper lf = new LocalVariableHelper(name, f);
        return lf.getSignature();
    }

    static IBinding resolveConstant(IVariable variable, ICheckedCode code) {
        Start s = (Start)NodeTools.getParent((Node)code.getFunctions()[0].getDeclarationNode(), Integer.MAX_VALUE);
        ConstantHelper cf = new ConstantHelper(variable);
        return cf.getSignature(s);
    }

    static IBinding resolveReferenceType(TIdentifier id, IClass c) {
        Start s = (Start)NodeTools.getParent((Node)id, Integer.MAX_VALUE);
        ClassFieldOrEnumConstantHelper rf = new ClassFieldOrEnumConstantHelper(id, c);
        return rf.getSignature(s);
    }

    static IBinding resolveClassOrEnum(TIdentifier id) {
        Start s = (Start)NodeTools.getParent((Node)id, Integer.MAX_VALUE);
        ClassOrEnumHelper cef = new ClassOrEnumHelper(id);
        return cef.getSignature(s);
    }
}

